package ca.tecreations;


import java.io.File;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
/**
 *
 * @author Tim
 */
public class Diff {
    DataInputStream fis1 = null;
    DataInputStream fis2 = null;
    byte byte1;
    byte byte2;
    boolean equal = true;
    boolean debug = false;
    
    public Diff(String file1, String file2) {
        try {
            fis1 = new DataInputStream(new FileInputStream(file1));
        } catch (FileNotFoundException fnfe) {
            System.out.println("File does not exist: " + file1);
            System.exit(0);
        }
        try {
            fis2 = new DataInputStream(new FileInputStream(new File(file2)));
        } catch (FileNotFoundException fnfe) {
            System.out.println("File does not exist: " + file2);
            System.exit(0);
        }
        for(int i = 0; i < new File(file1).length();i++) {
            try {
                byte1 = fis1.readByte();
                byte2 = fis2.readByte();
            } catch (IOException ioe) {
                System.out.println("IOException: " + ioe);
            }
            if (debug && byte1 != byte2) {
                System.out.println("Different at byte: " + i);
                equal = false;
            }
        }
        try {
            fis1.close();
            fis2.close();
        } catch (IOException ioe) {}
    }

    public void print() {
        System.out.println("Equal?: " + equal);
    }
    
    public boolean areEqual() { return equal; }
    
    public static void main(String[] args) {
        new Diff(args[0],args[1]).print();
    }
    
}
