package ca.tecreations;

import ca.tecreations.StringTool;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Tim
 */
public class Color extends java.awt.Color {
    
    public int alpha = 0;
    
    public static Color DIRTY = new Color(26,48,78);
    public static Color BROWN = new Color(78,48,26);

    public static Color BLACK = new Color(java.awt.Color.black.getRGB());
    public static Color WHITE = new Color(java.awt.Color.white.getRGB());
    public static Color BLUE = new Color(java.awt.Color.blue.getRGB());
    public static Color GREEN = new Color(java.awt.Color.green.getRGB());
    public static Color CYAN = new Color(java.awt.Color.cyan.getRGB());
    public static Color DARK_GREY = new Color(java.awt.Color.darkGray.getRGB());
    public static Color GREY = new Color(java.awt.Color.gray.getRGB());
    public static Color LIGHT_GREY = new Color(java.awt.Color.lightGray.getRGB());
    public static Color MAGENTA = new Color(java.awt.Color.magenta.getRGB());
    public static Color ORANGE = new Color(java.awt.Color.orange.getRGB());
    public static Color PINK = new Color(java.awt.Color.pink.getRGB());
    public static Color RED = new Color(java.awt.Color.red.getRGB());
    public static Color TRANSLUCENT = new Color(java.awt.Color.TRANSLUCENT);
    public static Color TRANSPARENT = new Color(-1);
    public static Color YELLOW = new Color(java.awt.Color.yellow.getRGB());
    
    // match the java Color constants
    public static Color black = new Color(java.awt.Color.black.getRGB());
    public static Color white = new Color(java.awt.Color.white.getRGB());
    public static Color blue = new Color(java.awt.Color.blue.getRGB());
    public static Color green = new Color(java.awt.Color.green.getRGB());
    public static Color grey = new Color(java.awt.Color.gray.getRGB());
    public static Color red = new Color(java.awt.Color.red.getRGB());
    public static Color cyan = new Color(java.awt.Color.cyan.getRGB());
    public static Color magenta = new Color(java.awt.Color.magenta.getRGB());
    public static Color yellow = new Color(java.awt.Color.yellow.getRGB());
    public static Color orange = new Color(java.awt.Color.orange.getRGB());
    public static Color pink = new Color(java.awt.Color.pink.getRGB());
    public static Color light_grey = new Color(java.awt.Color.lightGray.getRGB());
    public static Color dark_grey = new Color(java.awt.Color.darkGray.getRGB());
    
    public static Color TEC_ORANGE = new Color(245,130,32);
    public static Color TEC_PURPLE = new Color(75,0,130);
    public static Color TEC_LIGHT_GREEN = new Color(0,224,0);
    public static Color TEC_DARK_GREEN = new Color(12,82,42);

    public static final Color TEC_DARK_GREY = new Color(18,17,16);
    public static final Color TEC_LIGHT_GREY = new Color(248,249,250);
    
    public static Color TEC_SELECTED = new Color(102,204,255);
    public static Color DEFAULT_COLOR = TEC_SELECTED;
    public static final Color GREY_1 = new Color(15,15,15);      //16
    public static final Color GREY_2 = new Color(31,31,31);      //32
    public static final Color GREY_3 = new Color(47,47,47);      //48
    public static final Color GREY_4 = new Color(63,63,63);      //64
    public static final Color GREY_5 = new Color(79,79,79);      //80
    public static final Color GREY_6 = new Color(95,95,95);      //96
    public static final Color GREY_7 = new Color(111,111,111);   //
    public static final Color GREY_8 = new Color(127,127,127);   //
    public static final Color GREY_9 = new Color(143,143,143);   //
    public static final Color GREY_A = new Color(159,159,159);   //
    public static final Color GREY_B = new Color(175,175,175);   //
    public static final Color GREY_C = new Color(191,191,191);   //
    public static final Color GREY_D = new Color(207,207,207);   //
    public static final Color GREY_E = new Color(223,223,223);   //
    public static final Color GREY_F = new Color(239,239,239);   //
    public static final Color GREY_10 = GREY_A;
    public static final Color GREY_11 = GREY_B;
    public static final Color GREY_12 = GREY_C;
    public static final Color GREY_13 = GREY_D;
    public static final Color GREY_14 = GREY_E;
    public static final Color GREY_15 = GREY_F;
    public static final Color GREY_MAX = new Color(java.awt.Color.white);
    
    //https://chrisyeh96.github.io/2020/03/28/terminal-colors.html                
    public static Color BRIGHT_BLACK = new Color(85, 87, 83);
    public static Color BRIGHT_RED = new Color(239, 41, 41);
    public static Color BRIGHT_GREEN = new Color(138, 226, 52);
    public static Color BRIGHT_YELLOW = new Color(252, 233, 79);
    public static Color BRIGHT_BLUE = new Color(50, 175, 255);
    public static Color BRIGHT_MAGENTA = new Color(173, 127, 168);
    public static Color BRIGHT_CYAN = new Color(52, 226, 226);
    public static Color BRIGHT_WHITE = new Color(255, 255, 255);
            
    public static final Color DEFAULT_SWING_BG = new Color(new javax.swing.JPanel().getBackground());
    public static final Color SWING_DEFAULT_BG = DEFAULT_SWING_BG;
     
    public Color(int r, int g, int b) {
        super(r,g,b,255);
    }
    
    public Color(int a, int r, int g, int b) {
        super(r,g,b,a);
    }
    
    public Color(Alpha a, int r, int g, int b) {
        super(r,g,b,a.getValue());
    }
    
    public Color(int rgb) {
        super(rgb);
    }
    
    public Color(java.awt.Color color) {
        this(color.getRGB());
    }
    
    public static Color fromExternal(String s) {
        if (StringTool.isDoubleQuoted(s)) s = StringTool.getUnwrapped(s);
        if (!s.startsWith("Color[") && s.endsWith("]")) {
            throw new IllegalArgumentException("Color.fromExternal: malformed: " + s);
        }
        s = s.substring(6,s.length() - 1);
        List<String> parts = StringTool.explode(s,',');
        if (parts.size() != 4) {
            throw new IllegalArgumentException("Color.fromExternal: invalid parts size(" + parts.size() + "): '" + s + "'");
        }
        int a = Integer.parseInt(parts.get(0));
        int r = Integer.parseInt(parts.get(1));
        int g = Integer.parseInt(parts.get(2));
        int b = Integer.parseInt(parts.get(3));
        
        return new Color(a,r,g,b);
    }

    // END CONSTRUCTORS ---------------------------=============================
    
    public boolean equals(Object o) {
        if (o instanceof Color) {
            Color c = (Color)o;
            return equals(c);
        } else if (o instanceof java.awt.Color) {
            Color c = new Color((java.awt.Color)o);
            return equals(c);
        }
        return false;
    }
    
    public boolean equals(Color c) {
        return c.getAlpha() == getAlpha() && c.getRed() == getRed() && c.getGreen() == getGreen() && c.getBlue() == getBlue();
    }
    
    public boolean equals(java.awt.Color c) {
        return c.getAlpha() == getAlpha() && c.getRed() == getRed() && c.getGreen() == getGreen() && c.getBlue() == getBlue();
    }
    
    public java.awt.Color getJava() { 
        return new java.awt.Color(getRed(),getGreen(),getBlue());
    }
    
    public static Color getRandom() {
        return getRandomColor();
    }
    
    public static Color getRandomColor() {
        return new Color(Platform.getRandom(256),Platform.getRandom(256),Platform.getRandom(256));
    }
    
    public static Color getReverse(Color c) {
        return new Color(255 - c.getRed(), 255 - c.getGreen(),255 - c.getBlue());
    }
    
    public static Color getReverse(java.awt.Color c) {
        return new Color(255 - c.getRed(), 255 - c.getGreen(),255 - c.getBlue());
    }
    
    public static void main(String[] args) {
        // black
        System.out.println("Color.BLACK");
        System.out.println(Color.BLACK.toHex());
        
        System.out.println("Color.tec_purple");
        System.out.println(TEC_PURPLE.toString());
        System.out.println(TEC_PURPLE.toHex());
        
        System.out.println("Color.tec_orange");
        System.out.println(TEC_ORANGE.toString());
        System.out.println(TEC_ORANGE.toHex());
        
        // white
        System.out.println("Color.WHITE");
        System.out.println(Color.WHITE.toHex());
     
        System.out.println("Swing BG: " + DEFAULT_SWING_BG);
        
    }

    public String toExternal() {
        return "Color[" + getAlpha() + "," + getRed() + "," + getGreen() + "," + getBlue() + "]";
    }
    
    public String toString() {
        return "Color[a." + getAlpha() + ",r." + getRed() + ",g." + getGreen() + ",b." + getBlue() + "]";
    }
    
    public String toHex() {
        int hi_red = getRed() / 16;
        int lo_red = getRed() % 16;
        int hi_green = getGreen() / 16;
        int lo_green = getGreen() % 16;
        int hi_blue = getBlue() / 16;
        int lo_blue = getBlue() % 16;
        
        char hi_red_char = toHex(hi_red);
        char hi_green_char = toHex(hi_green);
        char hi_blue_char = toHex(hi_blue);
        char lo_red_char = toHex(lo_red);
        char lo_green_char = toHex(lo_green);
        char lo_blue_char = toHex(lo_blue);
        
        return "" + hi_red_char + lo_red_char + hi_green_char + lo_green_char + hi_blue_char + lo_blue_char;
    }
    
    public char toHex(int i) {
        if (i > 9) {
            if (i == 10) return 'A';
            if (i == 11) return 'B';
            if (i == 12) return 'C';
            if (i == 13) return 'D';
            if (i == 14) return 'E';
            if (i == 15) return 'F';
        }
        int j = (char)'0' + i;
        return (char)j;
    }
    
    public int toIntARGB() {
        int theInt = 0;
        theInt += ((getAlpha() & 0xFF) << 24);
        theInt += ((getRed() & 0xFF) << 16);
        theInt += ((getGreen() & 0xFF) << 8);
        theInt += (getBlue());
        return theInt;
    }
    
    public int toIntRGBA() {
        int theInt = 0;
        theInt += ((getRed() & 0xFF) << 24);
        theInt += ((getGreen() & 0xFF) << 16);
        theInt += ((getBlue() & 0xFF) << 8);
        theInt += getAlpha();
        return theInt;
    }
    
}
