package ca.tecreations;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

/**
 *
 * @author Tim
 */
public class BuildPackage {
    private static boolean standalone = false;
    private final Object lock = new Object();
    List<SystemToken> tokens = new ArrayList<>();
    SystemTool tool = new SystemTool();
    boolean debug = true;
    boolean quiet = true;
    int count = 0;
    public static boolean clean = true;
    int filesCount = 0;
    
    public BuildPackage(String pkg, boolean clean) {
//        tool.setDebug(true);
        long start = 0L;
        long stop = 0L;
        start = System.currentTimeMillis();
        System.out.println("Started: " + start);
        String classpathRoot = ProjectPath.getProjectPath();
        if (clean) {
            new Clean(classpathRoot + StringTool.replaceAll(pkg,".",File.separator), quiet);
        }
        doOp(classpathRoot, pkg);

        stop = System.currentTimeMillis();
        System.out.println("Stopped: " + stop);
        printElapsedTime(start, stop);
        // show our results;
        System.out.println("===================================================");
        int outCount = 0;
        int errCount = 0;
        for (int i = 0; i < tokens.size(); i++) {
            if (tokens.get(i).getType() == TecData.SYS_OUT) {
                outCount++;
            } else {
                errCount++;
            }
        }
        System.out.println("Files: " + filesCount + " Lines: " + tokens.size() + " Out: " + outCount + " Err: " + errCount);
        //if (tokens.size() > 0) tokens.get(0).tPrintSubst(tokens, true);
    }

    public void doOp(String classPath, File dir) {
        if (debug) {
            System.out.println("Processing: " + dir.getAbsolutePath());
        }
        File[] list = dir.listFiles();
        List<File> filesList = new ArrayList<>();
        List<File> dirsList = new ArrayList<>();
        File[] files = null;
        File[] dirs = null;
        if (list != null) {
            for (int i = 0; i < list.length; i++) {
                //System.out.println("Checking: " + list[i].getAbsolutePath() + " File: " + list[i].isFile() + " Extension: " + list[i].getExtension());
                if (list[i].isFile() && list[i].getExtension().equals("java")) {
                    filesList.add(list[i]);
                    //System.out.println("Found: " + list[i].getAbsolutePath());
                    filesCount++;
                } else if (list[i].isDirectory()) {
                    dirsList.add(list[i]);
                }
            }
            if (filesList.size() > 0) {
                files = Sort.sortByName(filesList);
            }
            if (dirsList.size() > 0) {
                dirs = Sort.sortByName(dirsList);
            }
        }
        if (files != null) {
            for (int i = 0; i < files.length; i++) {
                System.out.print(++count + ": ");
                tool.compile(StringTool.getUnwrapped(classPath), files[i], true);
                List<SystemToken> tokens = tool.getTokens();
                for(int j = 0; j < tokens.size();j++) {
                    this.tokens.add(tokens.get(j));
                }
                
            }
        }
        if (dirs != null) {
            for (int i = 0; i < dirs.length; i++) {
                doOp(classPath, dirs[i]);
            }
        }
        
    }

    public void doOp(String classPath, String pkg) {
        if (debug) {
            System.out.println("Processing: classPath: " + classPath + " pkg: " + pkg);
        }
        String path = classPath + StringTool.replaceAll(pkg,".",File.separator);
        System.out.println("Path: " + path);
        File[] list = new File(path).listFiles();
        List<File> filesList = new ArrayList<>();
        List<File> dirsList = new ArrayList<>();
        File[] files = null;
        File[] dirs = null;
        if (list != null) {
            for (int i = 0; i < list.length; i++) {
                //System.out.println("Checking: " + list[i].getAbsolutePath() + " File: " + list[i].isFile() + " Extension: " + list[i].getExtension());
                if (list[i].isFile() && list[i].getExtension().equals("java")) {
                    filesList.add(list[i]);
                    //System.out.println("Found: " + list[i].getAbsolutePath());
                    filesCount++;
                } else if (list[i].isDirectory()) {
                    dirsList.add(list[i]);
                }
            }
            if (filesList.size() > 0) {
                files = Sort.sortByName(filesList);
            }
            if (dirsList.size() > 0) {
                dirs = Sort.sortByName(dirsList);
            }
        }
        if (files != null) {
            for (int i = 0; i < files.length; i++) {
                System.out.print(++count + ": ");
                tool.compile(StringTool.getUnwrapped(classPath), files[i], true);
                List<SystemToken> tokens = tool.getTokens();
                for(int j = 0; j < tokens.size();j++) {
                    this.tokens.add(tokens.get(j));
                }
                
            }
        }
        if (dirs != null) {
            for (int i = 0; i < dirs.length; i++) {
                doOp(classPath, dirs[i]);
            }
        }
        
    }

    public static void launch(String pkg, boolean clean) {
        //System.out.println("BuildProject.launch: " + classPath);
        new BuildPackage(pkg, clean);
        //if (buildNet) new BuildPackage("ca.tecreations.net",clean);
        if (standalone) System.exit(0);
    }

    public static void main(String[] args) {
        if (Platform.getRuntimePath().endsWith(".jar")) {
            System.err.println("BuildPackage doesn't work on jars, yet.");
        }
        clean = true;
        standalone = true;
        launch("ca.tecreations.apps._gui", clean);
    }

    public static void printElapsedTime(long start, long stop) {
        long total = stop - start;
        Date date = new Date(total);
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String formatted = formatter.format(date);
        System.out.println("Elapsed Time: (" + total + "): " + formatted);
    }

    public static void usage() {
        System.out.println("Usage: java -cp ... BuildProject [projectDir||classpath||.]");
        System.exit(0);
    }
}
