import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.components.TFrame;

import java.awt.AWTException;
//import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener; 
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
/**
 *
 * @author Tim
 */
public class RemoveClassPathEntriesFromNetbeansProject extends TFrame implements ActionListener, MouseListener, MouseMotionListener, WindowListener {
    public static ProjectPath pp;
    public Robot robot = null;
    public static RemoveClassPathEntriesFromNetbeansProject instance = null;
    String[] args;
    JPanel imagePanel = new JPanel(null,false);
    BufferedImage image = null;
    //JScrollPane scroller = null;
    boolean sized = false;
    
    // image xy
    int x = 0;
    int y = 0;
    
    // motion xy
    private int lastX;
    private int lastY;
    private int lastXScreen;
    private int lastYScreen;
    private int offsetX;
    private int offsetY;

    JMenuBar jmenubar = new JMenuBar();
    JMenu ops = new JMenu("ops");
    JMenuItem recapture = new JMenuItem("Re-Capture");
    
    
    public RemoveClassPathEntriesFromNetbeansProject(final String[] args) {
        // take from the current applications settings to derive ProjectPath.getPropertiesPath
        super(pp.getPropertiesPath() + "ScreenControlTool.properties","RemoveClassPathEntriesFromNetBeansProject");
        this.args = args;
        try {
            robot = new Robot();
        } catch (AWTException awte) {
            System.err.println("Unable to create robot... Exiting.");
            System.exit(-1);
        }
        
        image = captureDesktop();
        // this
        setLayout(null);
        add(imagePanel);
        // or this
        //setLayout(new BorderLayout());
        //scroller = new JScrollPane(imagePanel,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        //add(scroller,BorderLayout.CENTER);
        imagePanel.addMouseListener(this);
        imagePanel.addMouseMotionListener(this);
        addWindowListener(this);
        
        // setup menu
        ops.add(recapture);
        recapture.addActionListener(this);
        jmenubar.add(ops);
        setJMenuBar(jmenubar);
        // new op
        // recapture
        
    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(recapture)) {
            recapture();
            repaint();
        } 
    }
    
    public BufferedImage captureDesktop() {
        image = robot.createScreenCapture(Platform.getDesktopSize());
        return image;
    }


    public static void createAndShowGUI(final String[] args) {
        instance = new RemoveClassPathEntriesFromNetbeansProject(args);
        instance.setVisible(true);
    }
    
    public Dimension getOffset(MouseEvent e) {
        Dimension offset = new Dimension(0,0);
        
        return offset;
    }
    
    public static void launch(final String[] args) {
        SwingUtilities.invokeLater(() -> {
            createAndShowGUI(args);
        });
    }
    
    public static void main(String[] args) {
        launch(args);
    }
    
    public void mouseClicked(MouseEvent e) {
        if (e.isControlDown()) {
            java.awt.Point appLoc = getLocation();
            java.awt.Point oldMouseOnScreen = new Point(appLoc.x + e.getX(),appLoc.y + e.getY());
            int mouseX = Math.abs(x) + e.getX();
            int mouseY = Math.abs(y) + e.getY();
            System.out.println("Moving To: " + mouseX + "," + mouseY);
            robot.mouseMove(mouseX,mouseY);
            for(int i = 0; i < 500; i++) {
                robot.mousePress(InputEvent.BUTTON1_DOWN_MASK);
                robot.mouseRelease(InputEvent.BUTTON1_DOWN_MASK);
            }
            toFront(); 
            robot.mouseMove(oldMouseOnScreen.x,oldMouseOnScreen.y);
            System.out.println("Action: Done.");
        }
    }
    
    public void mouseDragged(MouseEvent e) {
        Dimension offset = getOffset(e);
        int newX;
        int newY;
        movable_mouseDragged(e);
        updateLast(e);
        System.out.println("Drag: New Coordinates: " + lastX + "," + lastY + " : Screen: " + lastXScreen + "," + lastYScreen);
        repaint(); // show where it should be. No need to worry about .... move...
    }
    
    public void mouseEntered(MouseEvent e) {}
    
    public void mouseExited(MouseEvent e) {}
    
    public void mouseMoved(MouseEvent e) {
//        Dimension offset = getOffset(e);
        
        updateLast(e);
        System.out.println("Move: New Coordinates: " + lastX + "," + lastY + " : Screen: " + lastXScreen + "," + lastYScreen);
    }
 
    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {}

    public void movable_mouseDragged(MouseEvent e) {
        java.awt.Point loc = e.getLocationOnScreen();
        // check bounds 
        if (e.getX() >= 0 && e.getX() <= Platform.getDesktopSize().getWidth()) {
            offsetX = lastX - e.getX();
        }
        if (e.getY() >= 0 && e.getY() <= Platform.getDesktopSize().getHeight()) {
            offsetY = lastY - e.getY();
        }
        // using e.getX/e.getY
        int evtXOffset = -(lastX - e.getX());
        int evtYOffset = -(lastY - e.getY());
        int scrXOffset = -(lastXScreen - loc.x);
        int scrYOffset = -(lastYScreen - loc.y);
        if (e.getX() < 0 || e.getX() >= imagePanel.getSize().width ||
            e.getY() < 0 || e.getY() >= imagePanel.getSize().height) {
            System.err.println("Not restricted to screen bounds. Must Adjust Code Accordingly");
        }
        System.out.print("movable_mouseDragged: offset: " + evtXOffset + "," + evtYOffset + " : screen: " + scrXOffset + "," + scrYOffset + " ");
        // you should do a test here, to ensure, they're both equal to verify your code is correct.
        
        if (evtXOffset == scrXOffset && evtYOffset == scrYOffset) {
            x += evtXOffset; // whether positive or negative, within bounds of ImagePanel
            y += evtYOffset; // doesn't matter what we use, evt, or screen
        }
        
        // failure is not an option throw new ArithmaticException("programming failure"_
        
        // and repaint()
        
        updateLast(e);
    }
    
    public void paint(Graphics g) {
        if (!sized) {
            if (!imagePanel.getSize().equals(Platform.getDesktopSize())) {
                Rectangle rect = Platform.getDesktopSize();
                imagePanel.setSize((int)rect.getWidth(),(int)rect.getHeight());
                revalidate();
            }
            sized = true;
        }
        super.paint(g);
        g = imagePanel.getGraphics();
        g.drawImage(image,x,y,this);
        System.out.println("ImagePanel: size: " + imagePanel.getSize());
        System.out.println("Image     : size: " + image.getWidth() + "," + image.getHeight());
    }
    
    public void recapture() {
        setVisible(false);
        while (instance.isVisible()) { Platform.sleep(125); }
        captureDesktop();
        setVisible(true);
        repaint();
    }

    public void updateLast(MouseEvent e) {
        lastX = e.getX();
        lastY = e.getY();
        lastXScreen = e.getLocationOnScreen().x;
        lastYScreen = e.getLocationOnScreen().y;
    }
    
    public void windowActivated(WindowEvent e) {
        while (!isVisible()) {
            recapture();
            Platform.sleep(3000);
            repaint();
        }
    }

    public void windowDeactivated(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}
}
