import ca.tecreations.File;

import ca.tecreations.ProjectPath;
import ca.tecreations.TecData;

import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author tim
 */
public class DirDiff {
    private List<String> inBoth = new ArrayList<>();
    private List<String> aOnly = new ArrayList<>();
    private List<String> bOnly = new ArrayList<>();
     
    public List<List<String>> results = new ArrayList<>();
    
    
    public DirDiff(File a, File b) {
        dirDiff(a,b);
    }
    
    public DirDiff(File a, String b) {
        dirDiff(a,new File(b));
    }
    
    public DirDiff(String a, File b) {
        dirDiff(new File(a),b);
    }
    
    public void dirDiff(File a, File b) {
        process(a,b);
        results.add(inBoth);
        results.add(aOnly);
        results.add(bOnly);
    }
    
    public List<List<String>> getResults() {
        return results;
    }

    public static void main(String[] args) {
        DirDiff diff = new DirDiff(
            new File(ProjectPath.getProjectsHome() + 
                     TecData.TEC_VERSION + 
                     File.separator)
            ,
            new File(ProjectPath.getProjectsHome() + 
                     TecData.TEC_VERSION + "_diff_test" + 
                     File.separator)
        );
        List<List<String>> results = diff.getResults();
        for( int i = 0; i < results.size();i++) {
            List<String> group = results.get(i);
            if (i == 0) System.out.println("Both:");
            else if (i == 1) System.out.println("A Only:");
            else System.out.println("B Only:");
            for(int j = 0; j < group.size();j++) {
                System.out.println(j + ": " + group.get(j));
            }
        }
    }
    
    public void process(File a, File b) {
        if (!a.isDirectory()) {
            throw new IllegalArgumentException("DirDiff: Not a directory: " + a.getAbsolutePath());
        }
        if (!b.isDirectory()) {
            throw new IllegalArgumentException("DirDiff: Not a directory: " + b.getAbsolutePath());
        }
        inBoth = new ArrayList<>();
        aOnly = new ArrayList<>();
        bOnly = new ArrayList<>();
        File[] Aes = a.listFiles();
        File[] Bees = b.listFiles();
        if (!(Aes == null) && (!(Bees == null))) {
            System.out.println("Sorting both >= 1");
            // do for both: size >= 1;
            for(int i = 0; i < Aes.length;i++) {
                String target = Aes[i].getName();
                boolean found = false;
                for(int j = 0; j < Bees.length;j++) {
                    if (Bees[j].getName().equals(target)) {
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    aOnly.add(target);
                } else {
                    inBoth.add(target);
                }
            }
            for(int i = 0; i < Bees.length;i++) {
                String target = Bees[i].getName();
                boolean found = false;
                for(int j = 0; j < Aes.length;j++) {
                    if (Aes[j].getName().equals(target)) {
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    bOnly.add(target);
                }
            }
            
        } else if (Aes == null && (!(Bees == null))) {
            for(int i = 0; i < Bees.length;i++) {
                bOnly.add(Bees[i].getName());
            }
        } else if ((!(Aes == null)) && Bees == null) {
            for(int i = 0; i < Aes.length;i++) {
                aOnly.add(Aes[i].getName());
            }
        } else {
            // both are null, do nothing, return empty
        }
    }
}
