package ca.tecreations.wip.toy;

//import uhn.PayPeriod;
import ca.tecreations.text.JavaParser;
import ca.tecreations.TColor;
import ca.tecreations.File;
import ca.tecreations.Font;
import ca.tecreations.Platform;
import ca.tecreations.Point;
import ca.tecreations.ProjectPath;
import ca.tecreations.TecData;
import ca.tecreations.TextToken;
import ca.tecreations.components.TFrame;
import ca.tecreations.text.GUITextTokenPainter;
import ca.tecreations.text.TextPoints;
import ca.tecreations.graphics.Arc;
import ca.tecreations.graphics.BezierCurve;
import ca.tecreations.graphics.Circle;
import ca.tecreations.graphics.Line;
import ca.tecreations.graphics.PieChart;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

/**
 *
 * @author tim
 */
public class Toy extends TFrame implements ActionListener, MouseListener,
        MouseMotionListener {
    public static Toy instance;
    MultiPanel multi;
    
    Line line;
    Circle circle;
    Arc arc;
    BezierCurve bezierCurve;
    
    GUITextTokenPainter title = new GUITextTokenPainter(TecData.ARIAL_B_16, new TextToken("Title"));
    GUITextTokenPainter text = new GUITextTokenPainter(TextPoints.getInstance(new Font("Times New Roman",Font.PLAIN,14)), new TextToken("Text"));
    GUITextTokenPainter keyword = new GUITextTokenPainter(TecData.LG_CODE_POINTS,new TextToken("public"));
    
    NewsLinks news = new NewsLinks();

    CalendarComp calendar = new CalendarComp();
    
    PieChart pieChart;
    
//    PayPeriod payPeriod;
    
    Add add = new Add();
    
    Timer timer;
    
    File clientCodeFile = new File(ProjectPath.getProjectPath() + ProjectPath.getSubPath("ca.tecreations.net") + "Client.java");
    CodeJava clientCode = new CodeJava(clientCodeFile);
    
    File serverCodeFile = new File(ProjectPath.getProjectPath() + ProjectPath.getSubPath("ca.tecreations.net") + "Server.java");
    CodeJava serverCode = new CodeJava(serverCodeFile);

    File TNDataCodeFile = new File(ProjectPath.getProjectPath() + ProjectPath.getSubPath("ca.tecreations.net") + "TNData.java");
    CodeJava tnDataCode = new CodeJava(TNDataCodeFile);


    public Toy() {
        super(ProjectPath.getTecreationsPath() + "properties" + File.separator + "Toy.properties","Toy");
        setupGUI();
        line = new Line();
        line.setEndPoint(100,100);
        circle = new Circle(100);
        circle.setTXY(new Point(50,50));
        circle.setFillColor(TColor.white);
        arc = new Arc(50).setSize(350).setRotation(15);
        arc.setFillColor(TColor.white);
        arc.setShowLines(true).setTXY(300,100);
        bezierCurve = new BezierCurve(TColor.blue,BezierCurve.UP_RIGHT);
        bezierCurve.setTXY(new Point(150,150));
        bezierCurve.setDrawLines(false);
        multi.addPaintable(line);
        multi.addPaintable(circle);
        multi.addPaintable(arc);
        multi.addPaintable(bezierCurve);
        multi.setSpacing(10,10);
        
//        multi.addPaintable(title);
//        title.setLocation(5,120);
        
  //      multi.addPaintable(text);
  //      text.setLocation(5,title.getLocation().y + title.getHeight());
        
        multi.addPaintable(keyword);
        keyword.setLocation(5,text.getLocation().y + text.getHeight());
        //System.out.println("Keyword: " + _public.getText() + " ?: " + JavaParser.isKeyword(_public.getText()));
        if (JavaParser.isKeyword(keyword.getText())) {
            keyword.setForeground(TColor.blue);
        }
          
//        NewsLinks news = new NewsLinks();
//        multi.addPaintable(news);
//        news.setLocation(15,224);
        //linkToCTV.setBackground(Color.BRIGHT_YELLOW);
        //news.setBackground(Color.YELLOW);
         
        multi.addPaintable(calendar);
        calendar.setLocation(565,15);
        
        multi.addPaintable(clientCode);
        multi.addPaintable(serverCode);
        multi.addPaintable(tnDataCode);
        
        tnDataCode.setLocation(100,300);
        clientCode.setLocation(400,300);
        serverCode.setLocation(700,300);
        
        
        PieChart pieChartTest = getTestPieChart();
        pieChartTest.addTranslation(500,75);
        multi.addPaintable(pieChartTest);
        
//        payPeriod = new PayPeriod(new Date(2024,6,1),new Date(2024,6,16),2);
//        multi.addPaintable(payPeriod);
//        payPeriod.setLocation(150,280);
        
        multi.addPaintable(add);
        add.setLocation(550,150);
        
        multi.addMouseListener(this);
        multi.addMouseMotionListener(this);
        
        //Platform.hideCursor(this);
        //timer = new Timer(5000,this);
        //timer.start();
    }
    
    @Override
    public void actionPerformed(ActionEvent e) {
        System.out.println("Current Cursor: " + Platform.getCursorString(this));
        Platform.setDefaultCursor(this);
    }
    
    public void addLineAtPoint(int x, int y) {
        Line line = new Line();
        line.setTXY(x,y);
        line.setEndPoint(1,1);
        multi.addPaintable(line);
    }
    
    public PieChart getTestPieChart() {
        List<Integer> percents = new ArrayList<>();
        List<TColor> colors = new ArrayList<>();
        percents.add(12);
        percents.add(28);
        percents.add(14);
        percents.add(16);
        percents.add(20);
        percents.add(10);
        colors.add(TColor.TEC_ORANGE);
        colors.add(TColor.TEC_PURPLE);
        colors.add(TColor.TEC_LIGHT_GREY);
        colors.add(TColor.red);
        colors.add(TColor.white);
        colors.add(TColor.magenta);
        return new PieChart(100,percents,colors);
    }
    
    public static void createAndShowGUI() {
        instance = new Toy();
        instance.setVisible(true);
    }
    
    public static void launch() {
        SwingUtilities.invokeLater(() -> {
            createAndShowGUI();
        });
    }
    
    public static void main(String[] args) {
        launch();
    }
    
    public void mouseClicked(MouseEvent e) {}
    
    public void mouseDragged(MouseEvent e) {
        addLineAtPoint(e.getX(),e.getY());
    }
    
    public void mouseEntered(MouseEvent e) {}
    
    public void mouseExited(MouseEvent e) {}
    
    public void mouseMoved(MouseEvent e) {}
    
    public void mousePressed(MouseEvent e) {
        addLineAtPoint(e.getX(),e.getY());
    }
    
    public void mouseReleased(MouseEvent e) {}
    
    public void paint(Graphics g) {
        multi.repaint();
    }
    
    public void setupGUI() {
        JPanel holder = new JPanel();
        add(holder,BorderLayout.CENTER);
        validate();
        Dimension size = holder.getSize();
        multi = new MultiPanel(size);
        remove(holder);
        add(multi,BorderLayout.CENTER);
        validate();
    }
    
}
