package ca.tecreations.apps.filetool;

import ca.tecreations.File;
import ca.tecreations.StringTool;
import ca.tecreations.TecData;
import ca.tecreations.TextFile;
import ca.tecreations.net.backup.TLSClient_TVS12;

import java.util.List;
/**
 *
 * @author Tim
 */
public class CopyOnHost extends Thread {
    FileTool app;
    TLSClient_TVS12 client;
    TextFile log;
    String srcPath;
    List<String> names;
    String dstPath;
    
    public CopyOnHost(FileTool app,TextFile log,TLSClient_TVS12 client,String srcPath, List<String> names, String dstPath) {
        this.app = app;
        this.client = client;
        this.log = log;
        this.srcPath = srcPath;
        this.names = names;
        this.dstPath = dstPath;
    }
    
    public void run() {
        String name;
        for(int i = 0; i < names.size();i++) {
            name = names.get(i);
            if (srcPath.equals(dstPath)) {
                if (!TecData.isDir(name)) {
                    // copy file
                    String nextFile = client.getNextFileName(name);
                    log.add("Equal: File: " + name + " Next: " + nextFile);
                    client.copyFileToFile(name,nextFile);
                } else {
                    String nextDir = client.getNextDirectoryName(name);
                    log.add("Equal: Dir: " + name + " Next: " + nextDir);
                    client.copyDirectory(name,StringTool.getDoubleQuoted(nextDir));
                }
            } else {
                if (TecData.isDir(name)) {
                    log.add("Dir: dst: " + dstPath);
                    String subPath = new File(name).getDeepestDirectoryName() + client.getFileSeparator();
                    client.copyDirectory(name,dstPath + subPath);
                } else {
                    log.add("File: dst: "+ dstPath);
                    client.copyFileToDir(name,dstPath);
                }
            }
            app.refreshLast();
        }
    }
    
}
