package ca.tecreations.apps._gui;

import ca.tecreations.apps._gui.renderer.*;
/**
 *
 * @author tim
 */
public class FileEntriesTableModelPOSIX extends FileEntriesTableModel {
    protected String[] columnNames;
    protected Class[] columnClass;

    public FileEntriesTableModelPOSIX(EntriesPanel panel, FileEntriesTable table) {
        super(panel,table);
        columnNames = new String[] {
            "Name", "Size", "JVM Perms.", "Modified", "Owner", "Group", "File Permissions"
        };
        columnClass = new Class[] {
            FileTypeRenderer.class, FileSizeRenderer.class, AppAccessRenderer.class, FileDateRenderer.class, ModifiableTextRenderer.class, ModifiableTextRenderer.class, FilePermissonsRenderer.class
        };
    }
    
    @Override
    public String getColumnName(int column)
    {
        return columnNames[column];
    }
 
    @Override
    public Class<?> getColumnClass(int columnIndex)
    {
        return columnClass[columnIndex];
    }
  
    @Override
    public int getColumnCount()
    {
        return columnNames.length;
    }
}
