package ca.tecreations.wip.toy;
//codeToy
import ca.tecreations.wip.toy.editors.CodeEdit;
import ca.tecreations.text.JavaParser;
import ca.tecreations.TColor;
import ca.tecreations.File;
import ca.tecreations.ProjectPath;
import ca.tecreations.TecData;
import ca.tecreations.TextToken;
import ca.tecreations.components.TFrame;
import ca.tecreations.text.GUITextTokenPainter;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;

import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/**
 *
 * @author tim
 */
public class CodeToy extends TFrame {
    public static CodeToy instance;
    MultiPanel multi;
    
    String srcPath = ProjectPath.getProjectPath() + "ca" + File.separator + "tecreations" + File.separator +
                               "wip" + File.separator + "toy" + File.separator;

    GUITextTokenPainter keyword = new GUITextTokenPainter(TecData.LG_CODE_POINTS,new TextToken("public"));

    String blockID = "block1";
    CodeFile file = new CodeFile(srcPath + "CodeFile.java");
    CodeFile toySrc = new CodeFile(srcPath + "Toy.java");
    CodeBlock block = new CodeBlock(blockID,new ArrayList<>());
    CodeJava java = new CodeJava(srcPath + "CodeJava.java");
    
    CodeEdit editor = new CodeEdit(240,720);
    
    public CodeToy() {
        super(ProjectPath.getTecreationsPath() + "properties" + File.separator + "Toy.properties","Toy");
        setupGUI();
        multi.setSpacing(10,10);
        toySrc.setLocation(200,200); 
        toySrc.setBackground(TColor.TEC_PURPLE);
        file.setLocation(300,200);
        file.setBackground(TColor.TEC_ORANGE);
        block.setLocation(400,200);
        block.setBackground(TColor.TEC_LIGHT_GREEN);
        block.read(srcPath + "CodeBlock.java");
        java.setLocation(500,200);
        java.setBackground(TColor.TEC_DARK_GREEN);
        
        if (JavaParser.isKeyword(keyword.getText())) {
            keyword.setForeground(TColor.blue);
        }
        multi.addPaintable(keyword);
        multi.addPaintable(toySrc);
        multi.addPaintable(file);
        multi.addPaintable(block);
        multi.addPaintable(java);
        multi.addPaintable(editor);
        editor.setLocation(500,500);
        
        setExitOnClose(true);
    }
    
    public static void createAndShowGUI() {
        instance = new CodeToy();
        instance.setVisible(true);
    }
    
    public static void launch() {
        SwingUtilities.invokeLater(() -> {
            createAndShowGUI();
        });
    }
    
    public static void main(String[] args) {
        launch();
    }
    
    public void paint(Graphics g) {
        multi.repaint();
    }
    
    public void setupGUI() {
        JPanel holder = new JPanel();
        add(holder,BorderLayout.CENTER);
        validate();
        Dimension size = holder.getSize();
        multi = new MultiPanel(size);
        remove(holder);
        add(multi,BorderLayout.CENTER);
        validate();
    }
    
}
