package ca.tecreations.wip.toy;
//CodeFile
import ca.tecreations.File;
import ca.tecreations.TextFile;
import ca.tecreations.components.Movable;

import java.awt.Graphics;
import java.util.List;
import ca.tecreations.interfaces.Paintable;
import java.awt.event.MouseEvent;

/**
 *
 * @author tim
 */
public class CodeFile extends Movable implements Paintable {
    public static final String SN = CodeFile.class.getSimpleName();
    File file;
    String name;
    final List<String> lines;
    public boolean tracePaint = false;
    
    public CodeFile(File file) {
        super(NONE);
        this.file = file;
        lines = new TextFile(file.getAbsolutePath()).getLines();
    }
    
    public CodeFile(String absPath) {
        super(NONE);
        this.file = new File(absPath);
        lines = new TextFile(absPath).getLines();
        trace = true;
    }
    
    @Override
    public void doPainting(Graphics g) {
        for(int i = 0;i < lines.size();i++) {
            System.out.println(lines.get(i));
        }
    }
    
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        System.out.println("CodeFile: " + name);
    }
    
    public void paint(Graphics g) {
        if (tracePaint) System.out.println(SN + ".paint");
        doPainting(g);
    }
    
    public void paintComponent(Graphics g) {
        if (tracePaint) System.out.println(SN + ".paintComponent");
        doPainting(g);
    }
}
