package ca.tecreations.wip.toy;

import ca.tecreations.TColor;
import ca.tecreations.components.Button;
import ca.tecreations.components.Movable;

import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author tim
 */
public class NewsLinks extends Movable {
    static List<Link> links = new ArrayList<>(); 
    static {
        links.add(new Link("https://aptn.ca"));
        links.add(new Link("https://ctvnews.ca"));
        links.add(new Link("https://cbc.ca"));
        links.add(new Link("https://abc.com"));
        links.add(new Link("https://cbs.com"));
        links.add(new Link("https://cnn.com"));
        links.add(new Link("https://fox.com"));
        links.add(new Link("https://kxly.com"));
        links.add(new Link("https://nbcnews.com"));
    }
    
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    
    public int orientation = VERTICAL;
    
    private Button button;
    
    public NewsLinks() {
        super(NONE);
        setSize(20,20);
        setBackground(TColor.cyan);
        setupGUI();
    }
    
    public NewsLinks(List<Link> links) {
        super(NONE);
        setSize(20,20);
        setBackground(TColor.magenta);
        this.links = links;
        setupGUI();
    }
    
    public int getMaxWidth() {
        int width = 0;
        for(int i = 0; i < links.size();i++) {
            width = Math.max(width,links.get(i).getWidth());
        }
        return width;
    }
    
    public int getItemIndexWithY(int y) {
        int returnIndex = 0;
        int lineHeight = links.get(0).getHeight();
        int i = 0;
        int itemY;
        for(; i < links.size();i++) {
            itemY = i * lineHeight;
            if (y >= itemY && (itemY + lineHeight) >= y) {
                return i;
            }
        }
        return returnIndex; // should be -1, but anyway
    }
    
    
    public String getURL(int index) {
        return links.get(index).getURL();
    }
    
    public void mouseClicked(MouseEvent e) {
        String url = "";
        System.out.println("e: " + e.toString());
        int y = e.getY();
        int index = getItemIndexWithY(y);
        //System.out.println("NewsLinks: Got Index: " + index);
        url = getURL(index);
        if (e.isControlDown()) {
            open(url);
        }
    }
    
    public void open(String url) {
        // open browser to url
        System.out.println("Opening: " + url);
    }

    public void setupGUI() {
        setLayout(null);
        for(int i = 0; i < links.size();i++) add(links.get(i));
        boolean vertical = orientation == VERTICAL;
        int wide = orientation == VERTICAL ? getMaxWidth() : links.get(0).getWidth() * links.size();
        int high = orientation == VERTICAL ? links.get(0).getHeight() * links.size() : links.get(0).getHeight();
        Link previous;
        int x = 0;
        int y = 0;
        if (vertical) {
            // links(0) is already at (0,0)
            for(int i = 1; i < links.size();i++) {
                previous = links.get(i - 1);
                links.get(i).setLocation(0,y + previous.getHeight());
                y += previous.getHeight();
            }
        } else {
            for(int i = 1; i < links.size();i++) {
                previous = links.get(i - 1);
                links.get(i).setLocation(x + previous.getWidth(),0);
                x += previous.getWidth();
            }
        }
        setSize(wide,high);
        //for(int i = 0; i < links.size();i++) {
        //    links.get(i).addMouseListener(this);
        //}
    }
}
