package ca.tecreations.wip.toy;
//codeToy
import ca.tecreations.wip.toy.editors.CodeEdit;
import ca.tecreations.text.JavaParser;
import ca.tecreations.TColor;
import ca.tecreations.File;
import ca.tecreations.ProjectPath;
import ca.tecreations.TecData;
import ca.tecreations.TextToken;
import ca.tecreations.components.TFrame;
import ca.tecreations.text.GUITextTokenPainter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;

import javax.swing.JPanel;
import javax.swing.SwingUtilities; 

/**
 *
 * @author tim
 */
public class CodeToy extends TFrame {
    public static CodeToy instance;
    MultiPanel multi;
    
    String srcPath = ProjectPath.getProjectPath() + "ca" + File.separator + "tecreations" + File.separator +
                               "wip" + File.separator + "toy" + File.separator;

    GUITextTokenPainter keyword = new GUITextTokenPainter(TecData.LG_CODE_POINTS,new TextToken("public"));

    CodeEdit editor = new CodeEdit(1080,480);
    
    public CodeToy() {
        super(ProjectPath.getTecreationsPath() + "properties" + File.separator + "Toy.properties","Toy");
        setupGUI();
        multi.setSpacing(10,10);
        
        if (JavaParser.isKeyword(keyword.getText())) {
            keyword.setForeground(TColor.blue);
        }
        multi.addPaintable(keyword);
        multi.addPaintable(editor);
        editor.setLocation(100,400);
        editor.open(srcPath + "editors" + File.separator + "CodeEdit.java");
        setExitOnClose(true);
        multi.setOutlineColor(Color.RED);
        multi.setXColor(Color.red);
    }
    
    public static void createAndShowGUI() {
        instance = new CodeToy();
        instance.setVisible(true);
    }
    
    public static void launch() {
        SwingUtilities.invokeLater(() -> {
            createAndShowGUI();
        });
    }
    
    public static void main(String[] args) {
        launch();
    }
    
    public void paint(Graphics g) {
        super.paint(g);
        multi.paint(multi.getGraphics());
    }
    
    public void setupGUI() {
        multi = new MultiPanel();
        add(multi,BorderLayout.CENTER);
        validate();
    }
    
}
