package ca.tecreations.icons;

import ca.tecreations.File;
import ca.tecreations.TColor;
import ca.tecreations.ImageTool;
import ca.tecreations.components.Magnifier;

import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.image.BufferedImage;

/**
 * 
 * @author Tim
 */
public class GetSamplelcon {

    public GetSamplelcon() {
        
    }
    
    public BufferedImage getPainted(BufferedImage start) {
        Graphics g = start.getGraphics();
        int leftX = start.getWidth() - 8;
        int rightX = start.getWidth() - 2;
        int topY = start.getHeight() - 14;
        int botY = start.getHeight() - 2;
        int midY = 6;
        int[] exes = new int[] { leftX,rightX,leftX };
        int[] wyes = new int[] { topY,topY + midY,botY };
        Polygon phyll = new Polygon(exes,wyes,3);
        g.setColor(TColor.TEC_LIGHT_GREEN);
        g.fillPolygon(phyll);
        
        // outline
        int oLX = leftX - 1;
        int oRX = rightX;
        int oTY = topY - 1;
        int oBY = botY + 1;
        int[] outlineExes = new int[] { oLX,oRX,oLX };
        int[] outlineWyes = new int[] { oTY,oTY + midY + 1, oBY };
        g.setColor(TColor.black);
        Polygon outline = new Polygon(outlineExes,outlineWyes,3);
        g.drawPolygon(outline);
        
        return start;
    }
    
    public static void main(String[] args) {
        GetSamplelcon getter = new GetSamplelcon();
        String pathToIcons = "C:\\Users\\tim\\Documents\\projects\\jethro\\ca\\tecreations\\icons\\";
        
        // set up the image to scale and in our resource location
        //BufferedImage javaPojo = ImageTool.getImage(pathToIcons + "jlob.png");
        //javaPojo = ImageTool.getResized2(javaPojo,24,24);
        //ImageTool.saveImage(javaPojo,pathToIcons + "javaPojo.png");
        
        // this is the run Icon, get it with a play symbol
        //BufferedImage startImage = ImageTool.getImage(pathToIcons + "jlrb.png");
        //startImage = ImageTool.getResized2(startImage,24,24);
        //startImage = getter.getPainted(startImage);
        //ImageTool.saveImage(startImage, pathToIcons + "runJava.png");
       
        /*
        BufferedImage camera = ImageTool.getImage(pathToIcons + "camera-32x32.png");
        camera = ImageTool.getResized2(camera,24,24);
        //ImageTool.saveImage(camera, pathToIcons + "camera.png");
                
        Magnifier magnifier = new Magnifier(camera);
        magnifier.setVisible(true);
        magnifier.setExitOnClose(true);
        */
        
        String path = "D:\\candidates\\canada_flag.png";
        BufferedImage flag = ImageTool.getImage(new File(path));
        flag = ImageTool.setTransparent(flag,ImageTool.getTColor(flag,1,1));
        ImageTool.saveImage(flag,path);
        Magnifier magnifier = new Magnifier(flag);
        magnifier.setVisible(true);
        magnifier.setExitOnClose(true);
    } 
    
}
