package ca.tecreations.graphics;

import ca.tecreations.Pair;
import ca.tecreations.Point;

import java.awt.*;
import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author Tim
 */ 
public class Circle extends DrawObject {
    public static int numCircles = 0;
    public final int circleNum = numCircles++;
    int diameter;
    double radius;
    List<List<Point>> bresenham;
    List<Point> q1Fill = null;
    List<Point> q2Fill = null;
    List<Point> q3Fill = null;
    List<Point> q4Fill = null;
    public List<Point> linePoints;
    public List<List<Point>> fillPoints;
    List<Point> outsidePoints = new ArrayList<>();
    
    int hotDegree = 0;
    int hotPoint = 0;
    
    Color nandColor = null;
    
    public Circle(int diameter) {
        this.diameter = diameter;
        name = "Circle" + circleNum;
        doRadiusCalculation();
        compute();
    }
    
    public Circle(Point txy, int diameter) {
        this(diameter);
        setTranslation(txy);
    }
    
    private void addPoints(List<List<Point>> list, int x, int y, int angle) {
        if (angle > 45) {
            throw new IllegalArgumentException("Circle.addPoints: angle > 45: " + angle);
        }
        if (list.get(angle) == null) {
            list.set(angle, new ArrayList<>());
        }
        if (list.get(90 - angle) == null) {
            list.set(90 - angle, new ArrayList<>());
        }
        if (list.get(angle + 90) == null) {
            list.set(angle + 90, new ArrayList<>());
        }
        if (list.get(180 - angle) == null) {
            list.set(180 - angle, new ArrayList<>());
        }
        if (list.get(angle + 180) == null) {
            list.set(angle + 180, new ArrayList<>());
        }
        if (list.get(270 - angle) == null) {
            list.set(270 - angle, new ArrayList<>());
        }
        if (list.get(angle + 270) == null) {
            list.set(angle + 270, new ArrayList<>());
        }
        if (list.get(getNormalAngle(360 - angle)) == null) {
            list.set(360 - angle, new ArrayList<>());
        }
        list.get(angle).add(new Point(x, y));
        list.get(90 - angle).add(new Point(y, x));
        list.get(angle + 90).add(new Point(-y, x));
        list.get(180 - angle).add(new Point(-x, y));
        list.get(angle + 180).add(new Point(-x, -y));
        list.get(270 - angle).add(new Point(-y, -x));
        list.get(angle + 270).add(new Point(y, -x));
        list.get(getNormalAngle(360 - angle)).add(new Point(x, -y));
    }

    public void addQuadrant1FillPoints() {
        if (q1Fill == null) {
            q1Fill = new ArrayList<>();
            List<Point> points = getQuadrant1();
            Point p;
            for(int i = 0; i < points.size();i++) {
                p = points.get(i);
                if (p.y <= 0) {
                    for(int x = 0; x < p.x;x++) {
                        q1Fill.add(new Point(x,p.y));
                    }
                }
            }
        }
        fillPoints.add(q1Fill);
    }
    
    public void addQuadrant2FillPoints() {
        if (q2Fill == null) {
            q2Fill = new ArrayList<>();
            List<Point> points = getQuadrant2();
            Point p;
            for(int i = 0;i < points.size();i++) {
                p = points.get(i);
                if (p.y <= 0) {
                    for(int x = p.x;x <= 0;x++) {
                        q2Fill.add(new Point(x,p.y));
                    }
                }
            }
        }
        fillPoints.add(q2Fill);
    }
    
    public void addQuadrant3FillPoints() {
        if (q3Fill == null) {
            q3Fill = new ArrayList<>();
            List<Point> points = getQuadrant3();
            Point p;
            for(int i = 0; i < points.size();i++) {
                p = points.get(i);
                if (p.y >= 0) {
                    for(int x = p.x + 1;x <= 0;x++) {
                        q3Fill.add(new Point(x,p.y));
                    }
                }
            }
        }
        fillPoints.add(q3Fill);
    }
    
    public void addQuadrant4FillPoints() {
        if (q4Fill == null) {
            q4Fill = new ArrayList<>();
            List<Point> points = getQuadrant4();
            Point p;
            for(int i = 0; i < points.size();i++) {
                p = points.get(i);
                for(int x = 0; x < p.x;x++) {
                    q4Fill.add(new Point(x,p.y));
                }
            }
        }
        fillPoints.add(q4Fill);
    }

    public void compute() {
        bresenham = new ArrayList<>();
        linePoints = new ArrayList<>();
        fillPoints = new ArrayList<>();
        for (int i = 0; i < 360; i++) {
            bresenham.add(null);
        }
        double radiusError = 0.0;
        double radiusSquared = radius * radius;
        int r2 = (int) radiusSquared;
        int x = (int) radius;
        int y = 0;
        int degree;
        while (y <= x) {
            degree = (int) Math.toDegrees(Math.atan2((double) y, (double) x));
            //System.out.println("Degree: " + degree + " XY: " + x + "," + y);
            addPoints(bresenham, x, y, degree);
            radiusError = ((x + 0.5) * (x + 0.5)) + ((y + 0.5) * (y + 0.5)) - r2;
            if (((int) (radiusError + (((int) (y + 0.5) << 1) + 1)) << 1)
                    + (1 - ((int) (x + 0.5) << 1)) > 0) {
                x--;
            }
            y++;
        }
        // solve for 45 degree angles
        double xInt = radius * Math.cos(Math.toRadians(45));
        double yInt = radius * Math.sin(Math.toRadians(45));
        List<Point> points = new ArrayList<>();
        points.add(new Point((int)xInt,(int)yInt));
        bresenham.set(45,points);
        
        points = new ArrayList<>();
        points.add(new Point((int)-xInt,(int)yInt));
        bresenham.set(135,points);
        
        points = new ArrayList<>();
        points.add(new Point((int)-xInt,(int)-yInt));
        bresenham.set(225,points);
        
        points = new ArrayList<>();
        points.add(new Point((int)xInt,(int)-yInt));
        bresenham.set(315,points);
        
        
//        System.out.println("Y: " + y);
/*        for (int i = 0; i < bresenham.size(); i++) {
            if (bresenham.get(i) == null) {
                int x2 = (int) Math.round((double) radius * Math.cos(Math.toRadians(i)));
                int y2 = (int) Math.round((double) radius * Math.sin(Math.toRadians(i)));
                // and set the point for the degree
                nonBresenham.set(i, new ArrayList<Point>());
                if (i < 90) {
                    nonBresenham.get(i).add(new Point(x2, -y2));
                } else if (i >= 90 && i < 180) {
                    nonBresenham.get(i).add(new Point(-Math.abs(x2), -Math.abs(y2)));
                } else if (i >= 180 && i < 270) {
                    nonBresenham.get(i).add(new Point(-Math.abs(x2), Math.abs(y2)));
                } else if (i >= 270 && i < 360) {
                    nonBresenham.get(i).add(new Point(Math.abs(x2), Math.abs(y2)));
                }
            }
        }
*/        
        reorder();
        
        for(int i = 0; i < bresenham.size();i++) {
            List<Point> points2 = bresenham.get(i);
            if (points2 != null) {
                for(int j = 0; j < points2.size();j++) {
                    linePoints.add(points2.get(j));
                }
            }
        }
        List<List<Point>> byY = getSortedByY(linePoints);
        List<Integer> wyes = new ArrayList<>();
        for(int i = 0; i < byY.size();i++) {
            wyes.add(byY.get(i).get(0).y);
        }
        List<Pair> extents = new ArrayList<>();
        for(int i = 0; i < byY.size();i++) {
            List<Point> exes = byY.get(i);
            int min = 0;
            int max = 0;
            Point p;
            for(int j = 0; j < exes.size();j++) {
                p = exes.get(j);
                min = Math.min(min,p.x);
                max = Math.max(max,p.x);
            }
            extents.add(new Pair(min,max + 1));
        }
        for(int i = 0; i < wyes.size();i++) {
            Pair p = extents.get(i);
            for(int j = (int)-radius; j < p.getMin();j++) {
                outsidePoints.add(new Point(j,wyes.get(i)));
            }
            for(int j = p.getMax(); j < (int)radius;j++) {
                outsidePoints.add(new Point(j,wyes.get(i)));
            }
        }
    }
    
    protected void doRadiusCalculation() {
        radius = (diameter + 1) / 2;
    }

    public void doPainting(Graphics g) {
        draw(g);
    }
    
    public void draw(Graphics g) {
        draw(g,getTX(),getTY());
    }
    
    public void draw(Graphics g,int x, int y) {
        List<Point> list;
        Point txy = new Point(x,y);
        if (fillColor != null) {
            g.setColor(fillColor);
            if (fillPoints.size() == 0) {
                addQuadrant1FillPoints();
                addQuadrant2FillPoints();
                addQuadrant3FillPoints();
                addQuadrant4FillPoints();
            }
            for (int i = 0; i < fillPoints.size(); i++) {
                list = fillPoints.get(i);
                drawPoints(g,txy,list);
            }
        }
        if (lineColor != null) {
            g.setColor(lineColor);
            for (int i = 0; i < 360; i++) {
                list = bresenham.get(i);
                if (list != null) drawPoints(g,txy,list);
            }
        }
//        g.setColor(Color.red);
//        list = bresenham.get(getNormalAngle(hotDegree));
//        drawPoints(g,txy,list);
        if (nandColor != null) {
            g.setColor(nandColor);
            Point p;
            int x2, y2;
            for(int i = 0; i < outsidePoints.size();i++) {
                p = outsidePoints.get(i);
                x2 = txy.x + p.x;
                y2 = txy.y + p.y;
                g.drawLine(x2,y2,x2,y2);
            }
        }
    }

    public void draw(Graphics g, int x, int y, Color lineColor) {
        setLineColor(lineColor);
        draw(g,x,y);
    }

    public void draw(Graphics g, int x, int y, Color lineColor, Color fillColor) {
        setLineColor(lineColor);
        setFillColor(fillColor);
        draw(g,x,y);
    }
    
    public String getBlock() {
        return "Circle2: " + name + " [ diameter: " + diameter + " Radius: " + radius + " ]";
    }

    public List<Point> getDegree(int d) {
        return bresenham.get(getNormalAngle(d));
    }
    
    public int getDiameter() { return diameter; }
    
    public List<Point> getFillPoints() {
        List<Point> fill = new ArrayList<>();
        for(int i = 0; i < q1Fill.size();i++) {
            fill.add(q1Fill.get(i));
        }
        for(int i = 0; i < q2Fill.size();i++) {
            fill.add(q2Fill.get(i));
        }
        for(int i = 0; i < q3Fill.size();i++) {
            fill.add(q3Fill.get(i));
        }
        for(int i = 0; i < q4Fill.size();i++) {
            fill.add(q4Fill.get(i));
        }
        return fill;
    }
    
    public List<Point> getFirstNonNullBresenham(int angle) {
        List<Point> degree = bresenham.get(angle++);
        while (degree == null) { degree = bresenham.get(getNormalAngle(angle++)); }
        return degree;
    }
    
    public int getHotDegree() {
        return hotDegree;
    }
    
    public int getHotPoint() { 
        return hotPoint;
    }

    public Point getMidPointAtDegree(int degree) {
        List<Point> points = getFirstNonNullBresenham(getNormalAngle(degree));
        if (points.size() > 2) {
            return points.get((points.size() + 1) / 2);
        } else {
            return points.get(points.size() / 2);
        }
            
    }
    
    public Point getMidPointWithTXY(int angle) {
        Point txy = getTXY();
        Point midPoint = getMidPointAtDegree(angle);
        return new Point(txy.x + midPoint.x,txy.y + midPoint.y);
    }
    
    public List<Point> getNonNullBresenham() {
        List<Point> points = new ArrayList<>();
        List<Point> degree;
        for(int i = 0; i < 360;i++) {
            degree = bresenham.get(i);
            if (degree != null) {
                add(degree,points);
            }
        }
        return points;
    }
    
    public int getPaintingWidth() {
        return diameter;
    }
    
    public List<Point> getQuadrant4() {
        List<Point> points = new ArrayList<>();
        List<Point> degree;
        add(getQ4Of90(),points);
        for(int i = 89; i > 0;i--) {
            degree = bresenham.get(i);
            if (degree != null) {
                for(int j = degree.size() - 1; j >= 0;j--) {
                    points.add(degree.get(j));
                }
            }
        }
        add(getQ4Of0(),points);
        return points;
    }
    
    public List<Point> getQuadrant3() {
        List<Point> points = new ArrayList<>();
        List<Point> degree;
        add(getQ3Of180(),points);
        for(int i = 179; i > 90;i--) {
            degree = bresenham.get(i);
            if (degree != null) {
                for(int j = 0; j < degree.size();j++) {
                    points.add(degree.get(j));
                }
            }
        }
        add(getQ3Of90(),points);
        return points;
    }
    
    public List<Point> getQuadrant2() {
        List<Point> points = new ArrayList<>();
        List<Point> degree;
        add(getQ2Of270(),points);
        for(int i = 269; i > 180;i--) {
            degree = bresenham.get(i);
            if (degree != null) {
                for(int j = degree.size() - 1; j >= 0;j--) {
                    points.add(degree.get(j));
                }
            }
        }
        add(getQ2Of180(),points);
        return points;
    }
    
    public List<Point> getQuadrant1() {
        List<Point> points = new ArrayList<>();
        List<Point> degree;
        getQ4Of0();
        add(getQ1Of270(),points);
        for(int i = 271; i < 360;i++) {
            degree = bresenham.get(getNormalAngle(i));
            if (degree != null) {
                for(int j = degree.size() - 1; j >= 0;j--) {
                    points.add(degree.get(j));
                }
            }
        }
        add(getQ1Of0(),points);
        return points;
    }
    
    public List<Point> getQ4Of0() {
        List<Point> degree = bresenham.get(0);
        List<Point> points = new ArrayList<>();
        Point p;
        for(int i = 0; i < degree.size();i++) {
            p = degree.get(i);
            if (p.y >= 0) points.add(p);
        }
        return points;
    }

    public List<Point> getQ1Of0() {
        List<Point> degree = bresenham.get(0);
        List<Point> points = new ArrayList<>();
        Point p;
        for(int i = 0; i < degree.size();i++) {
            p = degree.get(i);
            if (p.y <= 0) points.add(p);
        }
        return points;
    }
    
    public List<Point> getQ2Of270() {
        List<Point> degree = bresenham.get(270);
        List<Point> points = new ArrayList<>();
        Point p;
        for(int i = 0; i < degree.size();i++) {
            p = degree.get(i);
            if (p.x <= 0) points.add(p);
        }
        return points;
    }
    
    public List<Point> getQ1Of270() {
        List<Point> degree = bresenham.get(270);
        List<Point> points = new ArrayList<>();
        Point p;
        for(int i = 0; i < degree.size();i++) {
            p = degree.get(i);
            if (p.x >= 0) points.add(p);
        }
        return points;
    }
    
    public List<Point> getQ3Of180() {
        List<Point> degree = bresenham.get(180);
        List<Point> points = new ArrayList<>();
        Point p;
        for(int i = 0; i < degree.size();i++) {
            p = degree.get(i);
            if (p.y >= 0) points.add(p);
        }
        return points;
    }
    
    public List<Point> getQ2Of180() {
        List<Point> degree = bresenham.get(180);
        List<Point> points = new ArrayList<>();
        Point p;
        for(int i = 0; i < degree.size();i++) {
            p = degree.get(i);
            if (p.y <= 0) points.add(p);
        }
        return points;
    }
    
    public List<Point> getQ4Of90() {
        List<Point> degree = bresenham.get(90);
        List<Point> points = new ArrayList<>();
        Point p;
        for(int i = 0; i < degree.size();i++) {
            p = degree.get(i);
            if (p.x >= 0) points.add(p);
        }
        return points;
    }
    
    public List<Point> getQ3Of90() {
        List<Point> degree = bresenham.get(90);
        List<Point> points = new ArrayList<>();
        Point p;
        for(int i = 0; i < degree.size();i++) {
            p = degree.get(i);
            if (p.x <= 0) points.add(p);
        }
        return points;
    }
    
    public List<Point> getSorted0(List<Point> data) {
        int minY = data.get(0).y;
        Point p;
        List<Point> out = new ArrayList<>();
        for(int i = 1; i < data.size();i++) {
            p = data.get(i);
            if (p.y < minY) minY = p.y;
        }
        for(int i = 0; i < data.size();i++) {
            for(int j = 0; j < data.size();j++) {
                if (data.get(j).y == minY) {
                    out.add(data.get(j));
                }
            }
            minY++;
        }
        return out;
    }
    
    public List<Point> getSorted90(List<Point> data) {
        int maxX = data.get(0).x;
        Point p;
        List<Point> out = new ArrayList<>();
        for(int i = 1; i < data.size();i++) {
            p = data.get(i);
            if (p.x > maxX) maxX = p.x;
        }
        for(int i = 0; i < data.size();i++) {
            for(int j = 0; j < data.size();j++) {
                if (data.get(j).x == maxX) {
                    out.add(data.get(j));
                }
            }
            maxX--;
        }
        return out;
    }
    
    public List<Point> getSorted180(List<Point> data) {
        int maxY = data.get(0).y;
        Point p;
        List<Point> out = new ArrayList<>();
        for(int i = 1; i < data.size();i++) {
            p = data.get(i);
            if (p.y > maxY) maxY = p.y;
        }
        for(int i = 0; i < data.size();i++) {
            for(int j = 0; j < data.size();j++) {
                if (data.get(j).y == maxY) {
                    out.add(data.get(j));
                }
            }
            maxY--;
        }
        return out;
    }
    
    public List<Point> getSorted270(List<Point> data) {
        int minX = data.get(0).x;
        Point p;
        List<Point> out = new ArrayList<>();
        for(int i = 1; i < data.size();i++) {
            p = data.get(i);
            if (p.x < minX) minX = p.x;
        }
        for(int i = 0; i < data.size();i++) {
            for(int j = 0; j < data.size();j++) {
                if (data.get(j).x == minX) {
                    out.add(data.get(j));
                }
            }
            minX++;
        }
        return out;
    }
  
    public List<List<Point>> getSortedByX(List<Point> points) {
        List<List<Point>> exes = new ArrayList<>();
        List<Point> col;
        int start = (int)-radius;
        Point p;
        while (start <= radius) {
            col = new ArrayList<>();
            for(int i = 0; i < points.size();i++) {
                p = points.get(i);
                if (p.x == start) col.add(p);
            }
            if (col.size() > 0) {
                exes.add(col);
            }
            start++;
        }
        return exes;
    }
    
    public List<List<Point>> getSortedByY(List<Point> points) {
        List<List<Point>> wyes = new ArrayList<>();
        List<Point> row;
        int start = (int)-radius;
        Point p;
        while (start <= radius) {
            row = new ArrayList<>();
            for(int i = 0; i < points.size();i++) {
                p = points.get(i);
                if (p.y == start) row.add(p);
            }
            if (row.size() > 0) {
                wyes.add(row);
            } else {
            }
            start++;
        }
        return wyes;
    }
    
/*
    public Point getStartPointAtDegree(int angle) {
        List<Point> list = bresenham.get(angle);
        if (list.size() > 0) return list.get(0);
        return null;
    }
*/
    
    public static Circle getWithDiameter(int diameter) {
        return new Circle(diameter);
    }
    
    public static Circle getWithRadius(int radius) {
        return getWithDiameter(radius * 2);
    }
    
    public static Circle getWith(int diameter, Color fill, Color line) {
        Circle circle = new Circle(diameter);
        circle.setFillColor(fill);
        circle.setLineColor(line);
        return circle;
    }
    
    public boolean hasFillPoint(Point p) {
        Point txy = getTXY();
        Point current;
        if (q1Fill != null) {
            for(int i = 0; i < q1Fill.size();i++) {
                current = q1Fill.get(i);
                if (txy.x + current.x == p.x &&
                    txy.y + current.y == p.y) return true;
            }
        }
        if (q2Fill != null) {
            for(int i = 0; i < q2Fill.size();i++) {
                current = q2Fill.get(i);
                if (txy.x + current.x == p.x &&
                    txy.y + current.y == p.y) return true;
            }
        }
        if (q3Fill != null) {
            for(int i = 0; i < q3Fill.size();i++) {
                current = q3Fill.get(i);
                if (txy.x + current.x == p.x &&
                    txy.y + current.y == p.y) return true;
            }
        }
        if (q4Fill != null) {
            for(int i = 0; i < q4Fill.size();i++) {
                current = q4Fill.get(i);
                if (txy.x + current.x == p.x &&
                    txy.y + current.y == p.y) return true;
            }
        }
        return false;
    }
    
    public boolean hasPoint(Point p) {
        Point txy = getTXY();
        int tpx, tpy;
        Point current;
        for(int i = 0; i < linePoints.size();i++) {
            current = linePoints.get(i);
            tpx = txy.x + current.x;
            tpy = txy.y + current.y;
            if (p.x == tpx && p.y == tpy) return true;
        }
        return hasFillPoint(p);
    }

    public static void main(String[] args) {
        Circle circle = new Circle(20);
    }
    
 /*    public void incrementHotPoint() { 
        hotPoint++;
        if (getDegree(getHotDegree()).size() <= hotPoint) {
            hotPoint = 0;
            hotDegree++;
//            HOT_DEGREE = getNormalAngle(hotDegree);
        }
    }
  
*/
    public boolean inQuadrant1(double angle) {
        if (angle > 270 && angle < 360) return true;
        return false;
    }
    
    public boolean inQuadrant2(double angle) {
        if (angle > 180 && angle < 270) return true;
        return false;
    }
    
    public boolean inQuadrant3(double angle) {
        if (angle > 90 && angle < 180) return true;
        return false;
    }
    
    public boolean inQuadrant4(double angle) {
        if (angle > 0 && angle < 90) return true;
        return false;
    }
    
    public void paintElement(Graphics g) {
        draw(g);
    }
    
    private void reorder() {
        List<Point> temp;
        List<Point> degree;
        for(int i = 46;i < 90;i++) {
            degree = bresenham.get(i);
            if (degree != null) {
                temp = new ArrayList<>();
                for(int j = degree.size() - 1;j >= 0;j--) temp.add(degree.get(j));
                bresenham.set(i, temp);
            }
        }
        for(int i = 136;i < 180;i++) {
            degree = bresenham.get(i);
            if (degree != null) {
                temp = new ArrayList<>();
                for(int j = degree.size() - 1;j >= 0;j--) temp.add(degree.get(j));
                bresenham.set(i, temp);
            }
        }
        for(int i = 226;i < 270;i++) {
            degree = bresenham.get(i);
            if (degree != null) {
                temp = new ArrayList<>();
                for(int j = degree.size() - 1;j >= 0;j--) temp.add(degree.get(j));
                bresenham.set(i, temp);
            }
        }
        for(int i = 316;i < 360;i++) {
            degree = bresenham.get(i);
            if (degree != null) {
                temp = new ArrayList<>();
                for(int j = degree.size() - 1;j >= 0;j--) temp.add(degree.get(j));
                bresenham.set(i, temp);
            }
        }
        degree = bresenham.get(0);
        // sort vertically, small to large
        bresenham.set(0,getSorted0(degree));
        
        degree = bresenham.get(90);
        //  hosrizontally, small to large
        bresenham.set(90,getSorted90(degree));
        
        degree = bresenham.get(180);
        bresenham.set(180,getSorted180(degree));
        
        degree = bresenham.get(270);
        bresenham.set(270,getSorted270(degree));
        
    }

    public void setFillColor(Color fillColor) {
        super.setFillColor(fillColor);
        addQuadrant1FillPoints();
        addQuadrant2FillPoints();
        addQuadrant3FillPoints();
        addQuadrant4FillPoints();
    }
    
    public void setHotDegree(int i) {
        hotDegree = getNormalAngle(i);
    }
    
    public Circle setName(String name) {
        super.setName(name);
        return this;
    }
    
    public void setNandColor(Color c) {
        nandColor = c;
    }
    
    public Circle setTranslation(int x, int y) {
        super.setTranslation(x,y);
        return this;
    }
    
    public Circle setTXY(Point p) {
        super.setTranslation(p);
        return this;
    }
    
    public String toString() {
        return "Circle2: " + name + " [ Diameter: " + diameter + " Radius: " + radius + 
                " TXY: " + getTXY() + 
                " Rotation: " + getRotation() + 
                " ]";
    }

    public void zeroHotPoint() { hotPoint = 0; }
}
