package ca.tecreations.components;

import ca.tecreations.TColor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.*;

import javax.swing.*;
/**
 *
 * @author Tim
 */
public class SizedPanel extends JPanel implements MouseListener
{
    public static final String SN = SizedPanel.class.getSimpleName();
    private boolean trace = false;
    private boolean debug = true;
    private boolean verbose = false;
    
    public Color outlineColor = null;
    Color xColor = null;
    String variableName = "";
    int width;
    int height;

    int lastX = -1;
    int lastY = -1;
    
    public SizedPanel(int w, int h) {
        this(w,h,true);
    }
    
    public SizedPanel(int w, int h,boolean doubleBuffered) {
        super(null,doubleBuffered);
        setSize(w,h);
        width = w;
        height = h;
        //setOpaque(true);
        setBackground(TColor.decode("#DCDCDC"));
    }
    
    public SizedPanel(int w, int h, Component c, boolean doubleBuffered) {
        super(null,doubleBuffered);
        setSize(w,h);
        width = w;
        height = h;
        setBackground(c.getBackground());
    }
    
    public SizedPanel(int w, int h, Color bg) {
        this(w,h);
        setBackground(bg);
    }

    public SizedPanel(Dimension d) {
        this(d.width,d.height);
    }

    public SizedPanel(Rectangle r) {
        this(r.width,r.height);
    }
    
    
    
    public boolean getDebug() { return debug; }
    
    public int getPaintingWidth() { return getSize().width; }
    
    public Dimension getPreferredSize() { return new Dimension(width,height); }

    public boolean getTrace() { return trace; }
    
    public void mouseClicked(MouseEvent e) {
    }
    
    public void mouseDragged(MouseEvent e) {
        lastX = e.getX();
        lastY = e.getY();
        repaint();
    }
    
    public void mouseEntered(MouseEvent e) {
        lastX = e.getX();
        lastY = e.getY();
        repaint();
    }
    
    public void mouseExited(MouseEvent e) {
        lastX = -1;
        lastY = -1;
        repaint();
    }
    
    public void mouseMoved(MouseEvent e) {
        lastX = e.getX();
        lastY = e.getY();
        repaint();
    }
    
    public void mousePressed(MouseEvent e) {}
    
    public void mouseReleased(MouseEvent e) {}
    
    public void mouseWheelMoved(MouseWheelEvent e) {}
    
    public void setBackground(Color color) {
        super.setBackground(color);
        repaint();
    }
    
    public void setDebug(boolean state) { debug = state; }
    
    public void setSize(int w, int h) {
        super.setSize(w,h);
        width = w;
        height = h;
        repaint();
    }
    
    public void setTrace(boolean state) { trace = state; }
    
    public void setVariableName(String s) {
        variableName = s;
    }
    
    public void setXColor(Color xColor) {
        this.xColor = new TColor(xColor);
        repaint();
    }
    
}
