package ca.tecreations.components;

import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.TColor;
import ca.tecreations.TecData;
import ca.tecreations.graphics.GraphicsUtil;

import java.awt.*;
import java.awt.event.*;
import javax.swing.JPanel;
/**
 *
 * @author Timothy
 */
public class Movable extends SizedPanel 
        implements MouseListener, MouseMotionListener {
    private boolean trace = false;
    private static final long serialVersionUID = 2551737700376871526L;
    public static final int NONE = 0;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    public static final int BOTH = 0;
    int constrainTo = NONE;
    boolean constrained = false;
    boolean keepWithinBounds = false;
    private int lastX = 0;
    private int lastY = 0;
    private int deltaX = 0;
    private int deltaY = 0;
    private int newX = 0;
    private int newY = 0;
//    private int width;
//    private int height;
    boolean movable = true;
    
    public Movable() {
        super(100,100);
        addMouseListener(this);
        addMouseMotionListener(this);
    }
    
    public Movable(int constrainTo) {
        super(100,100);
        this.constrainTo = constrainTo;
        addMouseListener(this);
        addMouseMotionListener(this);
    }
    
    @Override
    public TColor getBackground() {
        if (super.getBackground() != null) {
            return new TColor(super.getBackground());
        } else {
            return TecData.DEFAULT_COLOR;
        }
    }
    
    public int getDX() { return -deltaX; }
    public int getDY() { return -deltaY; }
    
    public int getLastX() { return lastX; }
    public int getLastY() { return lastY; }
    
    public int getNewX() { return newX; }
    public int getNewY() { return newY; }
    
    public Dimension getPreferredSize() { return new Dimension(getWidth(),getHeight()); }

    public void mouseClicked(MouseEvent e) {
        if (trace) System.out.println("Movable.mouseClicked");
        //super.mouseClicked(e);
    }
    
    public void mouseDragged(MouseEvent e) {
        if (trace) System.out.println("Movable.mouseDragged: Constrain: " + constrainTo);
        if (!movable) return;
        java.awt.Point p = e.getLocationOnScreen();
        int tdx;
        int tdy;
        if (constrainTo != VERTICAL) tdx = lastX - p.x;
        else tdx = 0;
        if (constrainTo != HORIZONTAL) tdy = lastY - p.y;
        else tdy = 0;
        if (tdx == 0 && tdy == 0) return;
        deltaX = tdx;
        deltaY = tdy;
        //System.out.println("DXY:" + deltaX + "," + deltaY);
        newX = getLocation().x;
        newY = getLocation().y;
        if (deltaX > 0) newX -= Math.abs(deltaX);
        if (deltaX < 0) newX += Math.abs(deltaX);
        if (deltaY < 0) newY += Math.abs(deltaY);
        if (deltaY > 0) newY -= Math.abs(deltaY);
        // set the location of the SizedPanel to its' new location
        //System.out.println("NEWXY: " + newX + "," + newY);
        if (keepWithinBounds) {
            if (constrainTo == HORIZONTAL) {
                if (newX >= 0 && newX + getSize().width <= getParent().getSize().width) {
                    setLocation(newX,newY);
                }
            } else if (constrainTo == VERTICAL) {
                if (newY >= 0 && newY + getSize().height <= getParent().getSize().height) {
                    setLocation(newX,newY);
                }
            } else {
                if (newX >= 0 && newX + getSize().width <= getParent().getSize().width &&
                    newY >= 0 && newY + getSize().height <= getParent().getSize().height) {
                    setLocation(newX,newY);
                }
            }
        } else {
            setLocation(newX,newY);
        }
        // set last position
        lastX = p.x;
        lastY = p.y;
    }

    public void mouseEntered(MouseEvent e) {}
    
    public void mouseExited(MouseEvent e) {
    }
        
    public void mouseMoved(MouseEvent e) {
        if (trace) System.out.println("Movable.mouseMoved");
        if (movable) {
            java.awt.Point p = e.getLocationOnScreen();
            lastX = p.x;
            lastY = p.y;
        }
    }
    
    public void mousePressed(MouseEvent e) {
        if (trace) System.out.println("Movable.mousePressed()");
        //movable = !movable;
        if (movable) {
            java.awt.Point p = e.getLocationOnScreen();
            lastX = p.x;
            lastY = p.y;
        } 
    }
    
    public void mouseReleased(MouseEvent e) {
        if (trace) System.out.println("Movable.mouseReleased");
    }
    
    public static void main(String[] args) {
        TFrame app = new TFrame(ProjectPath.INSTANCE.getPropertiesPath() + "Movable.properties","MovableTestFrame");
        JPanel holder = new JPanel();
        app.add(holder,BorderLayout.CENTER);
        holder.setLayout(null);
        Movable block = new Movable(Movable.HORIZONTAL);
        block.setSize(320,240);
        block.setBackground(Color.blue);
        block.setOutlineColor(Color.red);
        block.setXColor(Color.red);
        holder.add(block);
        app.setVisible(true);
        
    }
    
    public void paint(Graphics g) {
        if (g == null) g = getGraphics();
        if (g != null) {
            super.paint(g);
        }
    }
    
    public void repaint() {
        paint(getGraphics());
    }
    
    public void printStats() {
        System.out.println("Movable.X     : " + getX());
        System.out.println("Movable.Y     : " + getY());
        System.out.println("Movable.width : " + getWidth());
        System.out.println("Movable.height: " + getHeight());
    }
    
    public void setLimitToParentBounds(boolean keepWithin) {
        keepWithinBounds = keepWithin;
    }
    
    public void setOutlineColor(Color c) {
        outlineColor = c;
        repaint();
    }
}
        
