package ca.tecreations.apps;

import ca.tecreations.File;
import ca.tecreations.ProjectPath;
import ca.tecreations.TextFile;

/**
 *
 * @author Tim
 */
public class MakeLocalSecurityConfiguration {
    
    public MakeLocalSecurityConfiguration() {
        String secPath = ProjectPath.getTecreationsPath() + "security" + File.separator;
        String propsPath = ProjectPath.getTecPropsPath();
        propsPath += File.separator;
        String serverConfPath = propsPath + "LocalTLSServer.properties";
        String clientConfPath = propsPath + "localhost_client.properties";
        new File(serverConfPath).delete();
        new File(clientConfPath).delete();
        TextFile serverConf = new TextFile(serverConfPath);
        TextFile clientConf = new TextFile(clientConfPath);
        
        serverConf.add("debug.ssl: false");
        serverConf.add("make.secure: false");
        serverConf.add("remote.keystore: " + secPath + "server-credentials");
        serverConf.add("remote.keystore.password: storepass");
        serverConf.add("remote.port: 52820");
        serverConf.add("remote.truststore: " + secPath + "server-trust");
        serverConf.write();
        serverConf.close();

        clientConf.add("debug.ssl: false");
        clientConf.add("make.secure: false");
        clientConf.add("remote.host: localhost");
        clientConf.add("remote.keystore: " + secPath + "client-credentials");
        clientConf.add("remote.keystore.password: storepass");
        clientConf.add("remote.port: 52820");
        clientConf.add("remote.truststore: " + secPath + "client-trust");
        clientConf.write();
        clientConf.close();

    }
    
    public static void main(String[] args) {
        new MakeLocalSecurityConfiguration();
    }
}
