package ca.tecreations;

import ca.tecreations.components.ProgressDialog;
import ca.tecreations.components.event.ProgressListener;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
/**
 *
 * @author Tim
 */
public class JarReader extends Jar {
    public static boolean debug = true;
    public static boolean verbose = false;
    
    
    public JarReader(String path) {
        super(path);
    }
    
    public List<String> getEntryNames() {
        List<String> names = new ArrayList<>();
        Enumeration enumEntries = jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry entry = (JarEntry)enumEntries.nextElement();
            names.add(entry.getName());
        }
        return names;
    }
    
    public String getFQCN(JarEntry entry) {
        String name = entry.getName();
        String minus = name.substring(0,name.lastIndexOf(".")); // strip .java
        String fqcn = StringTool.replaceAll(minus,'/',".");
        return fqcn;
    }
    
    public JarEntry getJarEntryForFQCN(String fqcn) {
        Enumeration enumEntries = jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry entry = (JarEntry)enumEntries.nextElement();
            String name = entry.getName().replace("/",".");
            name = name.substring(0,name.lastIndexOf("."));
            //System.out.println("Name: " + name);
            if (name.equals(fqcn)) {
                return entry;
            }
        }
        return null; // not found
    }
    
    /**
     * 
     * @return the entries from jars/* in the jar file
     */
    public List<JarEntry> getJarsEntries() {
        List<JarEntry> entries = new ArrayList<>();
        Enumeration enumEntries = jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry entry = (JarEntry)enumEntries.nextElement();
            String name = entry.getName();
            if (name.toLowerCase().startsWith("jars/")) {
                entries.add(entry);
            }
        }
        return entries;
    }
    
    /**
     * @return the list of jar files within this .jar, with all path parts removed.
     * INCLUDES the file extension. 
     * 
     * Note that this may contain any other type of file within the path. 
     * So for example, if test.txt is in that directory or sub-directory,
     * test.txt will be one of the names within this list.
     */
    
    public List<String> getJarsNames() {
        List<String> names = new ArrayList<>();
        Enumeration enumEntries = jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry entry = (JarEntry)enumEntries.nextElement();
            String name = entry.getName();
            if (name.toLowerCase().startsWith("jars/")) {
                name = name.substring(name.lastIndexOf("/") + 1);
                //System.out.println(name);
                names.add(name);
            }
        }
        return names;
    }
    
    public List<String> getJarsPathsRelativeToRootOfJars() {
        List<String> paths = new ArrayList<>();
        Enumeration enumEntries = jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry entry = (JarEntry)enumEntries.nextElement();
            String name = entry.getName();
            if (name.toLowerCase().startsWith("jars/")) {
                String subPath = entry.getName().substring(5);
                paths.add(subPath);
            }
        }
        return paths;
    }
    
    public List<JarEntry> getJavaEntries() {
        List<JarEntry> entries = new ArrayList<>();
        Enumeration enumEntries = jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry entry = (JarEntry)enumEntries.nextElement();
            if (entry.getName().toLowerCase().endsWith(".java")) {
                entries.add(entry);
            }
        }
        return entries;
    }
    
    public List<String> getJavaFQCNs() {
        List<String> fqcns = new ArrayList<>();
        String tmp;
        Enumeration enumEntries = jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry entry = (JarEntry)enumEntries.nextElement();
            String name = entry.getName();
            if (name.endsWith(".java")) {
                tmp = name.substring(0,name.lastIndexOf("."));
                tmp = StringTool.replaceAll(tmp,'/',".");
                fqcns.add(tmp);
            }
        }
        return fqcns;
    }
    
    public List<String> getJavaMainsFQCNsForJar(ProgressDialog progress) {
        List<String> mainFQCNs = new ArrayList<>();
        List<JarEntry> entries = getJavaEntries();
        String tmpPath = File.tecListRoots()[0].getUnwrapped() + "temp" + File.separator;
        new File(tmpPath).mkdirs();
//        doLogAction(progress,"JarReader.getJavaMainsFQCNsForJar: entries: " + entries.size());
        JarEntry entry;
        String pkg;
        String path;
        String entryName;
        for(int i = 0; i < entries.size();i++) {
            entry = entries.get(i);
            pkg = StringTool.replaceAll(entry.toString(),'/','.');
            path = StringTool.replaceAll(entry.toString(),'/',File.separatorChar);
            entryName = entry.getName();
            String absPath = tmpPath + entryName.substring(entryName.lastIndexOf("/") + 1);
            unpack(entries.get(i),absPath,progress);
            List<String> lines = new TextFile(absPath).getLines();
//            doLogAction(progress,"JarReader.getJavaMainsFQCNsForJar: pkg: " + pkg);
//            doLogAction(progress,"JarReader.getJavaMainsFQCNsForJar: path: " + path);
//            doLogAction(progress,"JarReader.getJavaMainsFQCNsForJar: absPath: " + absPath);
//            doLogAction(progress,"JarReader.getJavaMainsFQCNsForJar: lines: " + lines.size());
            for(int j = 0; j < lines.size();j++) {
                if (lines.get(j).trim().startsWith("public static void main")) { 
                    String fqcn = getFQCN(entries.get(i));
                    mainFQCNs.add(fqcn);
                }
            }
            new File(absPath).delete(true);
            if (progress != null) {
                int percent = (int)((double)i / (double)entries.size() * (double)100);
                progress.setTitle("Working (" + percent + "%) ...");
                progress.setPercent(percent);
            }
        }
        return mainFQCNs;
    }

    public String getMainClass() {
        String main = null;
        try {
            main = jar.getManifest().getMainAttributes().getValue("Main-Class");
        } catch (IOException ioe) {
            System.err.println("Unable to access jar.");
        }
        return main;
    }
    
    public boolean hasMain(URLClassLoader loader, String fqcn) {
        Class<?> classToLoad = null;
        Method[] methods = null;
        Method method = null;
        Object instance = null;
        Object result = null;
        try { 
            // see GetMainClassesFor to debugList
//            if (debug) System.out.print("JarReader.hasMain: checking: " + fqcn);
            classToLoad = Class.forName(fqcn, true, loader);
            method = (Method)classToLoad.getDeclaredMethod("main",String[].class);
//            if (debug) System.out.println("true");
            return true;
        } catch (ClassNotFoundException cnfe) {
//            if (debug) System.out.println("false");
            System.err.println("JarReader.hasMain: " + fqcn + " : Class Not Found.");
        } catch (NoClassDefFoundError e) {
//            if (debug) System.out.println("false");
            System.err.println("JarReader.hasMain: No Class Def Found: " + fqcn);
        } catch (NoSuchMethodException nsme) {
        }
        return false;
    }

    public void logAdd(String s) {
        System.out.println(s);
    }
    
    public static void main(String[] args) {
        // So, several things, first can we just unpack a .jar with a progress dialog?
        
        JarReader jr = new JarReader(ProjectPath.getDownloadsPath() + "BCTLSNetwork.jar");
        jr.unpackAll("F:\\temp\\BCTLSNetwork\\");
        
        // What happens when we do a "jethro_jars.jar"?
        
        // What happens when we do an 'unpackForTecreations' ? (jethro_jars.jar)
        
        
    }
    
    public void unpack(JarEntry entry, String absPath, ProgressDialog progress) {
        unpack(entry,absPath,true,true,progress);
    }
    
    public void unpack(JarEntry entry, String absPath, boolean write,boolean quiet, ProgressDialog progress) {
        File deepest = new File(absPath).getDeepestDirectoryFile();
        deepest.mkdirs();
        if (!quiet) logAdd("JarReader: unpack: " + entry);
        if (write) {
            try { 
                InputStream is = jar.getInputStream(entry);
                FileOutputStream fos = new FileOutputStream(StringTool.getUnwrapped(absPath));
            
                while (is.available() > 0) { 
                    fos.write(is.read());
                }
                fos.flush();
                fos.close();
                is.close();
            } catch (IOException ioe) {
                logAdd("JarReader: Unable to unpack: " + entry.getName() + " IOE: " + ioe);
            }
        }
    }
        
    public void unpackAll(String outDir) {
        unpackAll(outDir,true,true);
    }
    
    public void unpackAll(String outDir, boolean write, boolean quiet) {
        if (!outDir.endsWith(File.separator)) outDir += File.separator;
        Enumeration enumEntries = jar.entries();
        ProgressDialog progress = ProgressDialog.INSTANCE;
        progress.setTitle("Unpacking all...");
        progress.setPercent(0);
        progress.setVisible(true);
        while (enumEntries.hasMoreElements()) {
            JarEntry entry = (JarEntry)enumEntries.nextElement();
            if (!entry.getName().startsWith("META-INF")) {
                String absPath = outDir + entry.getName().replace('/',File.separator.charAt(0));
                File f = new File(absPath);
                File parent = f.getTecParentFile();
                if (!parent.exists()) parent.mkdirs();
                if (!entry.isDirectory()) {
                    unpack(entry, absPath, write,quiet,progress);
                }
            }
        }
        progress.setPercent(100);
        Platform.sleep(125);
        progress.setVisible(false);
    }

    public void unpackClass(String fqcn,String absPath, ProgressDialog progress) {
        unpackClass(fqcn,absPath,true,true,progress);
    }
    
    public void unpackClass(String fqcn,String absPath, boolean write, boolean quiet, ProgressDialog progress) {
        JarEntry entry = getJarEntryForFQCN(fqcn);
        File parent = new File(absPath).getTecParentFile();
        if (!parent.exists()) parent.mkdirs();
        if (entry != null) {
            if (!quiet) logAdd("JarReader: unpack: FQCN: " + fqcn + " absPath: " + absPath);
            unpack(entry,absPath,write, quiet,progress);
        } else {
            System.err.println("JarReader: unpackClass: Class not found: " + fqcn);
        }
    }

    public void unpackDirectory(String pathInJar,String outDir, ProgressDialog progress) {
        unpackDirectory(pathInJar,outDir,true,true,progress);
    }
    
    public void unpackDirectory(String pathInJar,String outDir, boolean write, boolean quiet, ProgressDialog progress) {
        if (!pathInJar.endsWith("/")) pathInJar += "/";
        if (!outDir.endsWith(File.separator)) outDir += File.separator;
        if (!new File(outDir).exists()) new File(outDir).mkdirs();
        Enumeration enumEntries = jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry entry2 = (JarEntry)enumEntries.nextElement();
            if (entry2.getName().startsWith(pathInJar)) {
                String subPath = entry2.getName();
                subPath = subPath.substring(pathInJar.length());
                subPath = subPath.replace("/",File.separator);
                unpack(entry2, outDir + subPath, write,quiet,progress);
            }
        }
    }
    
    public void unpackFile(JarEntry entry, String outDir, ProgressDialog progress) {
        unpackFile(entry,outDir,true,true,progress);
    }
    
    public void unpackFile(JarEntry entry, String outDir, boolean write, boolean quiet, ProgressDialog progress) {
        String filePath = outDir + entry.getName().replace("/",File.separator);
        unpack(entry, filePath, write, quiet,progress);
    }
    
    public void unpackFileToAbsPath(JarEntry entry, String absPath, boolean write, boolean quiet, ProgressDialog progress) {
        unpack(entry,absPath,write,quiet,progress);
    }
    
    public void unpackJarsForTecreations(ProgressDialog progress) {
        Enumeration enumEntries = jar.entries();
        String outPath = getTecreationsUnpackPath();
        progress.setTitle("Unpacking jars...");
        progress.setPercent(0);
        progress.setVisible(true);
        while (enumEntries.hasMoreElements()) {
            JarEntry entry = (JarEntry)enumEntries.nextElement();
            if (entry.getName().startsWith("jars/")) {
                
                String block = entry.getName().substring(5); // everything after 'jars/'
                if (block.contains("/")) block = block.replace("/",File.separator);
                String dstPath = outPath + block;
                unpack(entry, dstPath, true,false,progress);
            }
        }
        progress.setPercent(100);
        Platform.sleep(125);
        progress.setVisible(false);
    }
}