package ca.tecreations.apps.capturetool;

import ca.tecreations.File;
import ca.tecreations.ImageTool;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.components.BoundingBox;
import ca.tecreations.misc.Clipboard;

import java.awt.event.*;
import java.awt.image.BufferedImage;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar; 
import javax.swing.JMenuItem;

/** 
 *
 * @author Tim de Vries
 */
public class CaptureToolMenuBar extends JMenuBar implements ActionListener, ItemListener {
    CaptureTool app;
    Properties properties;
    CaptureToolDisplay display;
    JMenu file = new JMenu("File");
    JMenuItem capture = new JMenuItem("Capture Desktop");
    JMenuItem captureWithApp = new JMenuItem("Capture With App");
    
    JMenu save = new JMenu("Save");
    JMenuItem imgContents = new JMenuItem("Contents");
    JMenuItem desktop = new JMenuItem("Desktop...");
    JCheckBoxMenuItem drawBox = new JCheckBoxMenuItem("Draw Box");
    JMenuItem boxContents = new JMenuItem("Box Contents...");
    JMenuItem exit = new JMenuItem("Exit");

    JMenu edit = new JMenu("Edit");
    JMenuItem paste = new JMenuItem("Paste From Clipboard");
    JMenuItem setBoxSize = new JMenuItem("Set Box Size...");
    JMenuItem color = new JMenuItem("Box Element Color...");
    JCheckBoxMenuItem outline = new JCheckBoxMenuItem("Show Box Outline");
    
    JMenu copy = new JMenu("Copy");
    JMenuItem copyDesktop = new JMenuItem("Desktop");
    JMenuItem copyBox = new JMenuItem("Box Contents");
    
    public CaptureToolMenuBar(CaptureTool app,CaptureToolDisplay display) {
        this.app = app;
        this.display = display;
        properties = app.getProperties();
        add(file);
        file.add(capture);
        file.add(captureWithApp);
        file.add(save);
        file.add(exit);
        save.add(imgContents);
        save.add(desktop);
        save.add(drawBox);
        save.add(boxContents);
        
        add(edit);
        edit.add(paste);
        edit.add(setBoxSize);
        edit.add(color);
        edit.add(outline);
        outline.setSelected(true);
        edit.add(copy);
        copy.add(copyDesktop);
        copy.add(copyBox);
        
        capture.addActionListener(this);
        captureWithApp.addActionListener(this);
        imgContents.addActionListener(this);
        desktop.addActionListener(this);
        drawBox.addItemListener(this);
        boxContents.addActionListener(this);
        exit.addActionListener(this);
        paste.addActionListener(this);
        setBoxSize.addActionListener(this);
        color.addActionListener(this);
        outline.addItemListener(this);
        copyDesktop.addActionListener(this);
        copyBox.addActionListener(this);
    }
    
    public void actionPerformed(ActionEvent e) {
        BoundingBox box = display.getBox();
        if (e.getSource() == capture) {
            display.setImage(display.capture(false));
            display.extractPortion();
        } else if (e.getSource() == captureWithApp) {
            display.setImage(display.capture(true));
        } else if (e.getSource() == desktop) {
            display.saveDesktop();
        } else if (e.getSource() == imgContents) {
            // save extracted
            String path = Platform.requestFile(app,"Select a path to save the IMAGE CONTENTS to...");
            if (path != null) {
                ImageTool.saveImage(display.getImage(),path);
            }
        } else if (e.getSource() == boxContents) {
            // save extracted
            String path = Platform.requestFile(app,
                                               new File(ProjectPath.getTecreationsPath() + "Captures" + File.separator),
                                               "Select a path to save the BOX CONTENTS to...");
            if (path != null) {
                ImageTool.saveImage(display.getBox().getImage(),path);
            }
        } else if (e.getSource() == exit) {
            System.exit(0);
        } else if (e.getSource() == paste) {
            BufferedImage image = Clipboard.getImage();
            if (image.getWidth() == box.getWidth() &&
                image.getHeight() == box.getHeight()) {
                box.setLocation(0,0);
            }
            display.setImage(image);
            display.extractPortion();
        } else if (e.getSource() == setBoxSize) {
            GetSize sizer = new GetSize(app);
            sizer.setWidthText(properties.get("box.width"));
            sizer.setHeightText(properties.get("box.height"));
            sizer.setVisible(true);
            if (sizer.getWidthProperty() > 0 && sizer.getHeightProperty() > 0) {
                box.setSize(sizer.getWidthProperty(),sizer.getHeightProperty());
                properties.set("box.width",sizer.getWidthProperty());
                properties.set("box.height",sizer.getHeightProperty());
                display.extractPortion();
            } 
        } else if (e.getSource() == color) {
            box.setBoxElementsColor(Platform.requestColor(box.getBoxElementsColor(),"Select a color for the box elements..."));
        } else if (e.getSource() == copyDesktop) {
            Clipboard.copyImage(display.getImage());
        } else if (e.getSource() == copyBox) {
            Clipboard.copyImage(box.getImage());
        }
    }
    
    public void itemStateChanged(ItemEvent e) {
        display.getBox().setOutline(outline.isSelected());
        display.repaint();
    }
    
}
