package ca.tecreations.components;

import ca.tecreations.TColor;
//import ca.tecreations.Cursor;
import ca.tecreations.TImage;
import ca.tecreations.graphics.DrawObject;
import ca.tecreations.graphics.GraphicsUtil;
import ca.tecreations.interfaces.Paintable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.*;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;
/**
 *
 * @author Tim
 */
public class SizedPanel extends JPanel implements Paintable,
    MouseListener

{
    private static final long serialVersionUID = -1495087442680309094L;
    public static final String SN = SizedPanel.class.getSimpleName();
    public boolean debug = true;
    public boolean verbose = false;
    public boolean trace = false;
    
    public Color outlineColor = null;
    Color xColor = null;
    String variableName = "";
    int width;
    int height;
    BufferedImage image;
    List<DrawObject> drawables = new ArrayList<>();
    List<Component> components = new ArrayList<>();
    List<Image> images = new ArrayList<>();
//    Cursor cursor;
    
    List<Object> ordered = new ArrayList<>();
    
    int lastX = -1;
    int lastY = -1;
    
    public SizedPanel(int w, int h) {
        this(w,h,false);
    }
    
    public SizedPanel(int w, int h,boolean doubleBuffered) {
        super(null,doubleBuffered);
        setSize(w,h);
        width = w;
        height = h;
        //setOpaque(true);
        setBackground(TColor.decode("#DCDCDC"));
    }
    
    public SizedPanel(int w, int h, Component c, boolean doubleBuffered) {
        super(null,doubleBuffered);
        setSize(w,h);
        width = w;
        height = h;
        setBackground(c.getBackground());
    }
    
    public SizedPanel(int w, int h, Color bg) {
        this(w,h);
        setBackground(bg);
    }

    public SizedPanel(Dimension d) {
        this(d.width,d.height);
    }

    public SizedPanel(Rectangle r) {
        this(r.width,r.height);
    }
    
    public void addTec(Component c) {
        components.add(c);
        ordered.add(c);
    }
    
    public void addTec(DrawObject drawObject) {
        drawables.add(drawObject);
        ordered.add(drawObject);
    }
    
    public void addTec(Image i) {
        images.add(i);
        ordered.add(i);
    } 
    
    public void doPainting(Graphics g) {
        TColor bg = new TColor(getBackground());
        if (bg != null) g.setColor(bg);
        g.fillRect(0,0,getSize().width,getSize().height);
        if (image != null) {
            GraphicsUtil.paintImageLeft(g,image,this,5);
        }
        Object o;
        for(int i = 0; i < ordered.size();i++) {
            o = ordered.get(i);
            if (o instanceof DrawObject) {
                ((DrawObject)o).draw(g);
            } else if (o instanceof Component) {
                ((Component)o).repaint();
            } else if (o instanceof Image) {
                g.drawImage((Image)o,0,0,this);
            } else if (o instanceof TImage) {
                TImage timage = (TImage)o;
                g.drawImage(timage.getImage(),timage.getTX(),timage.getTY(),this);
            } else if (o instanceof DrawObject) {
                ((DrawObject)o).draw(g);
            }
            if (lastX != -1 && lastY != -1) {
//                Cursor.instance.getActive().paintAt(getGraphics(),lastX,lastY);
            }
        }  
        if (xColor != null) GraphicsUtil.paintX(g,xColor,this);
        if (outlineColor != null) GraphicsUtil.paintOutline(g,outlineColor,this);
    }
    
    public List<Component> getComponentsList() { return components; }
    
    public List<DrawObject> getDrawObjectList() { return drawables; }
    
    public List<Image> getImagesList() { return images; }

    public List<Object> getOrderedList() { return ordered; }

    public boolean getDebug() { return debug; }
    
    public BufferedImage getImage() { return image; }
    
    public int getPaintingWidth() { return getSize().width; }
    
    public Dimension getPreferredSize() { return new Dimension(width,height); }

    public boolean getTrace() { return trace; }
    
    public void mouseClicked(MouseEvent e) {
        
    }
    
    public void mouseDragged(MouseEvent e) {
        lastX = e.getX();
        lastY = e.getY();
        repaint();
    }
    
    public void mouseEntered(MouseEvent e) {
        lastX = e.getX();
        lastY = e.getY();
        repaint();
    }
    
    public void mouseExited(MouseEvent e) {
        lastX = -1;
        lastY = -1;
        repaint();
    }
    
    public void mouseMoved(MouseEvent e) {
        lastX = e.getX();
        lastY = e.getY();
        repaint();
    }
    
    public void mousePressed(MouseEvent e) {}
    
    public void mouseReleased(MouseEvent e) {}
    
    public void mouseWheelMoved(MouseWheelEvent e) {}
    
    public void paint(Graphics g) {
        if (trace) System.out.println("SizedPanel.paint         : Location: " + variableName + ", Outline: " + outlineColor + ", xColor: " + xColor);
        super.paint(g);
        //doPainting(g);
    }
    
    public void paintComponent(Graphics g) {
        if (trace) System.out.println("SizedPanel.paintComponent: Location: " + variableName + ", Outline: " + outlineColor + ", xColor: " + xColor);
        super.paintComponent(g);
        doPainting(g);
    }

    public void paintElement(Graphics g) {
        repaint();
    };

    public void setBackground(Color color) {
        super.setBackground(color);
        repaint();
    }
    
    public void setComponentsList(List<Component> l) {
        this.components = l;
    }
    
    public void setDebug(boolean state) { debug = state; }
    
    public void setDrawablesList(List<DrawObject> l) {
        this.drawables = l;
    }
    
    public void setImage(BufferedImage image) {
        this.image = image;
        setSize(image.getWidth(),image.getHeight());
        getParent().revalidate();
        repaint();
    }
    
    public void setImagesList(List<Image> images) {
        this.images = images;
    }
    
    public void setOrderedList(List<Object> ordered) {
        this.ordered = ordered;
    }
    
    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = new TColor(outlineColor);
        repaint();
    }
    
    public void setSize(int w, int h) {
        super.setSize(w,h);
        width = w;
        height = h;
        repaint();
    }
    
    public void setTrace(boolean state) { trace = state; }
    
    public void setVariableName(String s) {
        variableName = s;
    }
    
    public void setXColor(Color xColor) {
        this.xColor = new TColor(xColor);
        repaint();
    }
    
}
