package ca.tecreations;

import ca.tecreations.time.TimsTime;
import ca.tecreations.misc.*;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author Tim 
 */
public class PixelGrabber extends Thread {
    public static PixelGrabber instance = new PixelGrabber(true);
    BufferedImage capture = null;
    String capturePath = ProjectPath.getTecImagesPath() + "localhost.capture.png";
    Pixel[][] pixels = null;
    Pixel[][][] portions = null;
    
    public boolean running = false;
    public boolean armyFighting = false;
    
    public PixelGrabber(boolean start) {
        if (start) start();
    }

    public Pixel getPixel(int x, int y) {
        return pixels[x][y];
    }
    
    public void launchArmy() {
        armyFighting = true;
        String armyDeployment = new TimsTime().toString();
        System.err.println("DEPLOYING Army: " + armyDeployment);
        System.err.println("INITING : " + new TimsTime());
        int w = capture.getWidth();
        int h = capture.getHeight();
        pixels = new Pixel[h][w];
        for(int y = 0; y < h;y++) {
            for(int x = 0; x < w; x++) {
                pixels[y][x] = null;
            }
        }
        System.err.println("FINISHED: " + new TimsTime().toString());
        int pWidth = capture.getWidth() / 4;
        int pHeight = capture.getHeight() / 4;
        System.out.println("Pixels per portion: " + (pWidth * pHeight));
        System.out.println("Readying to collect portions...");
        if (pWidth * 4 != w || pHeight * 4 != h) {
            System.err.println("Disproportionate sizes. w: " + w + " pW*4: " + pWidth * 4 + " h: " + h + " pH*4: " + pHeight * 4);
        }
        System.out.println("yeah, we'll take care of the extra...0");
        portions = new Pixel[16][pHeight][pWidth];
        System.out.println("readying storage...");
        System.err.println("INKNItTING : " + new TimsTime());
        for(int z = 0; z < 16;z++) {
            for(int y = 0; y < pHeight;y++) {
                for(int x = 0; x < pWidth; x++) {
                    portions[z][y][x] = null;
                }
            }
        }
        System.err.println("FINISHED_de: " + new TimsTime().toString());

        // or /*
        /*for(int i = 0; i < 4;i++) {
            for(int j = 0; j < 4;j++) {
                for(int k = 0; k < pHeight;k++) {
                    for(int l = 0; l < pWidth;l++) {
                        portions[i*4+j][k][l] = null;
                    }
                }
            }
        }
*/
        // extract
        System.err.println("Starting Processing at: " + new TimsTime());
        List<PixelsPlacer> placers = new ArrayList<>();
        int curX = 0;
        int curY = 0;
        for(int y = 0; y < 4; y++) {
            for(int x = 0; x < 4;x++) {
                int[] pixels = ImageTool.extract(capture,curX,curY,pWidth,pHeight);
                PixelsPlacer placer = new PixelsPlacer(portions[y * 4 + x],pixels,pWidth,pHeight);
                placer.start();
                placers.add(placer);
                curX += pWidth;
            }
            curY += pHeight;
        }
        while (placers.size() > 0) {
            for(int i = placers.size() - 1;i >= 0;i--) {
                if (placers.get(i).isDone()) {
                    placers.remove(i);
                }
            }
        }
        TimsTime finished = TimsTime.getCurrent();
        System.err.println("FINISHED_Processing at: " + finished);
        System.err.println("Duration: " + new TimsTime(armyDeployment).getDiff(finished));
        int portion = Platform.getRandom(16);
        System.out.println("GetRandom: (" + portion + "): " + portions[portion][Platform.getRandom(pHeight)][Platform.getRandom(pWidth)].toExternal());
        
        armyFighting = false;
    }
    
    public static void main(String[] args) {
        Platform.sleepSeconds(15);
        instance.stopRunning();
        System.exit(0);
    }
    
    @Override
    public void run() {
        while (running) {
            capture = Platform.getScreenCapture();
            Platform.saveScreenshot(capturePath);
            if (!armyFighting) launchArmy();
            Platform.sleepSeconds(1);
        }
        return;
    }
    
    @Override
    public void start() {
        running = true;
        super.start();
    }
    
    public void stopRunning() {
        running = false;
    }
    
}
