package ca.tecreations;

import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;


/**
 *
 * @author Tim
 */
public class Mouse {
    Point locPoint;
    Point eventPoint;
    boolean altDown = false;
    boolean ctrlDown = false;
    boolean shiftDown = false;
    int count = -1;
    public Long mButton = -1L;
    public Boolean isDown = null;

    public Mouse(MouseEvent e, boolean isDown) {
        locPoint = new Point(e.getLocationOnScreen());
        eventPoint = new Point(e.getX(),e.getY());
        if (SwingUtilities.isLeftMouseButton(e)) {
            mButton = (long)MouseEvent.BUTTON1;
        } else if (SwingUtilities.isRightMouseButton(e)) {
            mButton = (long)MouseEvent.BUTTON3;
        } else {
            mButton = (long)e.getButton();
        }
        if (isDown) count = 0;
        else count = e.getClickCount();
        altDown = e.isAltDown();
        ctrlDown = e.isControlDown();
        shiftDown = e.isShiftDown();
        this.isDown = isDown;
    }
    
    public Mouse(Point loc, Point evt, long mButton, int count, boolean altDown, boolean ctrlDown, boolean shiftDown, Boolean isDown) {
        this.locPoint = loc;
        this.eventPoint = evt;
        this.mButton = mButton;
        this.count = count;
        this.altDown = altDown;
        this.ctrlDown = ctrlDown;
        this.shiftDown = shiftDown;
        this.isDown = isDown;
    }
    
    public static boolean debug = false;
    
    public static Mouse fromString(String s) {
        boolean verbose = false;
        System.out.println("Mouse.fromString: " + s);
        // for location
        int x = Integer.parseInt(s.substring(s.indexOf("(") + 1,s.indexOf(",")));
        int y = Integer.parseInt(s.substring(s.indexOf(",") + 1,s.indexOf(")")));
        Point locPoint = new Point(x,y); 
        // we can garbage x and y but we use them again
        if (debug && verbose) System.out.println("locPoint: " + locPoint);
        String remainder = s.substring(s.indexOf(":") + 1);
        if (debug && verbose) System.out.println("Remainder: " + remainder);
        
        // for event
        String intPart = remainder.substring(remainder.indexOf("(") + 1,remainder.indexOf(","));
        x = Integer.parseInt(intPart);
        y = Integer.parseInt(remainder.substring(remainder.indexOf(",") + 1,remainder.indexOf(")")));
        Point eventPoint = new Point(x,y);
        remainder = remainder.substring(remainder.indexOf(":") + 1); 
        if (debug && verbose) System.out.println("evtPoint: " + eventPoint);
        if (debug && verbose) System.out.println("Remainder: " + remainder);
        
        String next = remainder.substring(0,remainder.indexOf(":"));
        if (debug && verbose) System.out.println("Next: " + next);
        int mButton = Integer.parseInt(next);
        remainder = remainder.substring(remainder.indexOf(":") + 1);
        if (debug && verbose) System.out.println("mButton: " + mButton);
        if (debug && verbose) System.out.println("Remainder: " + remainder);
        
        next = remainder.substring(0,remainder.indexOf(":"));
        int count = Integer.parseInt(next);
        remainder = remainder.substring(remainder.indexOf(":") + 1);
        if (debug && verbose) System.out.println("count: " + count);
        if (debug && verbose) System.out.println("Remainder: " + remainder);
        
        next = remainder.substring(0,remainder.indexOf(":"));
        boolean altDown = next.equals("alt");
        if (debug && verbose) System.out.println("altDown: " + altDown);
        remainder = remainder.substring(remainder.indexOf(":") + 1);
        
        if (debug && verbose) System.out.println("Remainder: " + remainder);
        next = remainder.substring(0,remainder.indexOf(":"));
        boolean ctrlDown = next.equals("ctrl");
        if (debug && verbose) System.out.println("ctrlDown: " + ctrlDown);
        remainder = remainder.substring(remainder.indexOf(":") + 1);
        
        if (debug && verbose) System.out.println("Remainder: " + remainder);
        next = remainder.substring(0,remainder.indexOf(":"));
        boolean shiftDown = next.equals("shift");
        if (debug && verbose) System.out.println("shiftDown: " + shiftDown);
        remainder = remainder.substring(remainder.indexOf(":") + 1);
        
        if (debug && verbose) System.out.println("Remainder: " + remainder);
        next = remainder.substring(0,remainder.indexOf("]"));
        Boolean isDown;
        if (next.equals("down")) isDown = true;
        else if (next.equals("up")) isDown = false;
        else isDown = null; // storage-wise, you could use a :: type separator, indicating 'NOT_PRESENT' similar to altDown etc.
        if (debug && verbose) System.out.println("isDown: " + isDown);

        return new Mouse(locPoint,eventPoint,mButton,count,altDown,ctrlDown,shiftDown,isDown);
    }
    
    //--------------------------------------------------------------------------
    

    public int getCount() { return count; }
    
    public int getDownMask() {
        if (mButton == MouseEvent.BUTTON2) return MouseEvent.BUTTON2_DOWN_MASK;
        if (mButton == MouseEvent.BUTTON3) return MouseEvent.BUTTON3_DOWN_MASK;
        return MouseEvent.BUTTON1_DOWN_MASK;
    }
    
    public Point getEventPoint() { return eventPoint; }
    
    public int getEventX() { return eventPoint.x; }
    
    public int getEventY() { return eventPoint.y; }
    
    public Point getLocOnScreen() {
        return locPoint;
    }

    public Point getLocPoint() { return locPoint; }
    
    public int getLocX() { return locPoint.x; }
    
    public int getLocY() { return locPoint.y; }
    
    public int getUpMask() {
        if (mButton == MouseEvent.BUTTON2) return MouseEvent.BUTTON2_DOWN_MASK;
        if (mButton == MouseEvent.BUTTON3) return MouseEvent.BUTTON3_DOWN_MASK;
        return MouseEvent.BUTTON1_DOWN_MASK;
    }
    
    public boolean isAltDown() { return altDown; }
    
    public boolean isControlDown() { return ctrlDown; }
    
    public boolean isCtrlDown() { return ctrlDown; }
    
    public boolean isDown() { return isDown; }

    public boolean isLeft() { return mButton == MouseEvent.BUTTON1; }
    
    public boolean isMiddle() { return mButton == MouseEvent.BUTTON2; }
    
    public boolean isRight() { return mButton == MouseEvent.BUTTON3; }
    
    public boolean isShiftDown() { return shiftDown; }
    
    public boolean isUp() { return !isDown; }
    
    public static void main(String[] args) {
        Point loc = new Point(100,100);
        Point evt = new Point(1024,1024);
        Mouse mouse = new Mouse(loc,evt,7,0,true,true,true,false);
        System.out.println(mouse.toString());
        
        Mouse mouseFrom = Mouse.fromString(mouse.toString());
        mouse = new Mouse(loc,evt,7,1,true,true,true,null);
        System.out.println(mouse.toString());
        
        System.out.println(Mouse.fromString("Mouse[(88,99):(188,199):1:0::ctrl::up]").toString());
    }
    
    

    public String toString() {                                                     // [{}] denotes a possible value
                                                                                   // ':' separates parts
                                                                                   
        String transportString = "Mouse[(" + locPoint.x + "," + locPoint.y + "):"; // Mouse[(locX,locY): -- screen point
        transportString += "(" + eventPoint.x + "," + eventPoint.y + "):";         // (evtX,evtY):       -- relative to receiver component
        transportString += mButton + ":";                                          // d*d:               -- mouse button num
        transportString += count + ":";                                            // d*d:               -- click count, min 0, max?
        transportString += (altDown ? "alt:" : ":");                               // [{alt}]:           -- if alt not present/down then just ':'
        transportString += (ctrlDown ? "ctrl:" : ":");                             // [{ctrl}]:          -- if ctrl not present/down then just ':'
        transportString += (shiftDown ? "shift:" : ":");                           // [{shift}]:         -- if shift not present/down then just ':'
        if (count == 0) {                                                          // [null|up|down)]    -- null if count > 0
            if (isDown) transportString += "down";
            else transportString += "up";
        } else {
            transportString += "null";
        }
        transportString += "]";                                                    // ]
        return transportString;
    }
}