package ca.tecreations.time;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;

/**
 *
 * @author tim
 */
public class Date {
    int year = 1970;
    int month = 1;
    int day = 1;
    
    public Date() {
        LocalDate date = LocalDate.now();
        year = date.getYear();
        month = date.getMonthValue();
        day = date.getDayOfMonth();
    }
    
    public Date(int year) {
        this.year = year;
    }
    
    public Date(int year, int month) {
        this.year = year;
        this.month = month;
        while(this.month > 12) {
            month -= 12;
            year++;
        }
    }
    
    public Date(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
        while (this.day > getDaysInMonth(this.year,this.month)) {
            this.day -= getDaysInMonth(this.year,this.month);
            this.month++;
            while (this.month > 12) {
                this.month -= 12;
                year++;
            }
        }
        while (this.month > 12) {
            this.month -= 12;
            this.year++;
        }
    }
    
    public static java.util.Date getJavas(int h, int m, int s) {
        return new java.util.Date(h,m,s);
    }
    
    //--------------------------------------------------------------------------
    
    public Date clone() { 
        return new Date(year,month,day);
    }
    
    public boolean equals(Date target) {
        return (year == target.getYear() && month == target.getMonth() && day == target.getDay());
    }
    
    public int getDay() { return day; }
    
    public int getDaysInMonth() {
        if (month == 2) {
            boolean isLeapYear = LocalDate.now().withYear(year).isLeapYear();
            if (isLeapYear) return 29;
            else return 28;
        }
        if (month == 4) return 30;
        if (month == 6) return 30;
        if (month == 9) return 30;
        if (month == 11) return 30;
        return 31;
    }
    
    public int getDaysInMonth(int year, int month) {
        if (month == 2) {
            boolean isLeapYear = LocalDate.now().withYear(year).isLeapYear();
            if (isLeapYear) return 29;
            else return 28;
        }
        if (month == 4) return 30;
        if (month == 6) return 30;
        if (month == 9) return 30;
        if (month == 11) return 30;
        return 31;
    }
    
    public Date getDecremented() {
        day--;
        if (day == 0) {
            month--;
            if (month == 0) {
                month = 12;
                year--;
            }
            day = getDaysInMonth(year,month);
        }
        return new Date(year,month,day);
    }
     
    public Date getIncremented() {
        int daysInMonth = getDaysInMonth(year,month);
        day++;
        if (day > daysInMonth) { // crosses month boundary
            day = 1;
            month++;
            if (month > 12)  { // crosses the year boundary
                month = 1;
                year++;
            }
        }
        return new Date(year,month,day);
    }

    public int getMonth() { return month; }
    
    public String getSeparated(char separator) {
        return "" + year + separator + month + separator + day;
    }
    
    public String getSeparated(String separator) {
        return year + separator + month + separator + day;
    }
    
    public String getShortDayOfWeek() {
        LocalDate date = LocalDate.now().withYear(year).withMonth(month).withDayOfMonth(day);
        String dow = date.getDayOfWeek().toString();
        System.out.println("DayOfWeek: " + dow);
        return dow;
    }
    
    public int getYear() { return year; }

    public boolean isLeapYear() {
        if ((year % 4 == 0 && year % 100 != 0)  
            || (year % 400 == 0)) { 
            return true; 
        } else { 
            return false; 
        } 
    }
    
     
    public void setYMD(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }
    
    public void setDay(int day) { this.day = day; }
    
    public void setMonth(int month) { this.month = month; }
    
    public void setYear(int year) { this.year = year; }
    
    public String toFileString() {
        return year + "." + month + "." + day;
    }
    
    public String toString() {
        return getSeparated('/');
    }
    
}
