package ca.tecreations.apps.filetool;

import ca.tecreations.ExceptionHandler;
import ca.tecreations.FileEntry;
import ca.tecreations.apps._data.FileListTransferable;
import ca.tecreations.apps._data.FileListTransferHandler;
import ca.tecreations.apps._gui.EntriesPanel;
import ca.tecreations.EnvData;
import ca.tecreations.File;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.Sort;
import ca.tecreations.StringTool;
import ca.tecreations.SystemToken;
import ca.tecreations.TecData;
import ca.tecreations.TextFile;
import ca.tecreations.apps.*;
import ca.tecreations.apps._gui.*;
import ca.tecreations.components.Status;
import ca.tecreations.components.JobProgressDialog;
import ca.tecreations.components.ProgressDialog;
import ca.tecreations.components.YesNoDialog;
import ca.tecreations.components.event.ProgressListener;
import ca.tecreations.net.Client;
import ca.tecreations.net.Server;
import ca.tecreations.net.NameService;
import ca.tecreations.net.NoTLSConnectionException;

import java.awt.BorderLayout;
import java.awt.event.*;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.*;

/**
 *
 * @author tim
 */
public class FileTool extends App implements DropTargetListener, ItemListener {

    public static final String SN = FileTool.class.getSimpleName();
    public static String propsPath = ProjectPath.getTecPropsPath() + SN + ".properties";
    public static boolean trace = true;
    public static boolean debug = true;

    public static boolean isStandalone = false;
    public static boolean startQuiet = true;
    public static String oldEnvironment = EnvData.DEV;

//    static LocalTLSServer localServer;
    public static FileTool instance;
    public static ProgressDialog itemProgress;
    public static JobProgressDialog jobProgress;
    public static ProgressListener pl;
    Properties properties;
    JSplitPane split;

    EntriesPanel left;
    Client lClient;

    EntriesPanel right;
    Client rClient;

    Status status = new Status(true, false, false, false, false);

    DropTarget ldt;
    DropTarget rdt;

    public EntriesPanel dragSrc = null;

    public static Map<String, Client> clients = new HashMap<>();

    EntriesPanel lastDst = null;

    public static TextFile log = null;

    JMenuBar menu = new JMenuBar();
    JMenu java = new JMenu("Java");
    JCheckBoxMenuItem showClasses = new JCheckBoxMenuItem("Show Classes");

    static Properties serverProperties = new Properties(ProjectPath.getNetConfigPath() + "LocalTLSServer.properties");

    public static NameService ns = NameService.INSTANCE;

    
    public FileTool() {
        super(propsPath, SN);
        if (isStandalone) {
            setExitOnClose(true);
        }
        properties = getProperties();
        System.out.println(FileTool.class.getSimpleName() + ": using properties: "
                + properties.getFilename());
        menu.add(java);
        java.add(showClasses);
        Boolean showClassesB = properties.getBoolean("show.classes");
        if (showClassesB == null) {
            showClassesB = true;
            properties.set("show.classes", showClassesB);
            showClasses.setSelected(true);
        } else {
            showClasses.setSelected(showClassesB);
        }
        showClasses.addItemListener(this);
        setJMenuBar(menu);

        if (serverProperties.wasCreated()) {
            if (!Platform.isWin()) {
                new File(serverProperties.getFilename()).setPOSIXFilePermissions(600);
                // sudo chmod 600
            }
        }

        if (properties.wasCreated()) {
            lClient = getNewClient("localhost");
            rClient = getNewClient("localhost");
        } else {
            String storedServer = getStoredServer("l");
            if (storedServer == null) {
                storedServer = "localhost";
                storeServer("l", storedServer);
            }
            lClient = getNewClient(storedServer);

            storedServer = getStoredServer("r");
            if (storedServer == null) {
                storedServer = "localhost";
                storeServer("r", storedServer);
            }
            rClient = getNewClient(storedServer);
        }
        setupGUI();

        if (properties.wasCreated()) {
            doInitialConfiguration();
        } else {
            doSubsequentConfiguration();
        }

        left.addListeners();
        right.addListeners();
        lastDst = right; // set to something so we don't get NPE
        left.getEntries();
        right.getEntries();
    }

    public void actionPerformed(ActionEvent e) {
        String text = status.getCommandText();
        String lower = text.toLowerCase();
        Client client = null;
        String command = "";
        List<SystemToken> tokens;
        String remainder = "";
        if (lower.startsWith("left ")) {
            remainder = lower.substring("left ".length());
            System.out.println("Remainder: " + remainder);
            if (remainder.startsWith("cmd ")) {
                command = text.substring("cmd ".length());
                client = left.getClient();
                tokens = client.execForOutput(command);
                for (int i = 0; i < tokens.size(); i++) {
                    tokens.get(i).println();
                }
            } else if (remainder.startsWith("msg ")) {
                String msg = text.substring("left msg ".length());
                //left.sendMessage(msg);
                status.getCommand().setText("");
            } else if (remainder.startsWith("print ")) {
                String name = text.substring("left print ".length());
                System.out.println("Name : " + name);
                FileEntry entry = left.getEntry(name);
                System.out.println("Entry: " + entry.toString());
            } else if (remainder.startsWith("msg ")) {
                String msg = text.substring("left msg ".length());
                //left.sendMessage(msg);
                status.getCommand().setText("");
            }
        } else if (lower.startsWith("right ")) {
            remainder = lower.substring("right ".length());
            System.out.println("Remainder: " + remainder);
            if (remainder.startsWith("cmd ")) {
                command = text.substring("right cmd ".length());
                System.out.println("command: " + command);
                client = right.getClient();
                tokens = client.execForOutput(command);
                for (int i = 0; i < tokens.size(); i++) {
                    tokens.get(i).println();
                }
            } else if (remainder.startsWith("msg ")) {
                String msg = text.substring("right msg ".length());
                //right.sendMessage(msg);
                status.getCommand().setText("");
            } else if (remainder.startsWith("print ")) {
                String name = text.substring("right print ".length());
                System.out.println("Name : " + name);
                FileEntry entry = right.getEntry(name);
                System.out.println("Entry: " + entry.toString());
            }
        }
    }

    public void close() {
        stopServer();
        super.close();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        super.componentResized(e);
        split.setDividerLocation(getSize().width / 2);
    }

    public static void createAndShowGUI() {
        instance = new FileTool();
        instance.setVisible(true);
        instance.toFront();
        itemProgress = new ProgressDialog(instance);
        jobProgress = new JobProgressDialog(instance);
    }

    public void deleteHost(String name) {
        NameService.INSTANCE.deleteByKey(name);
        left.deleteHost(name);
        right.deleteHost(name);
        // do we also want to delete the configuration for the host?
        YesNoDialog dialog = new YesNoDialog(this,"Delete configuration?","Do you want to delete " + name + "'s configuration?");
        dialog.setVisible(true);
        boolean response = dialog.isYes();
        if (response) {
            Properties properties = getPropertiesFor(name);
            properties.deleteFile();
        }
    }
    
    public void doDrop(DropTargetDropEvent dtde, FileEntriesTable dst, List<String> names) {
        String logsPath = ProjectPath.INSTANCE.getProjectPath() + "logs" + File.separator;
//        if (!new File(logsPath).exists()) File.mkdirs(logsPath);
//        log = new TextFile(File.getNextFileName(ProjectPath.INSTANCE.getProjectPath() + "logs" + File.separator + "log.txt"),true);
        System.out.println("Using log: " + log.getAbsolutePath());

        // names are sorted previously when getting the selection
        EntriesPanel src = dragSrc;
        lastDst = dst.getEntriesPanel();
        Client srcClient = src.getClient();
        Client dstClient = lastDst.getClient();
        int row = dst.rowAtPoint(dtde.getLocation());
        int col = dst.columnAtPoint(dtde.getLocation());

        srcClient.log = log;
        dstClient.log = log;
        clients.get("localhost").log = log;
        doLogAction("Row: " + row + "Col: " + col);
        doLogAction("EntriesWindow.doDrop: src: " + dragSrc.getId() + " : dst: " + dst.getSide());

        // is it drop in dir?
        boolean dropInDir = false;
        FileEntry entry = null;
        String dropTarget = "";
        if (row >= 0) {
            entry = dst.getBaseTableModel().getEntry(row);
            if (col == 0 && entry.isDirectory()) {
                dropInDir = true;
            }
            if (col == 0) {
                dropTarget = entry.getDisplayName();
            }
        }
        if (entry != null) {
            doLogAction("Target: " + entry.getName());
        }
        doLogAction("DropInDir: " + dropInDir + " Names: " + names);

        // set destination path
        String dstDirPath = dst.getEntriesPanel().getSelectedPath();
        if (dropInDir) {
            dstDirPath += dropTarget + dstClient.getFileSeparator();
        }

        // size job
        long jobSize = 0L;
        List<Long> sizes = new ArrayList<>(); // replace with: getSizes(List<String> names); // or something alike
//        List<Long> sizes = srcClient.getSizes(names);
        for (int i = 0; i < sizes.size(); i++) {
            jobSize += sizes.get(i);
        }

        // ensure enough space for operation
        long usable = dstClient.getUsableSpace(dstDirPath);
        if (Long.valueOf(usable) < jobSize) {
            Platform.message(this, "Not enough space on destination server.");
            return;
        }
        log.add("Job Size: " + jobSize);

        if (dtde.getDropAction() == DnDConstants.ACTION_COPY
                || dtde.getDropAction() == DnDConstants.ACTION_MOVE) {

            if (src.getServer().equals(dst.getServer())) {
                String srcPath = src.getTable().getCurrentPath();
                String dstPath = dst.getCurrentPath();
                if (dropInDir) {
                    new CopyOnHostDropIn(this, log, srcClient, names, dstDirPath)
                            .start();
                } else {
                    new CopyOnHost(this, log, srcClient, srcPath, names, dstPath)
                            .start();
                }
                // this is to/from remote to/from localhost
            } else if ((src.getServer().equals("localhost") | dst.getServer().equals("localhost")
                    && (dtde.getDropAction() == DnDConstants.ACTION_COPY || dtde.getDropAction() == DnDConstants.ACTION_MOVE))) {
                if (src.getServer().equals("localhost")) {
                    Put putJob = new Put(this, log, dstClient,
                            StringTool.getDoubleQuoted(src.getSelectedPath()),
                            StringTool.getDoubleQuoted(src.getSelectedPath()),
                            names, jobSize, dstDirPath);
                    putJob.start();
                } else if (dst.getServer().equals("localhost")) {
                    // retrieve from server
                    Get getJob = new Get(this, log, srcClient,
                            src.getSelectedPath(),
                            src.getSelectedPath(), names, jobSize,
                            dstDirPath, dstClient.getFileSeparator());
                    getJob.start();
                }
                // remote to remote
            } else if (!src.getServer().equals("localhost")
                    && !dst.getServer().equals("localhost")) {
                Client localClient = clients.get("localhost");
                // remote to remote
                String tempDir = getTempDir(clients.get("localhost"), jobSize);
                if (tempDir.equals("")) {
                    System.err.println("DoDrop: error not enough space on local machine.");
                    return;
                }
                new File(tempDir).mkdirs(); // create temp dir on local machine
                List<String> tempNames = new ArrayList<>();
                String name;
                for (int i = 0; i < names.size(); i++) {
                    File f = new File(names.get(i));
                    name = tempDir + f.getName();
                    File newFile = new File(name);
                    tempNames.add(newFile.getAbsolutePath());
                    doLogAction("Adding: " + newFile.getAbsolutePath());
                }

                String wrappedTemp = StringTool.getDoubleQuoted(tempDir);
                String wrappedSrc = StringTool.getDoubleQuoted(src.getSelectedPath());
                if (dropInDir) {
                    String newDst = StringTool.getDoubleQuoted(dstDirPath + dropTarget + dstClient.getFileSeparator());
                    doLogAction("Getting to: " + tempDir);
                    Get getJob = new Get(this, null, srcClient,
                            wrappedSrc, wrappedSrc, names, jobSize,
                            wrappedTemp, File.separator);
                    getJob.start();
                    while (!getJob.isDone()) {
                        Platform.sleep(1000);
                    }
                    doLogAction("Done getting...");

                    doLogAction("Validating TempNames...");
                    List<String> newTempNames = new ArrayList<>();
                    for (int i = 0; i < tempNames.size(); i++) {
                        File f = new File(tempNames.get(i));
                        String sep = (f.getAbsolutePath().contains("/") ? "/" : "\\");
                        if (f.exists() && f.isDirectory()) {
                            name = f.getUnwrapped();
                            if (!name.endsWith(sep)) {
                                name += sep;
                            }
                            newTempNames.add(StringTool.getDoubleQuoted(name));
                        } else {
                            newTempNames.add(f.getAbsolutePath());
                        }
                    }

                    doLogAction("About to call Put: host: " + dstClient.getHostName()
                            + " root: " + tempDir + " names: " + newTempNames + " dst: " + dstDirPath);
                    Put putJob = new Put(this, log, dstClient, wrappedTemp,
                            StringTool.getDoubleQuoted(tempDir), newTempNames,
                            jobSize, StringTool.getDoubleQuoted(dstDirPath + dropTarget + dstClient.getFileSeparator()));
                    putJob.start();
                } else {
                    Platform.message(this, "Remote/Remote");
                    String srcPath = src.getSelectedPath();
                    Get getJob = new Get(this, log, srcClient,
                            wrappedSrc, srcPath, names, jobSize,
                            wrappedTemp, File.separator);
                    getJob.start();
                    while (!getJob.isDone()) {
                        Platform.sleep(1000);
                    }
                    doLogAction("Done getting...");

                    doLogAction("Validating TempNames...");
                    List<String> newTempNames = new ArrayList<>();
                    for (int i = 0; i < tempNames.size(); i++) {
                        File f = new File(tempNames.get(i));
                        String sep = (f.getAbsolutePath().contains("/") ? "/" : "\\");
                        if (f.exists() && f.isDirectory()) {
                            name = f.getUnwrapped();
                            if (!name.endsWith(sep)) {
                                name += sep;
                            }
                            newTempNames.add(StringTool.getDoubleQuoted(name));
                        } else {
                            newTempNames.add(f.getAbsolutePath());
                        }
                    }

                    doLogAction("About to call Put: host: " + dstClient.getHostName()
                            + " root: " + tempDir + " names: " + newTempNames + " dst: " + dstDirPath);
                    Put putJob = new Put(this, log, dstClient, wrappedTemp,
                            StringTool.getDoubleQuoted(tempDir), newTempNames,
                            jobSize, StringTool.getDoubleQuoted(dstDirPath));
                    putJob.start();

                }
            }

            // if move, do delete
            if (dtde.getDropAction() == DnDConstants.ACTION_MOVE) {
                // finally, remove the entries if need be
                System.out.println(FileTool.class
                        .getSimpleName() + ".doDrop: Deleting from src: " + src.getTable().getHost());
                for (int i = 0; i < names.size(); i++) {
                    System.out.println(i + ": " + names.get(i));
                }
            }
            lastDst.getEntries();
        }
    }

    public void doInitialConfiguration() {
        List<String> roots = lClient.listRoots();
        char initRoot = roots.get(0).charAt(0);

        left.storeServer("localhost");
        left.setServer("localhost");
        left.setRootsQuiet();
        left.setRoot(initRoot);
        left.storeRoot(initRoot);
        left.storePath("");

        right.storeServer("localhost");
        right.setServer("localhost");
        right.setRootsQuiet();
        right.setRoot(initRoot);
        right.storeRoot(initRoot);
        right.storePath("");
    }

    public void doLogAction(String msg) {
        if (log != null) {
            log.add(msg);
        } else {
            System.out.println(msg);
        }
    }

    public void doSubsequentConfiguration() {
        left.setServer(lClient.getHostName());
        Character storedRoot = null;
        left.setRootsQuiet();
        storedRoot = left.getStoredRoot();
        String storedPath = left.getStoredPath();
        if (storedPath == null) {
            left.setPath(""); // this call automatically stores the selected path
        } else {
            left.setPath(left.getStoredPath()); // this call automatically stores the selected path
        }
        if (!lClient.exists(left.getSelectedPath())) {
            left.setPath(""); // this call automatically stores the selected path
        }

        right.setServer(rClient.getHostName());
        storedRoot = null;
        right.setRootsQuiet();
        storedRoot = right.getStoredRoot();
        storedPath = right.getStoredPath();
        if (storedPath == null) {
            right.setPath(""); // this call automatically stores the selected path
        } else {
            right.setPath(right.getStoredPath()); // this call automatically stores the selected path
        }
        if (!rClient.exists(right.getSelectedPath())) {
            right.setPath(""); // this call automatically stores the selected path
        }
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    @SuppressWarnings("unchecked")
    public void drop(DropTargetDropEvent dtde) {
        boolean canDrop = true;
        FileEntriesTable dst = (FileEntriesTable) dtde.getDropTargetContext().getComponent();
        try {
            Transferable tr = dtde.getTransferable();
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            FileEntriesTable src = dragSrc.getTable();
            for (int i = 0; i < flavors.length; i++) {
                if (flavors[i].equals(FileListTransferable.getListFlavor())) {
                    List<String> list = (List<String>) tr.getTransferData(flavors[i]);
                    if (src.getServer().equals(dst.getServer())) {
                        if (src.getCurrentPath().equals(dst.getCurrentPath())) {
                            int row = dst.rowAtPoint(dtde.getLocation());
                            int col = dst.columnAtPoint(dtde.getLocation());
                            FileEntriesTableModel model = dst.getBaseTableModel();
                            if (row == -1) {
                                canDrop = true;
                            } else {
                                FileEntry entry = model.getEntry(row);
                                if (col == 0 && entry.isDirectory()) {
                                    canDrop = !inList(entry.getName(), list);
                                } else if (dtde.getDropAction() == DnDConstants.ACTION_MOVE) {
                                    canDrop = false;
                                }
                            }
                        }
                    }
                    if (canDrop) {
                        dtde.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
                        doDrop(dtde, dst, list);;
                        dtde.dropComplete(true);
                        return;
                    }
                }
            }
            dtde.rejectDrop();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public Client getClient(String host) {
        Client c = clients.get(host);
        if (c == null) {
            return clients.get("localhost");
        } else {
            return c;
        }
    }

    public void getFileList(List<String> sources, String path) {
        File f = new File(path);
        File[] list = f.tecListFiles();
        List<String> files = new ArrayList<>();
        List<String> dirs = new ArrayList<>();
        for (int i = 0; i < list.length; i++) {
            if (list[i].isFile()) {
                files.add(list[i].getAbsolutePath());
            } else {
                dirs.add(list[i].getAbsolutePath());
            }
        }
        files = Sort.sort(files);
        dirs = Sort.sort(dirs);
        for (int i = 0; i < files.size(); i++) {
            sources.add(files.get(i));
        }
        for (int i = 0; i < dirs.size(); i++) {
            getFileList(sources, dirs.get(i));
        }
    }

    public JobProgressDialog getJobProgressDialog() {
        return jobProgress;
    }

    public EntriesPanel getLeft() {
        return left;
    }

    public Client getNewClient(String label) {
        Client c = clients.get(label);
        Client newClient = null;
        try {
            if (c == null) {
                newClient = new Client(getClient("localhost"));
            } else {
                newClient = new Client(c);
            }
        } catch (NoTLSConnectionException ntlsce) {
            ExceptionHandler.handle(SN + ".getRightClient", "no TLS connection", ntlsce, true);
            Platform.message(this, SN + ".getNewClient(" + label + "): no TLS connection: reverting to localhost");
            try {
                newClient = new Client(getClient("localhost"));
            } catch (NoTLSConnectionException ntlsce2) {
                Platform.message(this, SN + ".getNewClient(localhost): no TLS connection to localhost. Exiting.");
                System.exit(0);
            }
        }
        return newClient;
    }

    public ProgressDialog getProgressDialog() {
        return itemProgress;
    }

    public static Properties getPropertiesFor(String tag) {
        return new Properties(getPropertiesFilenameForClient(tag));
    }

    public static String getPropertiesFilenameForClient(String id) {
        return ProjectPath.getNetConfigPath() + id + "_client.properties";
    }

    public String getRemoteHostFromPropertiesFilename() {
        String propsFilename = properties.getFilename();
        String name = new File(propsFilename).getName();
        String host = name.substring(0, name.indexOf("_"));
        return host;
    }

    public EntriesPanel getRight() {
        return right;
    }

    public String getSide(EntriesPanel p) {
        if (p.getServer().equals(left.getServer())) {
            if (p.getRoot().equals(left.getRoot())) {
                if (p.getPath().equals(left.getPath())) {
                    return "l";
                }
            }
        }
        return "r";
    }

    public String getStoredServer(String side) {
        String storedServer = TecData.UNSET_S;
        if (side.toLowerCase().equals("l")) {
            storedServer = properties.get("l.host");
        } else {
            storedServer = properties.get("r.host");
        }
        if (storedServer == null) {
            storedServer = "localhost";
        }
        return storedServer;
    }

    public String getTempDir(Client localClient, long jobSize) {
        String tempDir = "";
        List<String> roots = localClient.listRoots();
        int i = 0;
        long usable = 0L;
        while (tempDir.equals("") && i < roots.size()) {
            String unwrappedRoot = StringTool.getUnwrapped(roots.get(i));
            usable = localClient.getUsableSpace(roots.get(i));
            if (usable >= jobSize) {
                tempDir = unwrappedRoot + "temp" + localClient.getFileSeparator();
            }
            i++;
        }
        return tempDir;
    }
    
    public void ifCanConnectAddTo_ListOfServer(String label) {
        
    }

    public boolean inList(String target, List<String> items) {
        for (int i = 0; i < items.size(); i++) {
            if (items.get(i).equals(target)) {
                return true;
            }
        }
        return false;
    }

    public boolean isShowClasses() {
        return showClasses.isSelected();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == showClasses) {
            left.getEntries();
            right.getEntries();
        }
        properties.set("show.classes", showClasses.isSelected());
    }

    public static void launch() {
        isStandalone = true;
        startServer();
        if (ns.getProperties().wasCreated()) {

        }
        List<String> labels = ns.getListed();
        for (int i = 0; i < labels.size(); i++) {
            String label = labels.get(i);
            String tag = ns.getPropertiesTag(labels.get(i));
            System.out.println("Label: " + labels.get(i) + " Tag: " + tag);
            if (!label.contains(" ")) {
                if (label.contains(".")) {
                    tag = label;
                } else if (label.toLowerCase().equals("localhost")) {
                    tag = "localhost";
                }
            } else {
                tag = label;
            }
            Client client = null;
            try {
                client = new Client(getPropertiesFor(tag), true, null);
                clients.put(labels.get(i), client);
            } catch (NoTLSConnectionException ntlsce) {
                ExceptionHandler.handle(SN + ".launch", "no TLS connection", ntlsce, false);
            }
            //if (startQuiet) client.setEnvironment(EnvData.PROD);

        }
        SwingUtilities.invokeLater(() -> {
            createAndShowGUI();
        });
    }

    public boolean leftEqualsRight() {
        return (left.getServer().equals(right.getServer())
                && left.getRoot().equals(right.getRoot())
                && left.getPath().equals(right.getPath()));
    }

    public static void main(String[] args) {
        launch();
    }

    public void refreshLast() {
        lastDst.getEntries();
    }

    public void storeServer(String side, String host) {
        if (side.toLowerCase().equals("l")) {
            properties.set("l.host", host);
        } else {
            properties.set("r.host", host);
        }
    }

    public void setProgress(ProgressListener progress) {
        pl = progress;
    }

    public void setupDND() {
        // drag and drop
        FileEntriesTable lEntries = left.getTable();
        FileEntriesTable rEntries = right.getTable();
        lEntries.setDragEnabled(true);
        rEntries.setDragEnabled(true);

        lEntries.setTransferHandler(new FileListTransferHandler());
        rEntries.setTransferHandler(new FileListTransferHandler());

        lEntries.setDropMode(DropMode.ON_OR_INSERT_ROWS);
        rEntries.setDropMode(DropMode.ON_OR_INSERT_ROWS);

        ldt = new DropTarget(lEntries, this);
        rdt = new DropTarget(rEntries, this);

    }

    public void setupGUI() {
        setTitle("FileTool");
        split = new JSplitPane();
        List<String> serverLabels = ns.getListed();
        left = new EntriesPanel(this, lClient, "LEFT", 1, 1);
        left.setServerLabels(serverLabels);
        left.setId("LEFT");

        right = new EntriesPanel(this, rClient, "RIGHT", 1, 1);
        right.setServerLabels(serverLabels);
        right.setId("RIGHT");

        split.setLeftComponent(left);
        split.setRightComponent(right);
        add(split, BorderLayout.CENTER);
        validate();
        split.setDividerLocation(getSize().width / 2);
        //split.setDividerLocation((getSize().width / 2) - (split.getSize().width / 2));

        add(status, BorderLayout.SOUTH);
        status.getCommand().addActionListener(this);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        setupDND();
    }

    public static void startServer() {
        if (trace) {
            System.out.println(SN + ".startServer");
        }
        String isRunning = serverProperties.get("is.running");
        if (isRunning != null && isRunning.toUpperCase().equals("TRUE")) {
            // if running, stop
            serverProperties.set("shutdown", true);
            Platform.sleep(1000);
        }
        boolean withTSPS = true;
        boolean verbose = true;
        Server server = new Server(serverProperties, true, null, withTSPS, debug, verbose);
    }

    public static void stopServer() {
        serverProperties.set("shutdown", true);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        if (pl != null) {
            pl.toFront();
        }
    }

}
