package ca.tecreations.apps.deploy;

import ca.tecreations.TColor;
import ca.tecreations.Properties;
import ca.tecreations.components.SizedPanel;

import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.*;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.*;

/**
 *
 * @author Tim de Vries
 */
public class CodeSigning extends JPanel implements ActionListener, DocumentListener, ItemListener {
    Deploy deployment;
    Properties properties;
    JCheckBox active = new JCheckBox("Code Signing",false);
    JLabel signedJarPrefixLabel = new JLabel("Signed Jar Prefix:");
    JTextField signedJarPrefix = new JTextField("signed-",32);
    JLabel outputFilenameLabel = new JLabel("Output Filename:");
    JTextField signedOutputFilename = new JTextField(32);
    
    JLabel timestampAuthorityLabel = new JLabel("Timestamp Authority:");
    String[] tsas = { 
        "http://timestamp.digicert.com", 
        "http://timestamp.comodoca.com/rfc3161", 
        "http://timestamp.globalsign.com/scripts/timstamp.dll",
        "https://timestamp.geotrust.com/tsa" ,
        "http://timestamp.wosign.com" ,
        "http://tsa.startssl.com/rfc3161" ,
        "http://time.certum.pl" ,
        "https://freetsa.org" ,
        "http://dse200.ncipher.com/TSS/HttpTspServer" ,
        "http://tsa.safecreative.org" ,
        "http://zeitstempel.dfn.de" ,
        "https://ca.signfiles.com/tsa/get.aspx" ,
        "http://services.globaltrustfinder.com/adss/tsa" ,
        "https://tsp.iaik.tugraz.at/tsp/TspRequest" ,
        "http://timestamp.apple.com/ts01" ,
        "http://timestamp.entrust.net/TSS/RFC3161sha2TS"
    };
    JComboBox<String> tsa = new JComboBox<>(tsas);
    JLabel keystoreLabel = new JLabel("Keystore:");
    JTextField keystore = new JTextField(40);
    JButton selectKeystore = new JButton("Select");
    JLabel keystorePassLabel = new JLabel("Keystore Password:");
    JPasswordField keystorePass = new JPasswordField(40);
    JCheckBox showPasses = new JCheckBox("Show Passes");
    JLabel aliasLabel = new JLabel("Alias:");
    JTextField alias = new JTextField(8);
    JLabel keyPassLabel = new JLabel("Key Password:");
    JPasswordField keyPass = new JPasswordField(40);
    char echoChar = keystorePass.getEchoChar();
    
    boolean setup = false;
    
    public CodeSigning(Deploy deployment) {
        this.deployment = deployment;
        properties = this.deployment.getProperties();
        if (deployment.getProperties().wasCreated()) {
            doInitialSetup();
            setProperties();
        } else {
            getProperties(deployment.getProperties());
        }
    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == selectKeystore) {
            selectKeystore();
        }
    }
    
    public void changedUpdate(DocumentEvent e) {
        setProperties();
        signedOutputFilename.setText(getSignedFilename());
    }

    public void clear() {
        keystorePass.setText("");
        alias.setText("");
        keyPass.setText("");
        deployment.getProperties().set(Data.SIGNING_KEYSTORE_PASS,"");
        deployment.getProperties().set(Data.SIGNING_ALIAS,"");
        deployment.getProperties().set(Data.SIGNING_KEY_PASS,"");
    }
    
    public void disableComponent() {
        active.setEnabled(false);
        setEnabled(false);
    }
     
    public void doInitialSetup() {
        active.setSelected(false);
        setEnabled(false);
        signedJarPrefix.setText("signed-");
        tsa.setSelectedIndex(0);
        keystore.setText("keystore_private");
        keystorePass.setText("");
        showPasses.setSelected(true);
        alias.setText("");
        keyPass.setText("");
        signedOutputFilename.setText(getSignedFilename());
    }
    
    public void enableComponent() {
        active.setEnabled(true);
        setEnabled(active.isSelected());
    }
    
    public void filenameUpdated() {
        signedOutputFilename.setText(getSignedFilename());
        //if (signedOutputFilename.getText().endsWith(".jar")) {
        //    enableComponent();
        //} else {
        //    disable();
        // }
    }
    
    public char[] getKeyPassword() { return keyPass.getPassword(); }
    
    public char[] getPassword() { return keystorePass.getPassword(); }
    
    public void getProperties(Properties properties) {
        Boolean sign = false;
        sign = properties.getBoolean(Data.SIGNING_ACTIVE);
        if (sign == null) active.setSelected(false);
        else active.setSelected(sign);
        signedJarPrefix.setText(properties.get(Data.SIGNING_PREFIX));
        tsa.setSelectedItem(properties.get(Data.SIGNING_TSA));
        keystore.setText(properties.get(Data.SIGNING_KEYSTORE));
        keystorePass.setText(properties.get(Data.SIGNING_KEYSTORE_PASS));
        Boolean _showPasses = properties.getBoolean(Data.SIGNING_SHOW_PASS);
        if (_showPasses == null) showPasses.setSelected(false);
        else showPasses.setSelected(_showPasses);
        alias.setText(properties.get(Data.SIGNING_ALIAS));
        keyPass.setText(properties.get(Data.SIGNING_KEY_PASS));
        signedOutputFilename.setText(getSignedFilename());
        setEchoChar();
    }
    
    public String getSignedFilename() {
        return signedJarPrefix.getText() + deployment.getOutput().getCurrentFilename();
    }
    
    public void insertUpdate(DocumentEvent e) {
        setProperties();
        signedOutputFilename.setText(getSignedFilename());
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == active) {
            deployment.getProperties().set(Data.SIGNING_ACTIVE,active.isSelected());
            setEnabled(active.isSelected());
        } else if (e.getSource() == showPasses) {
            setEchoChar();
            deployment.getProperties().set(Data.SIGNING_SHOW_PASS,showPasses.isSelected());
        } else if (e.getSource() == tsa) {
            deployment.getProperties().set(Data.SIGNING_TSA,(String)tsa.getSelectedItem());
        }
    }
    
    
    public void paint(Graphics g) {
        if (!setup) {
            setupGUI();
            tsa.setSelectedItem(deployment.getProperties().get(Data.SIGNING_TSA));
            Boolean _doSign = deployment.getProperties().getBoolean(Data.SIGNING_ACTIVE);
            if (_doSign == null) setEnabled(false);
            else setEnabled(_doSign);
            setup = true;
        }
        super.paint(g);
        JLabel label = new JLabel();
        g.setFont(label.getFont());
        //g.drawString(active.getText(),20,g.getFont().getSize() + 5);

        int advance = //g.getFontMetrics().stringWidth(active.getText()) +
                active.getWidth();
        int x1 = 5;
        int y1 = g.getFont().getSize();
        int x2a = 20 + advance + 10;
        int x2 = getSize().width - 10;
        int x3 = 5;
        int y3 = getSize().height - 10;
        int x4 = getSize().width - 10;
        //g = panel.getGraphics();
        g.setColor(TColor.GREY);
        g.drawLine(x1,y1,x1 + 5,y1);
        g.drawLine(x2a,y1,x2,y1);
        g.drawLine(x1,y1,x3,y3);
        g.drawLine(x2,y1,x4,y3);
        g.drawLine(x3,y3,x4,y3);
        g.setColor(TColor.GREY);
        g.drawLine(x1 + 1,y1+1,x1 + 5,y1+1);
        g.drawLine(x2a,y1+1,x2 - 1,y1+1);
        g.drawLine(x1+1,y1 + 1,x1+1,y3 - 1);
        g.drawLine(x2+1,y1,x4+1,y3);
        g.drawLine(x3,y3+1,x4 + 1,y3+1);
    }

    public void removeUpdate(DocumentEvent e) {
        setProperties();
        signedOutputFilename.setText(getSignedFilename());
    }

    public void secure() {
        keystorePass.setText("");
        alias.setText("");
        keyPass.setText("");
    }
    
    public void selectKeystore() {
        JFileChooser chooser = new JFileChooser(); 
        File[] roots = File.listRoots();
        if (File.separator.equals("\\")) chooser.setCurrentDirectory(roots[0]);
        else chooser.setCurrentDirectory(new File("/"));
        chooser.setDialogTitle("Select A Keystore");
        chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        chooser.setAcceptAllFileFilterUsed(false);
        int retVal = chooser.showOpenDialog(deployment.getTFrame());
        if (retVal == JFileChooser.APPROVE_OPTION) { 
            String path = chooser.getSelectedFile().toString();
            if (path != null) {
                keystore.setText(path);
                deployment.getProperties().set(Data.SIGNING_KEYSTORE,path);
            }
        }
    }
    
    public void setEchoChar() {
        if (showPasses.isSelected()) {
            keystorePass.setEchoChar('\0');
            keyPass.setEchoChar('\0');
        } else {
            keystorePass.setEchoChar(echoChar);
            keyPass.setEchoChar(echoChar);
        }
    }
    
    public void setEnabled(boolean state) {
        signedJarPrefixLabel.setEnabled(state);
        signedJarPrefix.setEnabled(state);
        outputFilenameLabel.setEnabled(state);
        signedOutputFilename.setEnabled(state);
        timestampAuthorityLabel.setEnabled(state);
        tsa.setEnabled(state);
        keystoreLabel.setEnabled(state);
        keystore.setEnabled(state);
        selectKeystore.setEnabled(state);
        keystorePassLabel.setEnabled(state);
        keystorePass.setEnabled(state);
        showPasses.setEnabled(state);
        aliasLabel.setEnabled(state);
        alias.setEnabled(state);
        keyPassLabel.setEnabled(state);
        keyPass.setEnabled(state);
        
        setEchoChar();
    }
    
    public void setProperties() {
        Properties properties = deployment.getProperties();
        properties.set(Data.SIGNING_ACTIVE,active.isSelected());
        properties.set(Data.SIGNING_PREFIX,signedJarPrefix.getText());
        properties.set(Data.SIGNING_TSA,(String)tsa.getSelectedItem());
        properties.set(Data.SIGNING_KEYSTORE,keystore.getText());
        properties.set(Data.SIGNING_KEYSTORE_PASS,keystorePass.getText());
        properties.set(Data.SIGNING_ALIAS,alias.getText());
        properties.set(Data.SIGNING_SHOW_PASS,showPasses.isSelected());
        properties.set(Data.SIGNING_KEY_PASS,keyPass.getText());
    }

    public void setupGUI() {
        GridBagConstraints gbc = new GridBagConstraints();
        setLayout(new GridBagLayout());
        
        active.addItemListener(this);
        signedOutputFilename.setEditable(false);
                
        JPanel panel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0; gbc.gridy = 0;
        gbc.gridwidth = 2;gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.NONE;
        gbc.anchor = GridBagConstraints.LINE_START;
        panel.add(signedJarPrefixLabel,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 2; gbc.gridy = 0;
        gbc.gridwidth = 1;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 3;gbc.gridy = 0;
        gbc.gridwidth = 7;gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.anchor = GridBagConstraints.CENTER;
        gbc.weightx = 1.0;
        panel.add(signedJarPrefix,gbc);
        signedJarPrefix.getDocument().addDocumentListener(this);
       


        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        


        gbc = new GridBagConstraints();
        gbc.gridx = 0;gbc.gridy = 2;
        gbc.gridwidth = 2; gbc.gridheight = 1;
        gbc.anchor = GridBagConstraints.LINE_START;
        panel.add(outputFilenameLabel,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 2; gbc.gridy = 2;
        gbc.gridwidth = 1;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 3;gbc.gridy = 2;
        gbc.gridwidth = 7; gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.anchor = GridBagConstraints.CENTER;
        panel.add(signedOutputFilename,gbc);
        signedOutputFilename.setEditable(false);
        



        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        



        gbc = new GridBagConstraints();
        gbc.gridx = 0;gbc.gridy = 4;
        gbc.gridwidth = 2;gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.anchor = GridBagConstraints.LINE_START;
        panel.add(timestampAuthorityLabel,gbc);

        gbc = new GridBagConstraints();
        gbc.gridx = 2; gbc.gridy = 4;
        gbc.gridwidth = 1;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 3;gbc.gridy = 4;
        gbc.gridwidth = 7;gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.anchor = GridBagConstraints.LINE_START;
        panel.add(tsa,gbc);
        tsa.addItemListener(this);
        


        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        



        gbc = new GridBagConstraints();
        gbc.gridx = 0;gbc.gridy = 6;
        gbc.gridwidth = 2;gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.NONE;
        gbc.anchor = GridBagConstraints.LINE_START;
        panel.add(keystoreLabel,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 2; gbc.gridy = 6;
        gbc.gridwidth = 1;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 3;gbc.gridy = 6;
        gbc.gridwidth = 7;gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panel.add(keystore,gbc);
        keystore.getDocument().addDocumentListener(this);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 10;gbc.gridy = 6;
        gbc.gridwidth = 1;gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panel.add(selectKeystore,gbc);
        selectKeystore.addActionListener(this);
        


        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);


        
        gbc = new GridBagConstraints();
        gbc.gridx = 0;gbc.gridy = 8;
        gbc.gridwidth = 2;gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.NONE;
        gbc.anchor = GridBagConstraints.LINE_START;
        panel.add(keystorePassLabel,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 2; gbc.gridy = 8;
        gbc.gridwidth = 1;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 3;gbc.gridy = 8;
        gbc.gridwidth = 7;gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.weightx = 1.0;
        panel.add(keystorePass,gbc);
        keystorePass.getDocument().addDocumentListener(this);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 10;gbc.gridy = 8;
        gbc.gridwidth = 1;gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.NONE;
        panel.add(showPasses,gbc);
        showPasses.addItemListener(this);
        


        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 9;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        
        

        
        gbc = new GridBagConstraints();
        gbc.gridx = 0;gbc.gridy = 10;
        gbc.gridwidth = 2;gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.NONE;
        gbc.anchor = GridBagConstraints.LINE_START;
        panel.add(aliasLabel,gbc);

        gbc = new GridBagConstraints();
        gbc.gridx = 2; gbc.gridy = 10;
        gbc.gridwidth = 1;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 3;gbc.gridy = 10;
        gbc.gridwidth = 2;gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.anchor = GridBagConstraints.LINE_START;
        gbc.weightx = 1.0;
        panel.add(alias,gbc);
        alias.getDocument().addDocumentListener(this);
        
        
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 11;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        


        gbc = new GridBagConstraints();
        gbc.gridx = 0;gbc.gridy = 12;
        gbc.gridwidth = 2;gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.NONE;
        gbc.anchor = GridBagConstraints.LINE_START;
        panel.add(keyPassLabel,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 2; gbc.gridy = 12;
        gbc.gridwidth = 1;
        panel.add(new SizedPanel(10,10,getBackground()),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 3;gbc.gridy = 12;
        gbc.gridwidth = 7;gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.weightx = 1.0;
        panel.add(keyPass,gbc);
        keyPass.getDocument().addDocumentListener(this);


        // layout the main panel
        gbc = new GridBagConstraints();
        gbc.gridx = 0; gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.fill = GridBagConstraints.NONE;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0,20,0,0);
        add(active,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 0; gbc.gridy = 1;
        gbc.fill = GridBagConstraints.BOTH;
        gbc.insets = new Insets(0,20,20,20);
        gbc.ipadx = 5; gbc.ipady = 5;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        add(panel,gbc);
    }
}
