package ca.tecreations.components;

import ca.tecreations.TColor;
import ca.tecreations.Platform;
import static ca.tecreations.components.ProgressDialog.INSTANCE;
import ca.tecreations.components.event.*;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Graphics;

import javax.swing.*;
/**
 *
 * @author Tim
 * 
 */
public class JobProgressDialog extends JDialog {
    public static final String SN = JobProgressDialog.class.getSimpleName();
    public static JobProgressDialog INSTANCE = new JobProgressDialog(new JFrame());

    JLabel jobLabel = new JLabel("Copying...");
    ProgressBar jobProgress = new ProgressBar(ProgressBar.getDefaultSize());
    SizedPanel spacer = new SizedPanel(1,1);
    JLabel itemLabel = new JLabel("");
    ProgressBar itemProgress = new ProgressBar(ProgressBar.getDefaultSize());
    
    public JobProgressDialog(JFrame frame) {
        super(frame);
        setLayout(new GridLayout(5,1));
        add(jobLabel);
        add(jobProgress);
        add(spacer);
        spacer.setBackground(TColor.DEFAULT_SWING_BG);
        add(itemLabel);
        add(itemProgress);
        validate();
        pack();
        setLocationRelativeTo(frame);
        setResizable(false);
    }
    
    public ProgressBar getItemProgressBar() { return jobProgress; }
    
    public ProgressBar getJobProgressBar() { return jobProgress; }
    
    public static void main(String[] args) {
        INSTANCE.setVisible(true);
        //INSTANCE.toFront();

        for(int i = 0; i <= 100;i++) {
            INSTANCE.setTitle("JPD: Progress: " + i + "%");
            INSTANCE.setJob("Iterating");
            INSTANCE.setJobPercent(i);
            INSTANCE.setItem("Index: " + i);
            INSTANCE.setItemPercent(i);
            try { new Thread().sleep(50); } catch (InterruptedException ie) {}
        }

        try { new Thread().sleep(500); } catch (InterruptedException ie) {}
        INSTANCE.setVisible(false);
        System.exit(0);
    }
    
    public void paint(Graphics g) {
        System.out.println("Paint-----------------------------------");
        super.paint(g);
        jobProgress.repaint();
        itemProgress.repaint();
    }

    public void paintComponent(Graphics g) {
        System.out.println("PaintComponent--------------------------");
        super.paint(g);
        jobProgress.repaint();
        itemProgress.repaint();
    }

    public void setItem(String label) {
        itemLabel.setText(label);
    }
    
    public void setItemPercent(int percent) {
        itemProgress.setPercent(percent);
        itemProgress.paint(itemProgress.getGraphics());
    }

    public void setJob(String label) {
        jobLabel.setText(label);
    }
    
    public void setJobPercent(int percent) {
        jobProgress.setPercent(percent);
        jobProgress.paint(jobProgress.getGraphics());
    }

    public void setOutline(boolean state) {
        jobProgress.setOutline(state);
        itemProgress.setOutline(state);
    }
    
    public void setOutlineColor(Color color) {
        jobProgress.setOutlineColor(color);
        itemProgress.setOutlineColor(color);
    }
}
