package ca.tecreations.apps.filetool;

import ca.tecreations.Drag;
import ca.tecreations.File;
import ca.tecreations.ImageTool;
import ca.tecreations.Mouse;
import ca.tecreations.Platform;
import ca.tecreations.Point;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.Timer;
import ca.tecreations.components.TFrame;
import ca.tecreations.net.Client;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.BufferedImage;

import javax.swing.*;
/**
 *
 * @author Tim
 */
public class RemoteControl extends TFrame implements ActionListener, 
        MouseListener, MouseMotionListener, MouseWheelListener 
{
    public static ScreenRefresher screenRefresher;
    public static RemoteControl instance;
    Client client;
    JScrollPane scroller;
    EventsPanel eventsPanel;
    String screenshotPath;
    
    Point eventOrigin;
    
    MouseEvent lastClickEvent;
    boolean mouseUp = true;
    int clickCount;
    Timer clickTimer = null;
    
    Point mouseLocation = new Point(-1,-1);
    
    boolean dragged = false;
    Mouse down = null;
    Mouse up = null;

    Point previousLoc;

    public static boolean debug = true;
    
    public RemoteControl(Client client, TFrame parent) {
        super(new Properties(ProjectPath.INSTANCE.getPropertiesPath() + "RemoteControl.properties"),"RemoteControl");
        this.client = client;
        screenshotPath = client.getClientScreenshotPath();
        eventsPanel  = new EventsPanel(this,ImageTool.getImage(new File(screenshotPath)));
        setLayout(new BorderLayout());
        scroller = new JScrollPane(eventsPanel,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        scroller.getVerticalScrollBar().setUnitIncrement(16);
        scroller.getHorizontalScrollBar().setUnitIncrement(16);
        add(scroller,BorderLayout.CENTER);
        eventsPanel.addMouseListener(this);
        eventsPanel.addMouseMotionListener(this);
        eventsPanel.addMouseWheelListener(this);
        if (getProperties().wasCreated()) {
            setLocationRelativeTo(parent);
        }
        screenRefresher = new ScreenRefresher(this,client);
    }

    public void actionPerformed(ActionEvent e) {
        if (dragged) {
            if (!mouseUp) {
                // still dragging, recreate timer and check when done
                clickTimer = new Timer(375,this);
                clickTimer.start();
            } else {
                // mouseUP, so drag finished
                if (clickTimer != null) {
                    clickTimer.stop();
                    clickTimer = null;
                }
                Drag drag = null;
                drag = new Drag(down,up);
                client.sendMouseDrag(drag);
                down = null;
                up = null;
                dragged = false;
                Platform.sleep(500); // wait for the server to operate
                new RefreshThread(this,client);
            }
        } else {
            if (!mouseUp) {
                // this is in-between a click and the timer, when the mouse hasn't
                // moved, in otherwords, a hold, so we'll just start the timer again,
                // except sooner than before
                clickTimer = new Timer(this,250);
                clickTimer.start();
            } else {
                // mouse is up, so just a click within the 375 millisecond range,
                // unless previously restarted...
                if (clickTimer != null) {
                    clickTimer.stop();
                    clickTimer = null;
                }
                if (up != null) {
                    client.sendMouseUp(up);
                    down = null;
                    up = null;
                    new RefreshThread(this,client);
                }
            }
        }
    }
    
    @Override
    public void close() {
        screenRefresher.stopRunning();
        super.close();
    }
    
    public void createAndShowGUI(final Client client, final TFrame parent) {
        SwingUtilities.invokeLater(() -> {
            instance = new RemoteControl(client, parent);
            instance.setVisible(true);
        });
    }
    
    public void doPainting(java.awt.Graphics g, int x, int y) {
        Color oldColor =g.getColor();
        g.setColor(Color.red);
        for(int i = x-3;i < x + 3;i++) {
            for(int j = y - 3; j < y + 3;j++) {
                g.drawLine(i,j,i,j);
            }
        }
        g.setColor(oldColor);
    }
    
    public boolean getDebug() { return debug; }
    
    public EventsPanel getEventsPanel() { return eventsPanel; }
    
    public Point getMouseLocation() { return mouseLocation; }
    
    public void launch(final Client client, final TFrame parent) {
        createAndShowGUI(client, parent);
    }

    public static void main(String[] args) {
        FileTool.launch();
    }
    
    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        mouseLocation = new Point(e.getX(),e.getY());
        dragged = true;
        repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        mouseLocation = new Point(e.getX(),e.getY());
        repaint();
        screenRefresher.restart();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        mouseLocation = new Point(e.getX(),e.getY());
        repaint();
        screenRefresher.stopRunning();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        mouseLocation = new Point(e.getX(),e.getY());
        repaint();
    }
    
    @Override
    public void mousePressed(MouseEvent e) {
        lastClickEvent = e;
        mouseUp = false;
        if (down == null) down = new Mouse(e,true);
        client.sendMouseDown(down);
        if (clickTimer == null) {
            clickTimer = new Timer(this,375);
            clickTimer.start();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        up = new Mouse(e,false);
        lastClickEvent = e;
        mouseUp = true;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int notches = e.getWheelRotation();
        boolean alt = e.isAltDown();
        boolean ctrl = e.isControlDown();
        boolean shift = e.isShiftDown();
        boolean set = false;
        JScrollBar h = scroller.getHorizontalScrollBar();
        JScrollBar v = scroller.getVerticalScrollBar();
        int hInc = h.getUnitIncrement();
        int vInc = v.getUnitIncrement();
        int hVal = h.getValue();
        int vVal = v.getValue();
        if (notches > 0) {
            if (alt) {
                if (ctrl) {
                    h.setValue(hVal + (hInc * 10));
                } else {
                    h.setValue(hVal + hInc);
                }
            } else {
                if (ctrl) {
                    v.setValue(vVal + (vInc * 10));
                } else {
                    v.setValue(vVal + vInc);
                }
            }
        } else {
            if (alt) {
                if (ctrl) {
                    h.setValue(hVal - (hInc * 10));
                } else {
                    h.setValue(hVal - hInc);
                }
            } else {
                if (ctrl) {
                    v.setValue(vVal - (vInc * 10));
                } else {
                    v.setValue(vVal - hInc);
                }
            }
        }
    }

//    public void paint(Graphics g) {
//System.out.println("RemoteControl.paintComponent()");        
//    }
    
    public void paintComponent(Graphics g) {
//System.out.println("RemoteControl.paintComponent()");        
        super.paintComponents(g);
        int x = mouseLocation.x;
        int y = mouseLocation.y;
        doPainting(g,x,y);
    }
    
    
    public void setImage(BufferedImage img) {
        eventsPanel.setImage(img);
        repaint(); 
    }
    
}
