package ca.tecreations.apps;

import ca.tecreations.TColor;
import ca.tecreations.File;
import ca.tecreations.ImageTool;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.SystemTool;
import ca.tecreations.TecData;
import ca.tecreations.components.OptionsDialog;
import ca.tecreations.apps.javacompiler.JavaCompiler;
import ca.tecreations.apps.javacompiler.JavaCompiler_Shutdown;
import ca.tecreations.apps.javacompiler.JavaCompiler_Spawn;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.components.TFrame;
import ca.tecreations.components.YesNoDialog;
import ca.tecreations.components.event.ProgressListener;
import ca.tecreations.lang.java.GetClassPathFor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;
import javax.swing.*;

/**
 *
 * @author tim
 */
public class Validator extends TFrame implements ProgressListener, Runnable {

    Color PAINTER_COLOR = TColor.TEC_LIGHT_GREEN;
    
    public static Validator instance;
    SizedPanel brandPanel;
    JScrollPane scroller;
    ValidatorPanel panel;

    boolean dragged = false;
    boolean firstRun = true;

    public Validator() {
        super(ProjectPath.getTecPropsPath() + Validator.class.getSimpleName() + ".properties", Validator.class.getSimpleName());

        setupGUI();
          
        setExitOnClose(true);
    } 

    public void add(String s) {
        panel.addLine(s, PAINTER_COLOR); 
        repaint();
    }
 
    public void addItem(String s) {
        add(s);
    }

    public void addJob(String s) {  
        add(s);
    }
 
    public void addRed(String s) {
        panel.addLine(s, TColor.RED);
        repaint();
    }

    public static void createAndShowGUI() {
        instance = new Validator();
        instance.setVisible(true);
        if (instance.getProperties().wasCreated()) instance.setLocationRelativeTo(null);
    }

    public JScrollPane getScroller() {
        return scroller;
    }

    public static void launch() {
        SwingUtilities.invokeLater(() -> {
            createAndShowGUI();
        });
        while (instance == null) {
            Platform.sleep(250);
        }
        instance.debug = false;
        instance.start();
    }

    public void launchFromClassPath() {
        String cmd = "java -cp " + new GetClassPathFor(ProjectPath.getProjectPath()).getResult();
        cmd += " ca.tecreations.apps.launcher.Launcher";
        new SystemTool().spawn(cmd, true);
    }

    public void launchFromJar() {
        String jarPath = ProjectPath.getDownloadsPath() + TecData.TEC_VERSION + ".jar";
        String cmd = "java -cp " + new GetClassPathFor(jarPath).getResult();
        cmd += " ca.tecreations.apps.launcher.Launcher";
        new SystemTool().spawn(cmd, true);
    }

    public static void main(String[] args) {
        //new File(ProjectPath.getDownloadsPath() + TecData.TEC_VERSION + "_jars.jar").delete(true);
        //new File(ProjectPath.getTecreationsPath() + "images" + File.separator + "tec_brand.png").delete(true);
        launch();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (firstRun) {
            JScrollBar hsb = scroller.getHorizontalScrollBar();
            JScrollBar vsb = scroller.getHorizontalScrollBar();
            hsb.setUnitIncrement(hsb.getSize().width);
            vsb.setUnitIncrement(vsb.getSize().height / 10);
            firstRun = false;
        }
    }

    public void run() {
        boolean unpack = false;
        boolean unpackLocalJars = false;
        boolean launchFromClassPath = false;
        // check if dependencies exist or if they have changed
        String jarsJarPath = ProjectPath.getDownloadsPath() + TecData.TEC_VERSION + "_jars.jar";
        if (!new File(jarsJarPath).exists()) {
            // starting from nothing, download jars, do local security config
            add(TecData.TEC_VERSION + "_jars.jar does not exist. Downloading...");
            new DownloadCurrentJars(TecData.TEC_VERSION, this);
            unpack = true;
        } else if (Online.isNewerJar(TecData.TEC_VERSION + "_jars",this)) {
            add("Online dependencies are newer. Downloading: " + TecData.TEC_VERSION + "_jars.jar");
            new DownloadCurrentJars(TecData.TEC_VERSION, this);
            new File(ProjectPath.getTecreationsPath() + "jars" + File.separator + TecData.TEC_VERSION).empty();
            unpack = true;
        }
        // check each and every time!
        // into: <user.home>/tecreations/jars/TEC_VERSION/jars/
        new UnpackIfDifferent(jarsJarPath,ProjectPath.getTecJarsPath(TecData.TEC_VERSION),this,debug); 

        String prjsHome = "";
        String ppPropsPath = ProjectPath.getTecPropsPath() + "ProjectPath.properties";
        Properties ppProps = new Properties(ppPropsPath);
        if (ppProps.wasCreated()) {
            List<String> labels = new ArrayList<>();
            labels.add("ProjectPath.PROJECTS_HOME needs to be configured.");
            labels.add("This is where we keep our projects.");
            labels.add(" ");
            labels.add("The data is accessed via ProjectPath.getProjectsHome().");
            labels.add("The data is stored in: " + ProjectPath.getTecPropsPath() + "ProjectPath.properties");
            Platform.multiLineMessage(this,labels);
            prjsHome = Platform.requestDirectory(this,Platform.getRoot(),"Select a Directory for PROJECTS_HOME...");
            while (prjsHome == null || prjsHome.equals("")) {
                prjsHome = Platform.requestDirectory(this,Platform.getRoot(),"Select a Directory for PROJECTS_HOME...");
            }
            if (!new File(prjsHome).exists()) {
                new File(prjsHome).mkdirs();
            }
            ppProps.set("PROJECTS_HOME",prjsHome);
            ProjectPath.PROJECTS_HOME = prjsHome;
            launchFromClassPath = true;
            unpackLocalJars = true;
        } else {
            prjsHome = ppProps.get("PROJECTS_HOME");
            if (Online.isNewerJar(TecData.TEC_VERSION,this)) {
                boolean download = false;
                boolean empty = false;
                unpack = false;
                List<String> options = new ArrayList<>();
                options.add("Nothing");
                options.add("Download Only");
                options.add("Download and Unpack");
                options.add("Download, Empty, and Unpack");
                List<String> msgs = new ArrayList<>();
                msgs.add("TEC_VERSION {" + TecData.TEC_VERSION + "} jar is newer...");
                msgs.add("What would you like to do?");
                OptionsDialog dialog = new OptionsDialog(this,"Online TEC_VERSION is newer!",msgs,options);
                if (dialog.getChoice().indexOf("Download") != -1) download = true;
                if (dialog.getChoice().indexOf("Empty") != -1) empty = true;
                if (dialog.getChoice().indexOf("Unpack") != -1) unpack = true;
                if (download || empty || unpack) {
                    Online.downloadTecJar(this);
                }
                if (empty | unpack) File.prune(prjsHome + TecData.TEC_VERSION + File.separator + "ca" + File.separator +
                        "tecreations" + File.separator,true);
                if (unpack) new UnpackTecVersion(prjsHome + TecData.TEC_VERSION + File.separator,this,true, false);
                // set PROJECTS_HOME for TecData and JavaCompiler
                
            }
        }
        if (unpackLocalJars) {
            // unpack to tecreations/jars/TEC_VERSION/jars
            String prjJarsPath = prjsHome + TecData.TEC_VERSION + File.separator + "jars" + File.separator;
            new UnpackIfDifferent(jarsJarPath,prjJarsPath,this,debug); 
        }

        add("PROJECTS_HOME: " + prjsHome + " : exists.");
        
        // check for JavaCompiler
        if (!JavaCompiler.getLockFile().exists()) {
            YesNoDialog dialog = new YesNoDialog(this,"Start JavaCompiler?","JavaCompiler is not running. Would you like to start it?");
            dialog.setVisible(true);
            if (dialog.isYes()) {
                JavaCompiler_Spawn.launch();
                add("Executed: SpawnJavaComiler.launch();");
                add("Checking in 3...");
                Platform.sleep(1000); 
                setLastLine("Checking in 2...");
                Platform.sleep(1000);
                setLastLine("Checking in 1...");
                Platform.sleep(1000);
            }
        } else {
            add("JavaCompiler is already running.");

            // see above 
            add("Attempting to re-cycle.");
            JavaCompiler_Shutdown.launch();
            add("Waiting 3...");
            Platform.sleep(1000);
            setLastLine("Waiting 2...");
            Platform.sleep(1000);
            setLastLine("Waiting 1...");
            Platform.sleep(1000);
            
            add("Restarting in 3...");
            Platform.sleep(1000);
            setLastLine("Restarting in 2...");
            Platform.sleep(1000);
            setLastLine("Restarting in 1...");
            Platform.sleep(1000);
            JavaCompiler_Spawn.launch();
            add("Executed: SpawnJavaCompiler.launch();");
            add("Checking in 3...");
            Platform.sleep(1000);
            setLastLine("Checking in 2...");
            Platform.sleep(1000);
            setLastLine("Checking in 1...");
            Platform.sleep(1000);
            addRed("Running: " + JavaCompiler.getProperties().get(JavaCompiler.RUNNING) + " : LockFile: Exists: " + JavaCompiler.getLockFile().exists());

        } 

        if (!new File(ProjectPath.getTecreationsPath() + "security").exists()) {
            add("Creating local key/trust stores...");
            MakeLocalStorePairs.relaunch();
            add("Making configuration for local TLS security...");
            new MakeLocalSecurityConfiguration();
        } else {
            add("Security configuration was detected as present.");
        }

        add("Launching in 5...");
        Platform.sleep(1000);
        setLastLine("Launching in 4...");
        Platform.sleep(1000);
        setLastLine("Launching in 3...");
        Platform.sleep(1000);
        setLastLine("Launching in 2...");
        Platform.sleep(1000);
        setLastLine("Launching in 1...");
        Platform.sleep(1000);
        if (!debug) {
            if (launchFromClassPath) launchFromClassPath();
            else launchFromJar();
        }
        System.exit(0);
    }

    public void setItem(String s) {
        add(s);
    }

    public void setJob(String s) {
        add(s);
    }

    public void setLastLine(String s) {
        panel.setLastLine(s, PAINTER_COLOR);
        repaint();
    }
    
    public void setupGUI() {
        setLayout(new BorderLayout());
        brandPanel = new SizedPanel(TecData.TEC_BRAND.getWidth(), TecData.TEC_BRAND.getHeight());
        brandPanel.setImage(TecData.TEC_BRAND);
        add(brandPanel, BorderLayout.NORTH);
        this.panel = new ValidatorPanel();
        scroller = new JScrollPane(panel, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        panel.setScroller(scroller);
        add(scroller, BorderLayout.CENTER);
        validate();
//        panel.addMouseWheelListener(this);
        addComponentListener(this);

        scroller.getVerticalScrollBar().setUnitIncrement(16);
        scroller.getHorizontalScrollBar().setUnitIncrement(16);
        brandPanel.setBackground(ImageTool.getTColor(TecData.TEC_BRAND, 3, 3));
    }

    public void start() {
        run();
    }

    public void update(String s, int job, int item) {
        add(s);
        add("Downloaded: " + job + "% -- " + item + "%");
    }
    
    public void update(int job, int item) {
        setLastLine("Downloaded: " + job + "% -- " + item + "%");
    }

    public void updateItem(int item) {
        setLastLine("Downloaded: " + item + "%");
    }

    public void updateJob(int job) {
        setLastLine("Downloaded: " + job + "%");
    }

}
