package ca.tecreations.apps.filetool;

import ca.tecreations.Platform;
import ca.tecreations.Point;
import ca.tecreations.net.Client;

import java.awt.*;
/**
 *
 * @author Tim
 */
public class ScreenRefresher extends Thread {
    RemoteControl remote;
    Client client;
    boolean running;
    Point mouseLoc;
    
    public ScreenRefresher(RemoteControl rc, Client client) {
        this.remote = rc;
        this.client = client;
    }
    
    public boolean isRunning() { return running; }
    
    public void restart() {
        if (!running) {
            running = true;
            start();
        }
    }
    
    public void run() {
        while (running) {
            Platform.sleep(1000); // refresh any changes every second
            mouseLoc = remote.getMouseLocation();
            client.sendMouseMove(mouseLoc);
            Platform.sleep(125); // for example, like when on ShineFm, the volume
                                       // slider gets shown, so give it a few moments
                                       // to update the gui and then
                                       // capture/retrieve/repaint
            new RefreshThread(remote,client);
        }
    }
    
    public void stopRunning() { running = false; }
}
