package ca.tecreations.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

/**
 *
 * @author tim
 */ 
public abstract class DB {
    protected Connection conn = null;
    protected Statement stmt = null;
    public boolean debug = true;
    protected SQLException sqlException = null;
    protected int affected = -999; 
    
    protected String host = "";
    protected String user = "";
    protected char[] pass = null;
    protected String dbName = "";
    
    public abstract Connection attemptOpen();
    
    public abstract void closeConnection();
    public abstract void closeStatement();
    public abstract void closeResultSet();
    
    public int getAffected() { return affected; }
    
    public Connection getConnection() { return conn; }
    
    public SQLException getSQLException() { return sqlException; }
    
    public abstract List<List<String>> getRows(String sql,boolean withHeader, boolean debug);
    public abstract void issue(String sql, boolean debug);
    public abstract ResultSet query(String sql,boolean debug);

    public abstract void makeTableFromSQL(String filename);
    public abstract void makeTableFromSQL(String filename,boolean debug);

    public abstract void parseAndExecute(String filename,boolean debug);
    
    public void setConnection(Connection c) {
        conn = c;
    };
    
      
    public String getDatabaseName() { return dbName; }
    
    public String getHostName() { return host; }
    
    public void clearPassword() { for(int i = 0; i < pass.length;i++) pass[i] = '\0'; }
    public char[] getPassword() { return pass; }
    
    public String getUserName() { return user; }
    
    public abstract String getProvider();
    
    class DataContainer {
    }
}
 