package ca.tecreations.components;

import ca.tecreations.TColor;
import ca.tecreations.components.event.*;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;

import javax.swing.*;
/**
 *
 * @author Tim
 * 
 */
public class ProgressDialog extends JDialog {
    public static ProgressDialog INSTANCE = new ProgressDialog(new JFrame());
    ProgressBar progress = new ProgressBar(ProgressBar.getDefaultSize());
    
    public ProgressDialog(JFrame frame) {
        super(frame);
        setLayout(new BorderLayout(0,0));
        add(progress,BorderLayout.CENTER);
        validate();
        pack();
        setLocationRelativeTo(frame);
        setResizable(false);
    }
    
    public ProgressBar getProgressBar() { return progress; }
    
    public static void main(String[] args) {
        INSTANCE.setVisible(true);
        //INSTANCE.toFront();
        for(int i = 0; i <= 100;i++) {
            INSTANCE.setTitle("PD: Progress: " + i + " %");
            INSTANCE.setPercent(i);
            try { new Thread().sleep(50); } catch (InterruptedException ie) {}
        }
        
        try { new Thread().sleep(500); } catch (InterruptedException ie) {}
        INSTANCE.setVisible(false);
        System.exit(0);
    }
    
    public void setOutline(boolean state) {
        progress.setOutline(state);
    }
    
    public void setOutlineColor(Color color) {
        progress.setOutlineColor(new TColor(color));
    }

    public void setPercent(int percent) {
        progress.setPercent(percent);
        progress.repaint();
        //progress.paint(progress.getGraphics());
    }

}
