package ca.tecreations.components;

import ca.tecreations.TColor;
import ca.tecreations.Platform;
import ca.tecreations.components.event.*;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Graphics;

import javax.swing.*;
/**
 *
 * @author Tim
 * 
 */
public class JobProgressDialog extends JDialog implements ProgressListener {
    public static final String SN = JobProgressDialog.class.getSimpleName();
    JLabel jobLabel = new JLabel("Copying...");
    ProgressBar jobProgress = new ProgressBar(ProgressBar.getDefaultSize());
    SizedPanel spacer = new SizedPanel(1,1);
    JLabel itemLabel = new JLabel("");
    ProgressBar itemProgress = new ProgressBar(ProgressBar.getDefaultSize());
    
    public JobProgressDialog(JFrame app) {
        super(app);
        setLayout(new GridLayout(5,1));
        add(jobLabel);
        add(jobProgress);
        add(spacer);
        spacer.setBackground(TColor.DEFAULT_SWING_BG);
        add(itemLabel);
        add(itemProgress);
        validate();
        pack();
        setLocationRelativeTo(app);
        setResizable(false);
    }
    
    public void addItem(String s) {
    }
    
    public ProgressBar getItemProgressBar() { return jobProgress; }
    
    public ProgressBar getJobProgressBar() { return jobProgress; }
    
    public static void main(String[] args) {
        JFrame test = new JFrame();
        test.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        JobProgressDialog dialog = new JobProgressDialog(test);
        dialog.setVisible(true);
        
        for(int i = 0; i <= 100;i++) {
            dialog.setTitle("JPD: Progress: " + i + "%");
            dialog.setJob("Iterating");
            dialog.setJobPercent(i);
            dialog.setItem("Index: " + i);
            dialog.setItemPercent(i);
            try { new Thread().sleep(50); } catch (InterruptedException ie) {}
        }
        
        Platform.sleep(1000);
        dialog.setJobPercent(49);
        dialog.setItemPercent(84);
        Platform.sleep(2000);
        dialog.setVisible(false);
        test.setVisible(false);
        System.exit(0);
    }    
    
//    public void paint(Graphics g) {
//        System.out.println("Paint-----------------------------------");
//        super.paint(g);
//        jobProgress.repaint();
//        itemProgress.repaint();
//    }

    public void paintComponent(Graphics g) {
        System.out.println("PaintComponent--------------------------");
        super.paint(g);
        jobProgress.repaint();
        itemProgress.repaint();
    }

    public void setItem(String label) {
        itemLabel.setText(label);
    }
    
    public void setItemPercent(int percent) {
        itemProgress.setPercent(percent);
        repaint();
    }

    public void setJob(String label) {
        jobLabel.setText(label);
    }
    
    public void setJobPercent(int percent) {
        jobProgress.setPercent(percent);
        repaint();
    }

    public void setOutline(boolean state) {
        jobProgress.setOutline(state);
        itemProgress.setOutline(state);
    }
    
    public void setOutlineColor(Color color) {
        jobProgress.setOutlineColor(color);
        itemProgress.setOutlineColor(color);
    }

    @Override
    public void setVisible(boolean state) {
        if (state) {
            update(0,0);
        }
        super.setVisible(state);
    }
    
    public void update(String msg, int job, int item) {
        setTitle(msg);
        update(job,item);
    }

    
    public void update(int job, int item) {
        System.out.println(SN + ".update(" + job + "," + item + ")");
        setJobPercent(job);
        setItemPercent(item);
        repaint();
    }
    
    public void updateItem(int percent) {
        setItemPercent(percent);
        repaint();
    }
    
    public void updateJob(int percent) {
        setJobPercent(percent);
        repaint();
    }
}
