package ca.tecreations.wip.toy.editors;

import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.TColor;
import ca.tecreations.TecData;
import ca.tecreations.TextToken;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.text.TextPoints;
import ca.tecreations.text.TextTokenPainter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

/**
 *
 * @author Tim
 */
public class LineNumbers extends SizedPanel {
    public static final String SN = LineNumbers.class.getSimpleName();
    static Editor editor;
    TextPoints points;
    static TextTokenPainter numsPainter;
    private boolean trace = false;
    
    public LineNumbers(Editor editor) {
        super(1,1);
        this.editor = editor;
        points = editor.getPoints();
        numsPainter = new TextTokenPainter(points,new TextToken(),TColor.black);
        numsPainter.setBackground(TColor.DEFAULT_SWING_BG);
        numsPainter.setToken(new TextToken("99999"));
        setSize(numsPainter.getTextWidth(),getSize().height);
    }
    
    public int getLength(int i) {
        if (i < 10) return 1;
        if (i < 100) return 2;
        if (i < 1000) return 3;
        if (i < 10000) return 4;
        if (i < 100000) return 5;
        if (i < 1000000) return 6;
        if (i < 10000000) return 7;
        if (i < 100000000) return 8;
        if (i < 1000000000) return 9;
        return 10;
    }
    
    public int getLineNumberLength(int num) {
        if (num < 10) return 1;
        if (num < 100) return 2;
        if (num < 1000) return 3;
        if (num < 10000) return 4;
        if (num < 100000) return 5;
        if (num < 1000000) return 6;
        if (num < 10000000) return 7;
        if (num < 100000000) return 8;
        if (num < 1000000000) return 9;
        return 10;
    }

    public TextToken getPaddedToken(int i) {
        String text = getPadding(getLineNumberLength(i + 1) - getLength(i)) + (i + 1) + ": ";
        return new TextToken(text);
    }
    
    public String getPadding(int count) {
        String s = "";
        for(int i = 0; i < count;i++) s += ' ';
        return s;
    }
    
    public int getYOffset() {
        int lineHeight = numsPainter.getPoints().getFontSize();
        int absY = Math.abs(getLocation().y);
        int offset = absY - (absY - lineHeight);
        if (offset == lineHeight) return 0;
        else return offset;
    }
    
    public static void main(String[] args) {
        Properties props = new Properties(ProjectPath.getPropertiesPath() + SN + ".properties");
        CodeEdit.launch(props);
    }
    
    @Override
    public void paint(Graphics g) {
        int lineHeight = numsPainter.getPoints().getFontSize();
        if (trace) System.out.println(SN + ".paint");
        g.setColor(TColor.TEC_ORANGE);
        g.setColor(numsPainter.getBackground());
        g.fillRect(0,0,getSize().width,getSize().height);
        int linesSize = editor.getLineCount();
        TextPoints points = editor.getPoints();
        int absY = Math.abs(editor.getPanel().getLocation().y);
        int minY = absY - lineHeight;
        int maxY = absY + editor.getVSB().getSize().height + (points.getFontSize() * 2);
        int lineY = 0;
        int lineIndex = 0;
        if (minY == -lineHeight) minY = 0;
         
        int y = 0; // determine the starting Y for the line numbers
        for(int i = 0; i < linesSize; i++) {
            if (y >= minY && y <= maxY) {
                lineY = absY - y;
                i = linesSize;
            }
            y += lineHeight;
        }
        //System.out.println("lines: " + linesSize + " absY: " + absY + " lineY: " + lineY + " minY: " + minY + " maxY: " + maxY + " y: " + y);
        if (lineY > 0) lineY -= lineHeight;
        lineY += 1;
        y = 0;
        int w = getSize().width;
        for(int i = 0; i < linesSize;i++) {
            numsPainter.setText("" + (i + 1));
            if (y >= minY && y <= maxY) {
                int textWidth = numsPainter.getTextWidth();
                int lineX = ((w - textWidth) / 2);
                numsPainter.paintAt(g,lineX,lineY);
                g.setColor(TColor.green);
                g.drawLine(0,lineY,getSize().width,lineY);
                lineY += lineHeight;
                g.setColor(TColor.red);
                g.drawLine(0,lineY - 1,getSize().width,lineY - 1);
            }
            y += lineHeight;
        }
    }
}
