package ca.tecreations.wip.toy;

import ca.tecreations.interfaces.Paintable;
import ca.tecreations.ImageTool;
import ca.tecreations.Pixel;
import ca.tecreations.Point;
import ca.tecreations.ProjectPath;
import ca.tecreations.components.ImagePanel;
import ca.tecreations.components.Magnifier;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.components.TFrame;
import ca.tecreations.graphics.DrawObject;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.*;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.swing.*;
/**
 *
 * @author Tim
 */
public class MultiPanel extends JPanel implements MouseListener, MouseMotionListener {
    int spacingWidth = 16;
    int spacingHeight = 16;

    List<Paintable> elements = new ArrayList<>();
    HashMap<Integer,Component> components = new HashMap<>();
    HashMap<Integer,DrawObject> drawObjects = new HashMap<>();

    Color xColor = null;
    boolean debug = false;
    

    boolean isDrawObject = false;
    DrawObject selected = null;

    int lastX = 0;
    int lastY = 0;
    int deltaX = 0;
    int deltaY = 0;
     
    List<Paintable> added = new ArrayList<>();
    
    Color outlineColor = Color.BLUE;
    
    List<Pixel> pixels = new ArrayList<>();

    public MultiPanel() {
        super(true);
        setLayout(null);
        addMouseListener(this);
        addMouseMotionListener(this);
    }

    private void addComponent(Paintable a) {
        int index = elements.size();
        elements.add(a);
        components.put(index,(Component)a);
        add((Component)a);  
        validate();
        added.add(a);
    }
    
    private void addDrawObject(DrawObject drawObject) {
        int index = elements.size();
        elements.add(drawObject);  
        drawObjects.put(index,drawObject);
        added.add(drawObject);
    }
    
    public void addPaintable(Paintable obj) {
        if (obj instanceof DrawObject) {
            addDrawObject((DrawObject)obj);
        } else {
            addComponent(obj);
        }
        repaint();
    }

    public boolean componentHasPoint(Component c, Point p) {
        Dimension size = c.getSize();
        Point loc = new Point(c.getLocation());
        return (loc.x <= p.x &&
                (loc.x + size.width) > p.x &&
                loc.y <= p.y &&
                (loc.y + size.height) > p.y);
    }

    public DrawObject getDrawObject(int index) {
        if (index + 1 > drawObjects.size()) {
            throw new IllegalArgumentException("getDrawObject: index must be less than drawObjects.size: " + drawObjects.size());
        }
        return drawObjects.get(index);
    }
    
    public int getDX() { return -deltaX; }
    public int getDY() { return -deltaY; }
    
    public BufferedImage getOutputImage() {
        BufferedImage out = ImageTool.getNewBufferedImage(getSize());
        Graphics g = out.getGraphics();
        paint(g);
        return out;
    }
    
    public Object getSelected() { return selected; }
    
    public static void main(String[] args) {
        CodeToy.launch();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.isControlDown()) {
            new Magnifier(getOutputImage()).setVisible(true);
        }
    }
    
    public void mouseDragged(MouseEvent e) {
        java.awt.Point p = e.getLocationOnScreen();
        if (e.isControlDown()) {
            if (isDrawObject) {
                int tdx;
                int tdy;
                //if (constrainTo != VERTICAL) tdx = lastX - p.x;
                //else tdx = 0;
                tdx = lastX - p.x;
                //if (constrainTo != HORIZONTAL) tdy = lastY - p.y;
                //else tdy = 0;
                tdy = lastY - p.y;
                if (tdx == 0 && tdy == 0) return;
                deltaX = tdx;
                deltaY = tdy;
            
                int newX = 0;
                int newY = 0;
                if (deltaX > 0) newX -= Math.abs(deltaX);
                if (deltaX < 0) newX += Math.abs(deltaX);
                if (deltaY < 0) newY += Math.abs(deltaY);
                if (deltaY > 0) newY -= Math.abs(deltaY);
                selected.moveBy(newX,newY);
                repaint();
            }
        } else {
            pixels.add(new Pixel(Color.black, e.getX(),e.getY()));
            repaint();
        }
        lastX = p.x;
        lastY = p.y;
    //    repaint();
    }
    
    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {}

    public void mouseMoved(MouseEvent e) {
        java.awt.Point p = e.getLocationOnScreen();
        lastX = e.getX();
        lastY = e.getY();
    }
    
    public void mousePressed(MouseEvent e) {
        isDrawObject = false;
        selected = null;
        if (e.isControlDown()) {
            Point locInComp = new Point(e.getX(),e.getY());
            //System.out.println("LocInComp: " + e.getX() + "," + e.getY());
            for(int i = 0; i < drawObjects.size();i++) {
                //System.out.println("DrawObject[" + i + "]: " + drawObjects.get(i).getName());
                DrawObject obj = (DrawObject) drawObjects.get(i);
                if (obj != null) {
                    if (obj.hasPoint(locInComp)) {
                        isDrawObject = true;
                        selected = obj;
                        break;
                    }
                }
            }
        } else {
            pixels.add(new Pixel(Color.black, e.getX(),e.getY()));
            repaint();
        }
        
        java.awt.Point p = e.getLocationOnScreen();
        lastX = p.x;
        lastY = p.y;
        //System.out.println("MultiPanel.mousePressed: isDrawObject: " + isDrawObject);
    }

    public void mouseReleased(MouseEvent e) {
        selected = null;
    }

    public void paint(Graphics g) {
        //if (g != null) {
            g.setColor(getBackground());
            g.fillRect(0,0,getSize().width,getSize().height);
            paintInOrderAdded_ZeroToMax(g);
            Pixel p;
            for(int i = 0; i < pixels.size();i++) {
                p = pixels.get(i);
                g.setColor(p.getColor());
                g.drawLine(p.getX(),p.getY(),p.getX(),p.getY());
            }
            if (outlineColor != null) paintOutline(g);
            if (xColor != null) paintX(g);
        //}
    }

    public void paintInOrderAdded_ZeroToMax(Graphics g) {
        Paintable paintable;
        //for(int i = 0;i < elements.size();i++) {
        for(int i = elements.size() - 1; i >= 0;i--) {
            paintable = elements.get(i);
            if (paintable instanceof DrawObject) {
                paintable.doPainting(g);
            } else {
                Component comp = ((Component)paintable);
                paintable.doPainting(comp.getGraphics());
            }
        }
    }
    
    public void paintOutline(Graphics g) {
        g.setColor(outlineColor);
        g.drawRect(0,0,getSize().width - 1, getSize().height - 1);
    }
    
    public void paintX(Graphics g) {
        g.setColor(xColor);
        g.drawLine(0, 0, getSize().width - 1, getSize().height - 1);
        g.drawLine(0, getSize().height - 1, getSize().width - 1, 0);
    }

    public void setSpacing(int spacingWidth,int spacingHeight) {
        this.spacingWidth = spacingWidth;
        this.spacingHeight = spacingHeight;
    }
    
    public void setOutlineColor(Color color) {
        outlineColor = color;
    }
    
    public void setXColor(Color color) {
        xColor = color;
    }
}
