package ca.tecreations.wip.toy;

import ca.tecreations.TColor;
import ca.tecreations.Platform;
import ca.tecreations.TecData;
import ca.tecreations.TextToken;
import ca.tecreations.components.Button;
import ca.tecreations.components.Movable;
import ca.tecreations.text.SystemTokenPainter;
import ca.tecreations.text.TextPoints;


import java.awt.Graphics;
import java.awt.event.*;
import java.time.LocalDate;
/**
 *
 * @author tim
 */
public class CalendarComp extends Movable implements MouseListener {
    SystemTokenPainter label = new SystemTokenPainter(TecData.ARIAL_B_16,new TextToken("Calendar"));
    int dayWidth = 24;
    int dayHeight = 24;
    int weeksCount = 4;
    int maxWidth = (dayWidth * 7) + 20 + 20; // left and right padding
    int maxHeight; // top, between label and between days and finally, the bottom

    CalendarDate tcd = new CalendarDate(LocalDate.now());

    Button today = new Button();
    Button prevMonth = new Button();
    Button nextMonth = new Button();
    int daysInMonth;
    int firstDay;
    int year;
    String month;
    int monthsOffset = 0;
    
    public CalendarComp() {
        super(Movable.NONE);
        setLayout(null);
        setBackground(TColor.yellow);
        add(today);
        add(prevMonth);
        add(nextMonth);
        today.setBackground(TColor.red);
        today.setForeground(TColor.black);
        today.setHighlight(TColor.blue);
        today.setLocation(maxWidth - 10 - 24 - 24, 6);
        today.addMouseListener(this);
        
        nextMonth.setBackground(TColor.grey);
        nextMonth.setHighlight(TColor.red);
        nextMonth.setLocation(maxWidth - 10 - 24,6);
        nextMonth.addMouseListener(this);

        prevMonth.setBackground(TColor.green);
        prevMonth.setHighlight(TColor.red);
        prevMonth.setLocation(nextMonth.getLocation().x - 24,6);
        prevMonth.addMouseListener(this);
        
        // interesting, try mine on: lol, ok., 3265, Feb
        
        year = tcd.getYear();
        month = tcd.getMonthName(tcd.getMonth());
        computeSize();
    }
        
    public void computeSize() {
        daysInMonth = tcd.getDaysInMonth(year,tcd.getMonth(month));
        firstDay = tcd.getFirstDayIndex(year,tcd.getMonth(month));
        weeksCount = 4;
        //System.out.println("CalendarComp:computeSize: month: " + time.getMonth(month));
        //System.out.println("CalendarComp:computeSize: daysInMonth: " + daysInMonth);
        //System.out.println("CalendarComp:computeSize: firstDay: " + firstDay);
        if (daysInMonth == 28) {
            if (firstDay > 0) {
                weeksCount = 5;
            }
        } else if (daysInMonth == 29) {
            weeksCount = 5;
        } else if (daysInMonth == 30) {
            if (firstDay == 6) {
                weeksCount = 6;
            } else {
                weeksCount = 5;
            }
        } else if (daysInMonth == 31) {
            if (firstDay >= 5) {
                weeksCount = 6;
            } else {
                weeksCount = 5;
            }
        } else {
            // shouldn't ever happen, but anyway
            System.out.println("CalendarComp.computeSize: it happened");
        }
        //System.out.println("CalendarComp.computeSize: weeksCount: " + weeksCount);
        maxHeight = (dayHeight * weeksCount) + 20 + 20 + 16 + 20;
        setSize(maxWidth,maxHeight);
    }
    
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == today) {
            year = tcd.getYear();
            month = tcd.getMonthName(tcd.getMonth());
            computeSize();
        }
    }
    
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (e.getSource() == prevMonth) {
            tcd.monthBackward();
            setTo(tcd.getYear(),tcd.getMonth());
        } else if (e.getSource() == nextMonth) {
            tcd.monthForward();
            setTo(tcd.getYear(),tcd.getMonth());
        } else if (e.getSource() == this) {
            int year = Platform.getRandom(4096);
            int month = 0;
            while (month == 0) month = Platform.getRandom(12);
            if (month > 12) { 
                System.err.println("Random produces > 12");
            } else {
                setTo(year,month);
            }
        } 
        System.out.println("Location: " + getLocation());
    }
    
    public void paint(Graphics g) {
        super.paint(g);
        if (label != null) {
            label.setText(month + ", " + year);
            label.paintAt(g,10,10);
        }
        if (g == null) g = getGraphics();
        if (g == null) return;
        int startX = 20;
        int startY = 56;
        SystemTokenPainter boxPainter = new SystemTokenPainter(TecData.ARIAL_B_16,new TextToken(""));
        int dayNum = 1;
        int x = 0;
        int y = 0;
        int weekNum = 0;
        if (firstDay > 0) {
            for(int day = 0; day < 7; day++) {
                if (day >= firstDay) {
                    x = startX + (day * dayWidth);
                    y = startY + (weekNum * dayHeight);
                    boxPainter.setText("" + dayNum);
                    boxPainter.paintAt(g,startX + (day * dayWidth) + 2,startY + (weekNum * dayHeight) + 2);
                    dayNum++;
                    g.drawRect(x,y,dayWidth,dayHeight);
                }
            }
            weekNum++;
        }
        for(; weekNum < weeksCount;weekNum++) {
            for(int day = 0; day < 7; day++) {
                if (dayNum <= daysInMonth) {
                    //boxNum = week * 7 + day;
                    x = startX + (day * dayWidth);
                    y = startY + (weekNum * dayHeight);
                    boxPainter.setText("" + dayNum);
                    boxPainter.paintAt(g,startX + (day * dayWidth) + 2,startY + (weekNum * dayHeight) + 2);
                    dayNum++;
                    g.drawRect(x,y,dayWidth,dayHeight);
                }
            }
        }
        TextPoints arial18Bold = TextPoints.getInstance("Arial",18,"B");
        if (prevMonth != null) {
            prevMonth.setPoints(arial18Bold);
            prevMonth.setText("<");
        }
        if (nextMonth != null) {
            nextMonth.setPoints(arial18Bold);
            nextMonth.setText(">");
        }
        if (prevMonth != null) prevMonth.repaint();
        if (nextMonth != null) nextMonth.repaint();
    }
    
    public void setTo(int year, int month) {
        tcd = new CalendarDate(year,month);
        this.month = tcd.getMonthName(month);
        this.year = year;
        computeSize();
        repaint();
    }
    
    public void setTo(int year, String month) {
        tcd = new CalendarDate(year,tcd.getMonth(month));
        this.month = month;
        this.year = year;
        computeSize();
        repaint();
    }
    
}
