package ca.tecreations.components;

import ca.tecreations.ImageTool;

// which do you prefer?
import ca.tecreations.TColor;
import ca.tecreations.TecData;
import ca.tecreations.TextToken;
//import ca.tecreations.Textual; // ok, ok, until its finished, just comment unused
                                // without a space, unlike this line
//
import ca.tecreations.TecData;
import ca.tecreations.TextToken;
import ca.tecreations.TColor;
// I like the first style, because lowercase comes after uppercase in ASCII

// I'm not against white-space.

import ca.tecreations.interfaces.TextPainter;
import ca.tecreations.graphics.GraphicsUtil;
import ca.tecreations.text.*;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.*;
import java.awt.image.*;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author tim
 */
public class Button extends SizedPanel implements MouseListener {
    List<ActionListener> actionListeners = new ArrayList<>();
    public static final int SIZE = 24;
    public TColor oldBackground = null;
    public TColor highlight = null;
    public TColor selectedColor = TColor.TEC_SELECTED;
    public TextPainter textPainter = null;

    public TextPoints points = TecData.ARIAL_P_12;

    public BufferedImage image = null;
    
    boolean drawRaised = false;
    boolean drawSunken = false;
    boolean thin = false;

    public boolean selectable = false;
    public boolean selected = false;
    
    int padTop = 0;
    int padLeft = 0;
    int padBottom = 0;
    int padRight = 0;
    
    String text = null;
    
    public Button() {
        super(SIZE,SIZE);
        addMouseListener(this);
        setOpaque(true);
    }
    
    public void addActionListener(ActionListener l) {
        if (!actionListeners.contains(l)) actionListeners.add(l);
    }
    
    public void computeAndResize() {
        int width = points.getTextWidth(getText());
        int height = points.getFontSize();
        int maxW = Math.max(width,Button.SIZE);
        int maxH = Math.max(height,Button.SIZE);
        setSize(maxW,maxH);
    }
    
    public void doPainting(Graphics forDrawObjects) {
        Graphics g = getGraphics();
        GraphicsUtil.fill(g,getBackground(),this);
        if (image != null) {
            GraphicsUtil.paintImageCentered(g, image, this);
        }
        if (textPainter != null) {
            int fontSize = textPainter.getFontSize();
            int textWidth = textPainter.getPaintingWidth();
            int x = padLeft + ((int)(((double)(getSize().width - textWidth) / (double)2)));
            int y = padTop + ((int)(((double)(getSize().height - fontSize) / (double)2)));
            textPainter.setFillColor(new TColor(getBackground()));
            textPainter.setLineColor(new TColor(getForeground()));
            textPainter.paintAt(g, x, y);
        }
        if (selectable) {
            if (selected) {
                g.setColor(selectedColor);
                g.drawRect(3,3,getSize().width - (3 * 2) - 1, getSize().height - (3 * 2) - 1);
                g.drawRect(4,4,getSize().width - (4 * 2) - 1, getSize().height - (4 * 2) - 1);
            }
        }
        if (drawRaised) {
            if (thin) GraphicsUtil.drawRaisedThin(g,this);
            else GraphicsUtil.drawRaised(g, this);
            
        }
        if (drawSunken) {
            if (thin) GraphicsUtil.drawSunkenThin(g,this);
            else GraphicsUtil.drawSunken(g,this);
        }
    }  
    
    public BufferedImage getImage() { return image; }
    
    public TextPoints getPoints() { return points; }
    
    public String getText() {
        if (textPainter != null) return textPainter.getText();
        else return "";
    }
    
    public int getTextWidth() {
        return textPainter.getTextWidth();
    }
    
    public void mouseEntered(MouseEvent e) {
        if (highlight != null) {
            oldBackground = new TColor(getBackground());
            setBackground(highlight);
            repaint();
        }
    }
    
    public void mouseExited(MouseEvent e) {
        if (highlight != null) {
            setBackground(oldBackground);
            repaint();
        }
    }
    
    public void mouseClicked(MouseEvent e) {
        for(int i = 0; i < actionListeners.size();i++) {
            actionListeners.get(i).actionPerformed(new ActionEvent(this,0,"mouseClicked"));
        }
        
    }
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    
    public void paint(Graphics g) {
        super.paint(g);
        doPainting(g);
    }
    
    public void removeActionListener(ActionListener l) {
        actionListeners.remove(l);
    }
    
    public void setDrawRaised(boolean flag) {
        thin = false;
        drawRaised = flag;
        drawSunken = false;
        repaint();
    }
    
    public void setDrawRaisedThin(boolean flag) {
        thin = true;
        drawRaised = flag;
        drawSunken = false;
        repaint();
    }
    
    public void setDrawSunken(boolean flag) {
        thin = false;
        drawSunken = flag;
        drawRaised = false;
        repaint();
    }
    
    public void setDrawSunkenThin(boolean flag) {
        thin = true;
        drawSunken = flag;
        drawRaised = false;
        repaint();
    }
    
    public void setHighlight(Color highlight) {
        this.highlight = new TColor(highlight);
        repaint();
    }
    
    public void setImage(BufferedImage img) {
        this.image = ImageTool.getResized(img,getSize().width,getSize().height);
        repaint();
    }
    
    public void setPadding(int top, int left, int bottom, int right) {
        padTop = top;
        padLeft = left;
        padBottom = bottom;
        padRight = right;
        computeAndResize();
        repaint();
    }
    
    public void setTextPainter(TextPainter textPainter) {
        this.textPainter = textPainter;
        textPainter.setFillColor(new TColor(getBackground()));
        textPainter.setLineColor(new TColor(getForeground()));
        textPainter.setPoints(points);
        textPainter.setText(getText());
        int w = textPainter.getTextWidth();
        int h = textPainter.getFontSize() + textPainter.getMaxDescent();
        setSize(Math.max(w, SIZE),Math.max(h,SIZE));
        repaint();
    }
    
    public void setPoints(TextPoints points) {
        this.points = points;
        if (this.textPainter == null) {
            if (text == null) {
                text = "";
                this.textPainter = new GUITextTokenPainter(points,new TextToken(""));
            } else {
                this.textPainter = new GUITextTokenPainter(points,new TextToken(text));
            }
        }
        textPainter.setPoints(points);
        int w = textPainter.getTextWidth();
        int h = textPainter.getFontSize() + textPainter.getMaxDescent();
        // if OUTLINED add space for OUTLINE_TYPE
        setSize(Math.max(w, SIZE),Math.max(h,SIZE));
        repaint();
    }
    
    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }
    
    public void setSelected(boolean selected) {
        this.selected = selected;
        repaint();
    }
    
    public void setSelectedColor(Color c) {
        selectedColor = new TColor(c);
        repaint();
    }
    
    public void setText(String text) {
        if (this.textPainter == null) {
            this.textPainter = new GUITextTokenPainter(points,new TextToken(text));
        }
        this.textPainter.setText(text);
        // always resize
        int w = textPainter.getTextWidth();
        //System.out.println("text.width: " + w);
        int h = textPainter.getFontSize();
        // if OUTLINED, Add Space for OUTLINE_TYPE
        
        
        
        // add padding
        
        
        // and compare insets to make a bit bigger or whatever
        
        // finally, set sins,
        setSize(Math.max(SIZE,w),Math.max(SIZE,h));
        // repent.
        repaint();
    }
}
