package ca.tecreations.components;


import ca.tecreations.TColor;
import ca.tecreations.ProjectPath;
import ca.tecreations.components.event.BoxSizeSetEvent;
import ca.tecreations.components.event.BoxSizeSetListener;
import ca.tecreations.interfaces.Colored;
import ca.tecreations.interfaces.HasPopup;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.*;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*; 
 
/**
 *
 * @author Tim
 */ 
public class BoundingBox extends Movable implements Colored, HasPopup, MouseListener {
    public static int BOX_NUM = 0;
    Handle N = new Handle(Handle.VERTICAL);
    Handle E = new Handle(Handle.HORIZONTAL);
    Handle W = new Handle(Handle.HORIZONTAL);
    Handle S = new Handle(Handle.VERTICAL);
    Handle NW = new Handle();
    Handle NE = new Handle();
    Handle SW = new Handle();
    Handle SE = new Handle();
    List<Handle> handles = new ArrayList<>();
    int half = (Handle.size + 1) / 2;
    boolean firstRun = true;
    boolean drawBoxLines = false;
    TColor boxOutlineColor = TColor.BRIGHT_RED;
    BufferedImage image = null;
    boolean debug = false;
    List<BoxSizeSetListener> boxSizeSetListeners = new ArrayList<>();
    String type = "BoundingBox"; // you must override this if you intend for it to be meaningful
    
    JPopupMenu popupMenu = null;
    
    
    public BoundingBox(Color c) {
        super(NONE);
        setName("BoundingBox" + ++BOX_NUM);
        setBackground(c);
        setLayout(null);
        addHandles();
        setHandlesVisible(false);
        //addComponentListener(this);
    }

    public void addBoxSizeSetListener(BoxSizeSetListener l) {
        if (!boxSizeSetListeners.contains(l)) boxSizeSetListeners.add(l);
    }
    
    public void addHandle(Handle handle) {
        add(handle);
        handles.add(handle);
        handle.addMouseMotionListener(this);
    }
    
    public void addHandles() {
        addHandle(N);
        addHandle(E);
        addHandle(W);
        addHandle(S);
        addHandle(NW);
        addHandle(NE);
        addHandle(SW);
        addHandle(SE);
    }
    
    public void bumpUp() {
        moveBy(0,-10);
    }
    
    public void bumpDown() {
        moveBy(0,10);
    }
    
    public void bumpLeft() {
        moveBy(-10,0);
    }
    
    public void bumpRight() {
        moveBy(10,0);
    }
    
    // do not @Override doLayout(), create your own, like myProjectXYZ_doLayout(...)

    public void doPainting(Graphics g) {
        if (g != null) {
            if (firstRun) {
                setHandleLocations();
                firstRun = false;
            }
            if (image != null) g.drawImage(image,0,0,this);
            if (drawBoxLines) {
                g.setColor(boxOutlineColor);
                g.drawRect(0,0,getWidth() - 1,getHeight() - 1);
            }
            if (handles != null) {
                for(int i = 0; i < handles.size();i++) {
                    handles.get(i).repaint();
                }
            }
        }
    }
    
    public BufferedImage drawOnImage(BufferedImage img) {
        Graphics g = img.getGraphics();
        java.awt.Point boxLoc = getLocation();
        g.drawImage(image,boxLoc.x,boxLoc.y,this);
        g.setColor(NW.getBackground());
        if (drawBoxLines) {
            g.drawRect(boxLoc.x,boxLoc.y,getWidth() - 1,getHeight() - 1);
        }
        int size = handles.get(0).getSize().width;
        Handle handle;
        int handleX;
        int handleY;
        java.awt.Point hxy;
        for(int i = 0; i < handles.size();i++) {
            handle = handles.get(i);
            hxy = handle.getLocation();
            handleX = boxLoc.x + hxy.x;
            handleY = boxLoc.y + hxy.y;
            g.fillRect(handleX,handleY,size,size);
        }
        return img;
    }
    
    public void fireBoxSetSizeEvent(BoxSizeSetEvent e) {
        BoundingBox box = e.getBoundingBox();
        Handle handle = e.getHandle();
        for(int i = 0; i < boxSizeSetListeners.size();i++) {
            boxSizeSetListeners.get(i).boxSizeSet(e);
        }
    }
    
    public TColor getBoxElementsColor() { return new TColor(NW.getBackground()); }

    public BufferedImage getImage() { 
        return image;
    }
     
    public String getType() {
        return type;
    }
    
    public void handleE(int x, int y, int width, int height) {
        //System.out.println("N: " + N.getDX() + "," + N.getDY());
        if (E.getRight() < W.getLeft()) {
            Handle temp = E;
            E = W;
            W = temp;
            width = 1;
        } else {
            width += E.getDX();
        }
        setLocation(x,y);
        setSize(width,height);
    }
    
    public void handleN(int x, int y, int width, int height) {
        //System.out.println("N: " + N.getDX() + "," + N.getDY());
        if (N.getTop() > S.getBottom()) {
            Handle temp = N;
            N = S;
            S = temp;
            height = 1;
        } else {
            height -= N.getDY();
            y += N.getDY();
        }
        setLocation(x,y);
        setSize(width,height);
    }
    
    public void handleNE(int x, int y, int width, int height) {
        Handle temp = NE;
        int dx = NE.getDX();
        int dy = NE.getDY();
        if (NE.getRight() >= NW.getLeft() && NE.getTop() <= SE.getBottom()) {
            // top right
            if (dy < 0) {
                y += dy;
                height -= dy;
            } else if (dy > 0) {
                y += dy;
                height -= dy;
            }
            width = NE.getRight();
        } else if (NE.getRight() >= NW.getLeft() && NE.getTop() >= SE.getBottom()) {
            // bottom right
            //System.out.println("Swap NE=>SE, SE=>NE");
            NE = SE;
            SE = temp;
        } else if (NE.getRight() <= NW.getLeft() && NE.getTop() <= SE.getBottom()) {
            // top left
            //System.out.println("Swap NE=>NW, NW=>NE");
            NE = NW;
            NW = temp;
        } else if (NE.getRight() <= SW.getLeft() && NE.getTop() >= SW.getBottom()) {
            // bottom left
            //System.out.println("Swap NE=>SW, SW=>NE");
            NE = SW;
            SW = temp;
        }
        NE.setVisible(true);
        SW.setVisible(true);
        setLocation(x,y);
        setSize(width,height);
    }
    
    public void handleNW(int x, int y, int width, int height) {
        Handle temp = NW;
        int dx = NW.getDX();
        int dy = NW.getDY();
        if (NW.getLeft() <= SE.getRight() && NW.getTop() <= SE.getBottom()) {
            if (dx < 0) {
                x += dx;
                width -= dx;
                if (dy > 0) {
                    y += dy;
                    height -= dy;
                } else if (dy < 0) {
                    y += dy;
                    height -= dy;
                } // else height = height
            } else if (dx == 0) {
                // width = width;
                if (dy > 0) {
                    y += dy;
                    height -= dy;
                } else if (dy < 0) {
                    y += dy;
                    height -= dy;
                } // else height = height;
            } else if (dx > 0) {
                x += dx;
                width -= dx;
                if (dy > 0) {
                    y += dy;
                    height -= dy;
                } else if (dy < 0) {
                    y += dy;
                    height -= dy;
                }
            }
        } else if (NW.getLeft() <= SE.getRight() && NW.getTop() >= SE.getBottom()) {
            //System.out.println("Swap NW=>SW, SW=>NW");
            NW = SW;
            SW = temp;
        } else if (NW.getLeft() >= SE.getRight() && NW.getTop() <= SE.getBottom()) {
            //System.out.println("Swap NW=>NE, NE=>NW");
            NW = NE;
            NE = temp;
        } else if (NW.getLeft() >= SE.getRight() && NW.getTop() >= SE.getBottom()) {
            //System.out.println("Swap NW=>SE, SE=>NW");
            NW = SE;
            SE = temp;
        }
        NW.setVisible(true);
        SE.setVisible(true);
        setLocation(x,y);
        setSize(width,height);
    }
    
    public void handleS(int x, int y, int width, int height) {
        //System.out.println("S: " + S.getDX() + "," + S.getDY());
        if (S.getBottom() < N.getTop()) {
            Handle temp = S;
            S = N;
            N = temp;
            height = 1;
        } else {
            height += S.getDY();
        }
        setLocation(x,y);
        setSize(width,height);
    }
    
    public void handleSE(int x, int y, int width, int height) {
        Handle temp = SE;
        if (SE.getRight() >= NW.getLeft() && SE.getBottom() >= NW.getTop()) {
            width = SE.getRight();
            height = SE.getBottom();
        } else if (SE.getRight() <= NW.getLeft() && SE.getBottom() <= NW.getTop()) {
            //System.out.println("Swap SE=>NW, NW=>SE");
            SE = NW;
            NW = temp;
        } else if (SE.getRight() <= NW.getLeft()) {
            //System.out.println("Swap SE=>SW, SW=>SE");
            SE = SW;
            SW = temp;
        } else if (SE.getBottom() <= NE.getTop()) {
            //System.out.println("Swap SE=>NE, NE=>SE");
            SE = NE;
            NE = temp;
        }
        NW.setVisible(true);
        SE.setVisible(true);
        setLocation(x,y);
        setSize(width,height);
    }
 
    public void handleSW(int x, int y, int width, int height) {
        Handle temp = SW;
        int dx = SW.getDX();
        int dy = SW.getDY();
        if (SW.getLeft() <= SE.getRight() && SW.getBottom() >= NE.getTop()) {
            // bottom left
            if (dx < 0) {
                x += dx;
                height += dy;
                width -= dx;
            } else if (dx == 0) {
                height += dy;
            } else if (dx > 0) {
                x += dx;
                height += dy;
                width -= dx;
            }
        } else if (SW.getLeft() >= SE.getRight() && SW.getBottom() <= NE.getTop()) {
            // top right
            //System.out.println("Swap NE=>SW, SW=>NE");
            SW = NE;
            NE = temp;
        } else if (SW.getLeft() <= SE.getRight() && SW.getBottom() <= NW.getTop()) {
            // top left
            //System.out.println("Swap SW=>NW, NW=>SW");
            SW = NW;
            NW = temp;
        } else if (SW.getLeft() >= SE.getRight() && SW.getBottom() >= NW.getTop()) {
            // bottom right
            //System.out.println("Swap SE=>SW, SW=>SE");
            SW = SE;
            SE = temp;
        }
        NE.setVisible(true);
        SW.setVisible(true);
        setLocation(x,y);
        setSize(width,height);
    }

    public void handleW(int x, int y, int width, int height) {
        //System.out.println("S: " + S.getDX() + "," + S.getDY());
        if (W.getLeft() > E.getRight()) {
            Handle temp = W;
            W = E;
            E = temp;
            width = 1;
        } else {
            width -= W.getDX();
            x += W.getDX();
        }
        setLocation(x,y);
        setSize(width,height);
    }
    
    public static void main(String[] args) {
        TFrame app = new TFrame(ProjectPath.getTecPropsPath() + "BoundingBox.properties","BoundingBoxTestFrame");
        JPanel holder = new JPanel();
        holder.setLayout(null);
        app.add(holder,BorderLayout.CENTER);
        BoundingBox box = new BoundingBox(TColor.black);
        box.setBoxElementsColor(TColor.yellow);
        box.setSize(240,120);
        //box.setFlashHandles(true);
        holder.add(box);
        app.setVisible(true);
        
    }

    public void mousePressed(MouseEvent e) {
        setHandlesVisible(true);
        super.mousePressed(e);
        if (SwingUtilities.isRightMouseButton(e)) {
            if (popupMenu != null) {
                popupMenu.show(e.getComponent(),e.getX(),e.getY());
            }
        } else if (e.isControlDown()) {
            if (e.isAltDown()) {
                System.out.println("Resising in BB.mp()");
                setSize(getSize().width + 5, getSize().height + 5);
            } else {
                System.out.println("Resising in BB.mp()");
                setSize(getSize().width - 5, getSize().height - 5);
            }
        }
    }
    
    public void mouseDragged(MouseEvent e) {
        if (e.getSource() instanceof Handle) {
            Handle handle = (Handle)e.getSource();
            if (debug) System.out.println("BB.md: Handle: " + handle + ": " + handle.getDX() + "," + handle.getDY());
            int x = getLocation().x;
            int y = getLocation().y;
            resetSize(handle,x,y,getWidth(),getHeight());
        } else {
            super.mouseDragged(e);
        }
    }
    
    // do not @Override move either
    
    public void moveBy(int x, int y) {
        java.awt.Point p = getLocation();
        super.setLocation(p.x + x, p.y + y);
    }
    
    public void nudgeUp() {
        moveBy(0,-1);
    }
    
    public void nudgeDown() {
        moveBy(0,1);
    }
    
    public void nudgeLeft() {
        moveBy(-1,0);
    }
    
    public void nudgeRight() {
        moveBy(1,0);
    }
    
    public void paint(Graphics g) {
        super.paint(g);
        doPainting(g);
    }
        
//    public void paintComponent(Graphics g) {
//        super.paintComponent(g);
//        doPainting(g);
//    }
    
    public void removeBoxSizeSetListener(BoxSizeSetListener l) {
        boxSizeSetListeners.remove(l);
    }
    
    public void resetSize(Handle handle, int x, int y, int w, int h) {
        if (handle == N) handleN(x,y,w,h);
        else if (handle == S) handleS(x,y,w,h);
        else if (handle == E) handleE(x,y,w,h);
        else if (handle == W) handleW(x,y,w,h);
        else if (handle == NW) handleNW(x,y,w,h);
        else if (handle == NE) handleNE(x,y,w,h);
        else if (handle == SW) handleSW(x,y,w,h);
        else if (handle == SE) handleSE(x,y,w,h);
        setHandleLocations();
        fireBoxSetSizeEvent(new BoxSizeSetEvent(this,handle));
    }
    
    public void setBoxElementsColor(Color c) {
        for(int i = 0; i < handles.size();i++) {
            handles.get(i).setBackground(c);
        }
        repaint();
    }
    
    public void setDrawBoxLines(boolean f) {
        drawBoxLines = f;
        repaint();
    }
    
    public void setForeground(Color c) {
        super.setForeground(c);
        repaint();
    }
    
    public void setHandleLocations() {
        int midX = (int)((getWidth() + 1) / 2) - half;
        int midY = (int)((getHeight() + 1) / 2) - half;
        if (N != null) {
            N.setLocation(midX,0);
            E.setLocation(getWidth() - Handle.size,midY);
            W.setLocation(0,midY);
            S.setLocation(midX,getHeight() - Handle.size);
            NW.setLocation(0,0);
            NE.setLocation(getWidth() - Handle.size,0);
            SW.setLocation(0,getHeight() - Handle.size);
            SE.setLocation(getWidth() - Handle.size,getHeight() - Handle.size);
        }
    }
    
    public void setHandlesVisible(boolean state) {
        for(int i = 0; i < handles.size();i++) {
            handles.get(i).setVisible(state);
        }
        if (state) setHandleLocations();
    }
    
    public void setImage(BufferedImage image) {
        this.image = image;
        repaint();
    }
    
    public BoundingBox setOutline(boolean state) {
        drawBoxLines = state;
        repaint();
        return this;
    }
    
    public void setOutlineColor(Color outline) {
        drawBoxLines = true;
        boxOutlineColor = new TColor(outline);
        repaint();
    }
   
    public void setJPopupMenu(JPopupMenu menu) {
        popupMenu = menu;
    }
    
    public void setSize(int width, int height) {
        super.setSize(width,height);
        setHandleLocations();
    }
    
    public void setTransparent(boolean transparent) {
        setOpaque(!transparent);
    }
    
    public void setType(String type) {
        this.type = type;
    }
    
    public void showPopup(MouseEvent e) {
        if (popupMenu != null) {
            popupMenu.show(this,e.getX(),e.getY());
        }
    }
}
