package ca.tecreations;

import ca.tecreations.graphics.DrawPoint;
import java.awt.Color;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author Tim
 */ 
public class Point extends java.awt.Point {
    public static int PICK_SIZE = 5;
    public int x = 0;
    public int y = 0;
    
    public Point() {}
    
    public Point(int x, int y) { 
        this.x = x; 
        this.y = y;
    }
     
     
    // you need to say, I'll shelter that. I see you doing it... how can I help?
    public Point(java.awt.Point p) {
        this.x = p.x;
        this.y = p.y;
    }
    
    public Point(String xString, String yString) {
        this.x = Integer.parseInt(xString);
        this.y = Integer.parseInt(yString);
    }
    
    public Point add(ca.tecreations.Point p) {
        return new Point(x + p.x, y + p.y);
    }
    
    public Point add(java.awt.Point p) {
        return new Point(x + p.x, y + p.y);
    }
    
    public Point add(int x, int y) {
        return new Point(this.x + x,this.y + y);
    }
    
    public static long drawPoints(Graphics g, int tx, int ty,List<Point> points) {
        int x;
        int y;
        Point p;
        long width = 0;
        for(int i = 0; i < points.size();i++) {
            p = points.get(i);
            width = Math.max(width,p.x);
            x = tx + p.x;
            y = ty + p.y;
            g.drawLine(x,y,x,y);
        }
        return width;
    }
    
    public void draw(Graphics g, int tx, int ty) {
        int x = tx + this.x;
        int y = ty + this.y;
        g.drawLine(x,y,x,y);
    }
    
    public boolean equals(Point p2) {
        return x == p2.x && y == p2.y;
    }
    
    public boolean equalsByObject(Object p2) {
        if (p2 instanceof DrawPoint) {
            if (((DrawPoint)p2).getPoint().equalsByValue(this)) return true;
        } else if (p2 instanceof ca.tecreations.Point) {
            if (this == (ca.tecreations.Point)p2) return true;
        } else if (p2 instanceof java.awt.Point) {
            if (this == (java.awt.Point)p2) return true;
        }
        return false;
    }
    
    public boolean equalsByValue(Point p2) {
        return equals(p2);
    }
    
    public static Point fromString(String parenthesized) {
        String asPlain = StringTool.getUnwrapped(parenthesized); // remove parentheses
        String xString = asPlain.substring(0,asPlain.indexOf(","));
        String yString = asPlain.substring(asPlain.indexOf(",") + 1);
        return new Point(xString,yString);
    }
    
    /** gets the point as a comma separated pair, useful for properties access
     + @see TypeToType
     * @return 
     */
    public String getAsCSV() {
        return x + "," + y;
    }
    
    public static Point getBottomRightCoordinate(BufferedImage src, Color target) {
        int maxX = src.getWidth() - 1;
        int maxY = src.getHeight() - 1;
        int rgb = target.getRGB();
        for (int j = maxY; j >= 0; j--) {
            int[] row = ImageTool.getRow(src, j);
            int color1 = row[maxX];
            for (int i = maxX; i >= 0; i--) {
                if (row[i] == rgb) {
                    return new Point(i + 1,j + 1);
                }
            }
        }
        return null;
    }

    public static Point getFromPackaged(String s) {
        String parenthesized = StringTool.getUnwrapped(s); // remove double quotes
        return fromString(parenthesized);
    } 
    
    public static int getHeight(List<Point> points) {
        if (points.size() > 0) {
            int min = points.get(0).y;
            int max = min;
            for(int i = 1; i < points.size();i++) {
                min = Math.min(min,points.get(i).y);
                max = Math.max(max,points.get(i).y);
            }
            return max - min;
        } else {
            return 0;
        }
    }
    
    public static int getMaxX(List<Point> list) {
        int maxX = 0;
        for (int i = 0; i < list.size(); i++) {
            maxX = Math.max(list.get(i).x, maxX);
        }
        return maxX;
    }

    public static int getMaxY(List<Point> list) {
        int maxY = 0;
        for (int i = 0; i < list.size(); i++) {
            maxY = Math.max(list.get(i).y, maxY);
        }
        return maxY;
    }

    public static int getMinX(List<Point> list) {
        int minX = list.get(0).x;
        for (int i = 0; i < list.size(); i++) {
            minX = Math.min(list.get(i).x, minX);
        }
        return minX;
    }

    public static int getMinY(List<Point> list) {
        int minY = list.get(0).y;
        for (int i = 0; i < list.size(); i++) {
            minY = Math.min(list.get(i).y, minY);
        }
        return minY;
    }

    public String getPackaged() {
        return StringTool.getDoubleQuoted(StringTool.getParenthesisWrapped(toString()));
    }
    
    /** returns the point parenthesized -- to separate
     * 
     * @return the data of the point wrapped in parenthesis
     */
    public String getParenthesized() {
        return StringTool.getParenthesisWrapped(toString());
    }
    
    public static String getPointList(List<Point> points) {
        String s = "";
        for(int i = 0; i < points.size();i++) {
            s += points.get(i).getAsCSV() + ";";
        }
        return s;
    }
    
    public static List<Point> getSortedByX_ASCENDING(List<Point> src) {
        List<Point> temp = new ArrayList<>();
        for(int i = 0; i < src.size();i++) temp.add(src.get(i));
        List<Point> result = new ArrayList<>();
        int minX = getMinX(src);
        int maxX = getMaxX(src);
        int x = minX;
        while(temp.size() > 0 && x <= maxX) {
            for(int i = temp.size() - 1;i >= 0;i--) {
                if (temp.get(i).x == x) {
                    result.add(temp.get(i));
                    temp.remove(i);
                }
            }
            x++;
        }
        return result;
    }
    
    public static List<Point> getSortedByY_ASCENDING(List<Point> src) {
        List<Point> temp = new ArrayList<>();
        for(int i = 0; i < src.size();i++) temp.add(src.get(i));
        List<Point> result = new ArrayList<>();
        int minY = getMinY(src);
        int maxY = getMaxY(src);
        int y = minY;
        while(temp.size() > 0 && y <= maxY) {
            for(int i = temp.size() - 1;i >= 0;i--) {
                if (temp.get(i).y == y) {
                    result.add(temp.get(i));
                    temp.remove(i);
                }
            }
            y++;
        }
        return result;
    }
    
    public static Point getTopLeftCoordinate(BufferedImage src,Color target) {
        int w = src.getWidth();
        int h = src.getHeight();
        int rgb = target.getRGB();
        for (int j = 0; j < src.getHeight(); j++) {
            int[] row = ImageTool.getRow(src, j);
            for (int i = 1; i < row.length; i++) {
                if (row[i] == rgb) {
                    return new Point(i, j);
                }
            }
        }
        return null;
    }

    
    public static int getWidth(List<Point> points) {
        if (points.size() > 0) {
            int min = points.get(0).x;
            int max = min;
            for(int i = 1; i < points.size();i++) {
                min = Math.min(min,points.get(i).x);
                max = Math.max(max,points.get(i).x);
            }
            return max - min;
        } else {
            return 0;
        }
    }
    
    public boolean hasPoint(Point p) {
        return p.x >= p.x - PICK_SIZE &&
               p.x <= p.x - PICK_SIZE &&
               p.y >= p.y - PICK_SIZE &&
               p.y <= p.y - PICK_SIZE;
    }
    
    public static void main(String[] args) {
        List<Point> points = new ArrayList<>();
        points.add(new Point(3,5));
        points.add(new Point(3,1));
        points.add(new Point(3,56));
        points.add(new Point(3,3));
        System.out.println("Sorted: " + getSortedByY_ASCENDING(points));
    }
        
    public Point minux(java.awt.Point p) {
        return new Point(x - p.x, y - p.y);
    }
    
    public Point minus(int x, int y) {
        return new Point(this.x - x,this.y - y);
    }
    
    
    
    public String toString() {
        return x + "," + y; 
    }
    
    
}
