package ca.tecreations;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

/**
 *
 * @author Tim
 */
public class BuildFast {
    private static boolean standalone = false;
    private final Object lock = new Object();
    List<SystemToken> tokens = new ArrayList<>();
    SystemTool tool = new SystemTool();

    public BuildFast(String projectPath, boolean clean) {
//        tool.setDebug(true);
        long start = 0L;
        long stop = 0L;
        start = System.currentTimeMillis();
        System.out.println("Started: " + start);
        String classpathRoot = projectPath;
//        if (clean) {
//            new Clean(classpathRoot, true);
//        }
        doOp(classpathRoot,new File(classpathRoot));

        stop = System.currentTimeMillis();
        System.out.println("Stopped: " + stop);
        printElapsedTime(start, stop);
        // show our results;
        System.out.println("===================================================");
        int outCount = 0;
        int errCount = 0;
        for (int i = 0; i < tokens.size(); i++) {
            if (tokens.get(i).getType() == TecData.SYS_OUT) {
                outCount++;
            } else {
                errCount++;
            }
        }
    } 
  
    public void doOp(String classPath, File dir) {
        Pair pair = new Pair(dir);
        List<File> dirs = pair.getDirs();
        tool.compileDir(classPath,dir);
        for (int i = 0; i < dirs.size(); i++) doOp(classPath,dirs.get(i));
    }

    public static void launch(String projectPath, boolean clean) {
        //System.out.println("BuildProject.launch: " + classPath);
        new BuildFast(projectPath,clean);
        //if (buildNet) new BuildPackage("ca.tecreations.net",clean);
        if (standalone) System.exit(0);
    }

    public static void main(String[] args) {
        if (Platform.getRuntimePath().endsWith(".jar")) {
            System.err.println("BuildPackage doesn't work on jars, yet.");
        }
        boolean clean = true;
        standalone = true;
        launch(ProjectPath.getProjectPath("BCTLSNetwork"), clean);
    }

    public static void printElapsedTime(long start, long stop) {
        long total = stop - start;
        Date date = new Date(total);
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String formatted = formatter.format(date);
        System.out.println("Elapsed Time: (" + total + "): " + formatted);
    }

    public static void usage() {
        System.out.println("Usage: java -cp ... ca.tecreations.BuildFast classpath");
        System.exit(0);
    }
}
