package ca.tecreations.wip.toy;

//import uhn.PayPeriod;
import ca.tecreations.File;
import ca.tecreations.Font;
import ca.tecreations.Platform;
import ca.tecreations.Point;
import ca.tecreations.ProjectPath;
import ca.tecreations.TColor;
import ca.tecreations.TecData;
import ca.tecreations.TextToken;
import ca.tecreations.components.TFrame;
import ca.tecreations.text.GUITextTokenPainter;
import ca.tecreations.text.JavaParser;
import ca.tecreations.text.TextPoints;
import ca.tecreations.graphics.Arc;
import ca.tecreations.graphics.BezierCurve;
import ca.tecreations.graphics.Circle;
import ca.tecreations.graphics.Line;
import ca.tecreations.graphics.PieChart;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;

/**
 *
 * @author tim
 */
public class Toy extends TFrame implements ActionListener {
    public static Toy instance;
    MultiPanel multi;
    
    Line line;
    Circle circle;
    Arc arc;
    BezierCurve bezierCurve;
    
    GUITextTokenPainter title = new GUITextTokenPainter(TecData.ARIAL_B_16, new TextToken("Title"));
    GUITextTokenPainter text = new GUITextTokenPainter(TextPoints.getInstance(new Font("Times New Roman",Font.PLAIN,14)), new TextToken("Text"));
    GUITextTokenPainter keyword = new GUITextTokenPainter(TecData.LG_CODE_POINTS,new TextToken("public"));
    
    NewsLinks news = new NewsLinks();

    CalendarComp calendar = new CalendarComp();
    
    PieChart pieChart;
    
//    PayPeriod payPeriod;
    
    Add add = new Add();
    
    Timer timer;
    
    File clientCodeFile = new File(ProjectPath.getProjectPath() + ProjectPath.getSubPath("ca.tecreations.net") + "Client.java");
    File serverCodeFile = new File(ProjectPath.getProjectPath() + ProjectPath.getSubPath("ca.tecreations.net") + "Server.java");
    File TNDataCodeFile = new File(ProjectPath.getProjectPath() + ProjectPath.getSubPath("ca.tecreations.net") + "TNData.java");
    
    public Toy() {
        super(ProjectPath.getTecreationsPath() + "properties" + File.separator + "Toy.properties","Toy");
        setupGUI();
        line = new Line();
        line.setEndPoint(100,100);
        circle = new Circle(100);
        circle.setTXY(new Point(225,225));
        circle.setFillColor(TColor.white);
        circle.setNandColor(TColor.BROWN);
        arc = new Arc(50).setSize(350).setRotation(15);
        arc.setFillColor(TColor.white);
        arc.setShowLines(true).setTXY(300,100);
        bezierCurve = new BezierCurve(TColor.blue,BezierCurve.UP_RIGHT);
        bezierCurve.setTXY(new Point(150,150));
        bezierCurve.setDrawLines(false);
        multi.addPaintable(line);
        multi.addPaintable(circle);
        multi.addPaintable(arc);
        multi.addPaintable(bezierCurve);
        multi.setSpacing(10,10);
        
//        multi.addPaintable(title);
//        title.setLocation(5,120);
        
  //      multi.addPaintable(text);
  //      text.setLocation(5,title.getLocation().y + title.getHeight());
        
        multi.addPaintable(keyword);
        keyword.setLocation(5,text.getLocation().y + text.getHeight());
        //System.out.println("Keyword: " + _public.getText() + " ?: " + JavaParser.isKeyword(_public.getText()));
        if (JavaParser.isKeyword(keyword.getText())) {
            keyword.setForeground(TColor.blue);
        }
          
//        NewsLinks news = new NewsLinks();
//        multi.addPaintable(news);
//        news.setLocation(15,224);
        //linkToCTV.setBackground(Color.BRIGHT_YELLOW);
        //news.setBackground(Color.YELLOW);
         
//        multi.addPaintable(calendar);
        calendar.setLocation(565,15);
        
        
        PieChart pieChartTest = getTestPieChart();
        pieChartTest.addTranslation(500,75);
        multi.addPaintable(pieChartTest);
        
//        payPeriod = new PayPeriod(new Date(2024,6,1),new Date(2024,6,16),2);
//        multi.addPaintable(payPeriod);
//        payPeriod.setLocation(150,280);
        
        multi.addPaintable(add);
        add.setLocation(550,150);
        
        //Platform.hideCursor(this);
        //timer = new Timer(5000,this);
        //timer.start();
    }
    
    @Override
    public void actionPerformed(ActionEvent e) {
        System.out.println("Current Cursor: " + Platform.getCursorString(this));
        Platform.setDefaultCursor(this);
    }
    
    public PieChart getTestPieChart() {
        List<Integer> percents = new ArrayList<>();
        List<TColor> colors = new ArrayList<>();
        percents.add(12);
        percents.add(28);
        percents.add(14);
        percents.add(16);
        percents.add(20);
        percents.add(10);
        colors.add(TColor.TEC_ORANGE);
        colors.add(TColor.TEC_PURPLE);
        colors.add(TColor.TEC_LIGHT_GREY);
        colors.add(TColor.red);
        colors.add(TColor.white);
        colors.add(TColor.magenta);
        return new PieChart(100,percents,colors);
    }
    
    public static void createAndShowGUI() {
        instance = new Toy();
        instance.setVisible(true);
    }
    
    public static void launch() {
        SwingUtilities.invokeLater(() -> {
            createAndShowGUI();
        });
    }
    
    public static void main(String[] args) {
        launch();
    }
    
    public void paint(Graphics g) {
        super.paint(g);
        multi.paint(multi.getGraphics());
    }
    
    public void setupGUI() {
        multi = new MultiPanel();
        add(multi,BorderLayout.CENTER);
        validate();
    }
     
}
