package ca.tecreations.wip.toy;

import ca.tecreations.TColor;
import ca.tecreations.TextToken;
import ca.tecreations.text.GUITextTokenPainter;
import ca.tecreations.text.TextPoints;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;


/**
 *
 * @author tim
 */
public class Link extends GUITextTokenPainter {
    String url;
    
    public Link(String url) {
        super(TextPoints.getInstance("Arial",Font.BOLD,14),new TextToken(url));
        setSize(getTextWidth(),getHeight());
        this.url = url;
        this.setOutlineColor(null);
        this.setXColor(null);
        
    }
    
    public Link(String domain, String authorName) {
        super(TextPoints.getInstance("Arial",Font.BOLD,14),new TextToken("https://" + domain + "/&tim$2U.:; -- sum One Please. Thank you!"));
        setSize(getTextWidth(),getHeight());
        this.url = "https://" + domain + "/";
        this.setOutlineColor(TColor.TEC_ORANGE);
        this.setXColor(null);
    }
    
    public String getLink() { return url; }
    
    public String getURL() { return url; }
    
    public void paint(Graphics g) {
        super.paint(g);
        Dimension size = getSize();
        if (g != null) {
            g.setColor(TColor.blue);
            g.drawRect(0,0,size.width,size.height);
        }
    }
    
}
