package ca.tecreations.wip.toy;

import ca.tecreations.Platform;
import ca.tecreations.TColor;
import ca.tecreations.components.Movable;
import ca.tecreations.interfaces.Paintable;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.*;
/**
 *
 * @author tim
 */
public class Add extends Movable implements Paintable {
    
    public Add() {
        super(Movable.NONE);
        setBackground(TColor.pink);
    }
    
    public void doPainting(Graphics g) {
        super.paint(g);
        if (g != null) {
            g.setColor(getBackground());
            g.fillRect(0,0,getSize().width,getSize().height);
            g.setColor(Color.black);
            g.drawString("Add",20,20);
        }
    }
    
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        getParent().repaint();
    }
    
    public void mouseReleased(MouseEvent e) {
        super.mouseDragged(e);
        Platform.getTopLevelContainer(this).repaint();
    }
    
    public void paint(Graphics g) { 
        doPainting(g);
    }
    
    public void repaint() {
        paint(getGraphics());
    }
}
