package ca.tecreations.lang.java;


import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author tim
 */
public class FQCN { 
    String root = "";
    String domain = "";
    String sub = "";
    String name;
    
    public FQCN(String tag) {
        if (tag.contains(".")) {
            int dotCount = getDotCount(tag);
            if (dotCount == 1) {
                root = tag.substring(0,tag.indexOf("."));
                name = tag.substring(tag.indexOf(".") + 1);
            } else if (dotCount == 2) {
                int first = tag.indexOf(".");
                int second = tag.indexOf(".",first + 1);
                root = tag.substring(0,first);
                domain = tag.substring(first + 1,second);
                name = tag.substring(second + 1);
            } else if (dotCount > 2) {
                int first = tag.indexOf(".");
                int second = tag.indexOf(".",first + 1);
                int last = tag.lastIndexOf(".");
                root = tag.substring(0,first);
                domain = tag.substring(first + 1, second);
                sub = tag.substring(second + 1, last);
                name = tag.substring(last + 1);
            }
        } else {
            name = tag;
        }
    }
    
    public int getDotCount(String tag) {
        int count = 0;
        for(int i = 0; i < tag.length();i++) {
            if (tag.charAt(i) == '.') count++;
        }
        return count;
    }
 
    public String getDomain() { return domain; }
    
    public String getFQCN() {
        String fqcn = "";
        if (!root.equals("")) {
            fqcn += root + ".";
        }
        if (!domain.equals("")) {
            fqcn += domain + ".";
        }
        if (!sub.equals("")) {
            fqcn += sub + ".";
        }
        fqcn += name;
        return fqcn;
    }
    
    public String getName() { return name; }
    
    public String getRoot() { return root; }
    
    public String getSub() { return sub; }
    
    public void print() {
        if (!root.equals("")) System.out.println("Root  : " + root);
        if (!domain.equals("")) System.out.println("Domain: " + domain);
        if (!sub.equals("")) System.out.println("Sub   : " + sub);
        System.out.println("Name  : " + name);
        System.out.println("---------------------------------------------------");
    }
    
}
