package ca.tecreations.components;

import ca.tecreations.TColor;
import ca.tecreations.ImageTool;
import ca.tecreations.Pixel;
import ca.tecreations.Point;
import ca.tecreations.ProjectPath;
import ca.tecreations.interfaces.Paintable;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.util.List;

import javax.swing.*;

/**
 *
 * @author Tim
 */
public class ImagePanel extends Movable implements Paintable {

    Image image = null;
    int tx = 0;
    int ty = 0;
    TColor xColor = null;
    boolean debug = false;
    boolean tiledBackground = false;

    public ImagePanel() {
        super(NONE);
        setSize(100,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          100);
    }

    public ImagePanel(Dimension size) {
        super(NONE);
        setSize(size);
    }

    public ImagePanel(Image image) {
        super(NONE);
        setImage(image, true);
    }

    public ImagePanel(ImageIcon icon) {
        super(NONE);
        setImage(icon.getImage(), true);
    }
    
    //--------------------------------------------------------------------------

    public TColor extract(Point p) {
        int[] pix = new int[1];
        PixelGrabber pixelGrabber = new PixelGrabber(image, p.x, p.y, 1, 1, pix, 0, 1);
        try {
            pixelGrabber.grabPixels();
        } catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return null;
        }
        if ((pixelGrabber.getStatus() & ImageObserver.ABORT) != 0) {
            System.err.println("image fetch errored or aborted");
            return null;
        }
        return new TColor(pix[0]);
    }

    public Point getTecLocation() {
        java.awt.Point loc = getLocation();
        return new Point(loc);
    }

    public static void main(String[] args) {
        TFrame frame = new TFrame(ProjectPath.INSTANCE.getPropertiesPath() + "ImagePanel.properties", "ImagePanelTestFrame");
        frame.setLayout(new BorderLayout());
        JPanel sizer = new JPanel();
        frame.add(sizer);
        frame.validate();
        Dimension size = sizer.getSize();
        frame.remove(sizer);
        ImagePanel imagePanel = new ImagePanel(size);
//        imagePanel.setImage(new LoadCursor().getCursorByIndex(32516), false);
        //imagePanel.setImage(ImageTool.getImage("f:\\ADarkerPurple.png"), false);
        imagePanel.setTXY(new Point(50, 50));
        frame.add(imagePanel);
        imagePanel.setXColor(TColor.red);
        frame.validate();
        frame.setVisible(true);
    }

    public void paint(Graphics g) {
        doPainting(getGraphics());
    }
    public void paintTiledBackground(Graphics g, int width, int height) {
        boolean paint = false;
        Dimension size = getSize();
        for (int i = 0; i < size.width - 1; i += width) {
            for (int j = 0; j < size.height - 1; j += height) {
                if (paint) {
                    g.fillRect(i, j, width, height);
                }
                paint = !paint;
            }
            paint = !paint;
        }
    }

    public void doPainting(Graphics g) {
        if (debug) {
            System.out.println("ImagePanel.paint()");
        }
        if (g == null) g = getGraphics();
        if (g == null) return;
        if (getBackground() == null) {
            g.setColor(TColor.LIGHT_GREY);
        } else {
            g.setColor(getBackground());
        }
        if (tiledBackground) {
            paintTiledBackground(g, 16, 16);
        } else {
            g.fillRect(0,0,width,height);
        }

        if (image != null) {
            g.drawImage(image,0,0,this);
        }

        if (xColor != null) {
            g.setColor(xColor);
            g.drawLine(0, 0, getSize().width - 1, getSize().height - 1);
            g.drawLine(0, getSize().height - 1, getSize().width - 1, 0);
        }
    }

    public void setImage(Image image, boolean resize) {
        this.image = image;
        if (image != null && resize) {
            setSize(image.getWidth(this), image.getHeight(this));
        }
        repaint();
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        tiledBackground = false;
    }

    public void setTiledBackground(boolean tile) {
        tiledBackground = tile;
        repaint();
    }

    public void setTXY(Point p) {
        tx = p.x;
        ty = p.y;
    }

    public void setTXY(int tx, int ty) {
        this.tx = tx;
        this.ty = ty;
    }

    public void setXColor(Color color) {
        xColor = new TColor(color);
    }
}
