package ca.tecreations.apps.filetool;

import ca.tecreations.File;
import ca.tecreations.Pair;
import ca.tecreations.Platform;
import ca.tecreations.StringTool;
import ca.tecreations.TextFile;
import ca.tecreations.components.JobProgressDialog;
import ca.tecreations.components.ProgressDialog;
import ca.tecreations.net.backup.TLSClient_TVS12;

import java.util.List;

/**
 *
 * @author Tim
 */
public class Get extends Thread {
    FileTool app;
    TextFile log;
    TLSClient_TVS12 client;
    String root;
    String srcPath;
    List<String> names;
    Long size;
    String dstPath;
    String unwrappedDst;
    String targetSeparator;
    boolean done = false;
    
    public Get(FileTool app,TextFile log, TLSClient_TVS12 client,String root,String srcPath, List<String> names,long size, String dst,String targetSeparator) {
        this.app = app;
        this.log = log;
        client.setLog(log);
        doLogAction("Get: host: " + client.getHostName() + " size: " + size + " dst: " + dst + " names(" + names.size() + "): " + names);
        this.client = client;
        this.root = root;
        this.srcPath = srcPath;
        this.names = names;
        this.size = size;
        this.dstPath = new File(dst).getAbsolutePath();
        this.targetSeparator = targetSeparator;
        unwrappedDst = StringTool.getUnwrapped(dstPath);
    }
    
    public void doLogAction(String msg) {
        if (log != null) log.add(msg);
        else System.out.println(msg);
    }
    
    public Pair getDirsAndFiles(List<String> names) {
        int dirs = 0;
        int files = 0;
        for(int i = 0; i < names.size();i++) {
            String unwrapped = StringTool.getUnwrapped(names.get(i));
            if (unwrapped.endsWith("/") || unwrapped.endsWith("\\")) {
                dirs++;
            } else {
                files++;
            }
        }
        return new Pair(dirs,files);
    }
    
    public String getItemCount(Pair pair) {
        String data = "";
        int dirs = (Integer)pair.getLeft();
        int files = (Integer)pair.getRight();
        if (dirs > 0) {
            if (dirs > 1) {
                data += " " + dirs + " Directories ";
            } else {
                data += " 1 Directory ";
            }
            if (files > 0) {
                if (files > 1) {
                    data += " and " + files + " Files";
                } else {
                    data += " and 1 File";
                }
            }
        } else {
            data += " " + files + " Files";
        }
        return data;
    }
    
    public boolean isDone() { return done; }
    
    public void run() {
        client.mkdirs(dstPath);
        
        // process for single item
        String target;
        if (names.size() == 1) {
            target = names.get(0);
            File src = new File(target); 
            String unwrappedSrc = src.getUnwrapped();
            if (unwrappedSrc.endsWith("/") || unwrappedSrc.endsWith("\\")) {
                ProgressDialog itemProgress = app.getProgressDialog();
                if (app != null) app.setProgress(itemProgress);
                itemProgress.setVisible(true);
                doLogAction("Get: getDirectory(1): size: " + size + " src: " + srcPath + " dst: " + dstPath);
                char srcSep = unwrappedSrc.charAt(unwrappedSrc.length() - 1);
                String subPath = src.getName() + srcSep;
                client.startJob(size);
                client.setLog(log);
                client.getDirectory(root,subPath,srcPath,dstPath,targetSeparator,itemProgress);
                itemProgress.setVisible(false);
            } else {
                ProgressDialog itemProgress = app.getProgressDialog();
                if (app != null) app.setProgress(itemProgress);
                String newDst = StringTool.getDoubleQuoted(unwrappedDst + src.getName());
                itemProgress.setVisible(true);
                doLogAction("Get: getFile(1): src: " + target + " dst: " + newDst);
                client.getFile(log,target,newDst,itemProgress);
                itemProgress.setVisible(false);
            }
        } else {
            JobProgressDialog jobProgress = app.getJobProgressDialog();
            if (app != null) app.setProgress(jobProgress);
            jobProgress.setVisible(true);
            Platform.sleep(250); // give the user time to read the message
            client.startJob(size);
            
            Pair vals = getDirsAndFiles(names);
            String title = "Get:";
            title += getItemCount(vals);
            jobProgress.setTitle(title);


            doLogAction("Get: names: " + names);
            
            for(int i = 0; i < names.size();i++) {
                target = names.get(i);
                File src = new File(names.get(i));
                String unwrappedSrc = src.getUnwrapped();
                if (unwrappedSrc.endsWith("/") || unwrappedSrc.endsWith("\\")) {
                    char srcSep = unwrappedSrc.charAt(unwrappedSrc.length() - 1);
                    doLogAction("Get: getDirectory(2) root: " + root + " src: " + srcPath + " dst: " + dstPath);
                    String subPath = src.getName() + srcSep;
                    client.setLog(log);
                    jobProgress.setJob("Directory: " + src.getName());
                    client.getDirectory(root,subPath,srcPath,dstPath,targetSeparator,jobProgress);
                } else {
                    String newDst = StringTool.getDoubleQuoted(unwrappedDst + src.getName());
                    doLogAction("Get: getFile(2) src: " + target + " dst: " + newDst);
                    jobProgress.setJob("File: " + unwrappedSrc);
                    client.getFile(log,target,newDst,jobProgress);
                    if (app != null) app.refreshLast();
                }
            }
            jobProgress.setVisible(false);
        }
        if (app != null) app.refreshLast();
        done = true;
    }
}
