package ca.tecreations.apps.deploy;

import ca.tecreations.File;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;
import javax.swing.event.*;

/**
 *
 * @author Tim de Vries
 */
public class Distribution extends JPanel implements ActionListener, DocumentListener,
        ItemListener {
    Deploy deployment;
    JLabel _prefix = new JLabel("Filename Prefix:");
    JTextField prefix = new JTextField(40);
    JCheckBox downloads = new JCheckBox(System.getProperty("user.home") + File.separator + "Downloads" + File.separator,false);
    JPanel holder = new JPanel(new BorderLayout());
    DefaultListModel<String> model = new DefaultListModel<String>();
    JList<String> paths = new JList<>(model); 
    // the model does, the list does, yet still have to cast
    
    // is there? a 'char' to "String"?
    // i do. return (ch + "" or "" + ch);
    
    JPanel bottom = new JPanel(new FlowLayout(FlowLayout.CENTER));
    JButton add = new JButton("Add");
    JButton remove = new JButton("Remove");
    
    public Distribution(Deploy deployment) {
        this.deployment = deployment;
        if (deployment.getProperties().wasCreated()) {
            doInitialSetup();
        } else {
            getProperties(deployment.getProperties());
        }
        setupGUI();
    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == add) {
            String path = Platform.requestDirectory(deployment.getTFrame(),
                                                    new File(ProjectPath.getProjectsHome()),
                                                    "Select a destination directory...");
            if (path != null) {
                // we know that has a file.separator
                if (path.toLowerCase().endsWith(File.separator + "jars" + File.separator)) {
                    model.addElement(path);
                } else {
                    model.addElement(path + "jars" + File.separator);
                }
                setProperties();
            }
        } else if (e.getSource() == remove) {
            model.removeElementAt(paths.getSelectedIndex());
        }
    }
     
    public void changedUpdate(DocumentEvent e) {
        setProperties();
    }
    
    public void doInitialSetup() {
        prefix.setText(deployment.getFilenamePrefix());
        downloads.setSelected(true);
        setProperties();
    }
    
    public void getProperties(Properties properties) {
        boolean set = false;
        String distPrefix = properties.get("distribution.prefix");
        if (distPrefix == null) {
            distPrefix = deployment.getFilenamePrefix();
            set = true;
        }
        prefix.setText(distPrefix);
        Boolean downloads = properties.getBoolean("copy.to.downloads");
        if (downloads == null) this.downloads.setSelected(false);
        else this.downloads.setSelected(downloads);
        List<String> list = properties.getList("copy.to.paths");
        for(int i = 0; i < list.size();i++) {
            if (!model.contains(list.get(i))) model.addElement(list.get(i));
        }
        if (set) setProperties();
    }
    
    public void insertUpdate(DocumentEvent e) {
        setProperties();
    }
    
    public void itemStateChanged(ItemEvent e) {
        Properties properties = deployment.getProperties();
        properties.set("copy.to.downloads",downloads.isSelected());
    }
    
    public void removeUpdate(DocumentEvent e) {
        setProperties();
    }
    
    public void setProperties() {
        Properties properties = deployment.getProperties();
        properties.set("distribution.prefix",prefix.getText());
        properties.set("copy.to.downloads",downloads.isSelected());
        List<String> paths = new ArrayList<>();
        int count = model.getSize();
        for(int i = 0;i < count;i++) {
            paths.add(model.getElementAt(i));
        }
        properties.set("copy.to.paths",paths);
    }
    
    public void setupGUI() {
        setLayout(new BorderLayout());
        JScrollPane scroller = new JScrollPane(paths,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        downloads.addItemListener(this);
        JPanel lineHolders = new JPanel(new BorderLayout());
        JPanel copyAs = new JPanel(new BorderLayout());
        copyAs.add(_prefix,BorderLayout.WEST);
        copyAs.add(prefix,BorderLayout.CENTER);
        lineHolders.add(copyAs,BorderLayout.NORTH);
        lineHolders.add(downloads,BorderLayout.SOUTH);
        add(lineHolders,BorderLayout.NORTH);
        add(scroller,BorderLayout.CENTER);
        bottom.add(add);
        bottom.add(remove);
        add.addActionListener(this);
        remove.addActionListener(this);
        add(bottom,BorderLayout.SOUTH);
    }

}
