package contrib.com.journaldev.mail;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jakarta.mail.Message;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;

  
 
public class EmailUtil {

        public static void sendEmail(Session session, String from, 
                                                      List<String> replyTo, 
                                                      List<String> to,
                                                      List<String> ccs, 
                                                      List<String> bccs, 
                                                      String subject, 
                                                      String body) {
            List<String> froms = new ArrayList<>();
            froms.add(from);
            sendEmail(session,froms,replyTo,to,ccs,bccs,subject,body);
        }
        
        public static void sendEmail(Session session, String from, 
                                                      String replyTo, 
                                                      List<String> to,
                                                      List<String> ccs, 
                                                      List<String> bccs, 
                                                      String subject, 
                                                      String body) {
            List<String> froms = new ArrayList<>();
            froms.add(from);
            List<String> replies = new ArrayList<>();
            replies.add(replyTo);
            sendEmail(session,froms,replies,to,ccs,bccs,subject,body);
        }
        
        public static void sendEmail(Session session, String from, 
                                                      String replyTo, 
                                                      List<String> to,
                                                      String subject, 
                                                      String body) {
            List<String> froms = new ArrayList<>();
            froms.add(from);
            List<String> replies = new ArrayList<>();
            replies.add(replyTo);
            sendEmail(session,froms,replies,to,new ArrayList<>(),new ArrayList<>(),subject,body);
        }
        
        public static void sendEmail(Session session, List<String> froms, 
                                                      String replyTo, 
                                                      List<String> to,
                                                      List<String> ccs, 
                                                      List<String> bccs, 
                                                      String subject, 
                                                      String body) {
            List<String> replies = new ArrayList<>();
            replies.add(replyTo);
            sendEmail(session,froms,replies,to,ccs,bccs,subject,body);
        }
        
        
        public static void sendEmail(Session session, String from, 
                                                      String replyTo, 
                                                      String to,
                                                      List<String> ccs, 
                                                      List<String> bccs, 
                                                      String subject, 
                                                      String body) {
            List<String> froms = new ArrayList<>();
            froms.add(from);
            List<String> replies = new ArrayList<>();
            replies.add(replyTo);
            List<String> tos = new ArrayList<>();
            tos.add(to);
            sendEmail(session,froms,replies,tos,ccs,bccs,subject,body);
        }
        
	/**
	 * Utility method to send simple HTML email
	 * @param session
	 * @param from
	 * @param replyTo -- List<String> replyTo addresses
         * @param to      -- List<String> to addresses
         * @param ccs     -- List<String> addresses to cc: to
         * @param bccs    -- List<String> addresses to bcc: to
	 * @param subject -- subject text
	 * @param body    -- body text
	 */
    
        public static void sendEmail(Session session, List<String> from, 
                                                      List<String> replyTo, 
                                                      List<String> to,
                                                      List<String> ccs, 
                                                      List<String> bccs, 
                                                      String subject, 
                                                      String body) {
     	    try {
                
                MimeMessage msg = new MimeMessage(session);
	      //set message headers
                msg.addHeader("Content-type", "text/HTML; charset=UTF-8");
                msg.addHeader("format", "flowed");
                msg.addHeader("Content-Transfer-Encoding", "8bit");

                msg.setFrom(new InternetAddress("tim@tecreations.ca"));
                String replyList = "";
                int replySize = replyTo.size();
                for(int i = 0; i < replySize;i++) {
                    replyList += replyTo.get(i);
                    if (i < replySize - 1) replyList += ",";
                } 
                msg.setReplyTo(InternetAddress.parse(replyList, false));
                String toList = "";
                int toSize = to.size();
                for(int i = 0; i < toSize;i++) {
                    toList += to.get(i);
                    if (i < toSize - 1) toList += ",";
                }
                msg.setRecipients(Message.RecipientType.TO,InternetAddress.parse(toList, false));
                
                msg.setSubject(subject, "UTF-8");

                msg.setText(body, "UTF-8");

                msg.setSentDate(new Date());

                msg.setRecipients(Message.RecipientType.TO, InternetAddress.parse(toList, false));
                System.out.println("Message is ready");

                // To get the array of ccaddresses
                for( int i = 0; i < ccs.size(); i++ ) {
                    msg.addRecipient(Message.RecipientType.CC, new InternetAddress(ccs.get(i)));
                }

                // To get the array of bccaddresses
                for( int i = 0; i < bccs.size(); i++ ) {
                    msg.addRecipient(Message.RecipientType.BCC, new InternetAddress(bccs.get(i)));
                }
                Transport.send(msg);  

	        System.out.println("Email(s) should have been sent successfully.");
	    } catch (Exception e) {
	      e.printStackTrace();
	    }
            
        }
}