package ca.tecreations.text;

import ca.tecreations.text.Parser;
import ca.tecreations.TextToken;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Tim
 */
public class JavaParser extends Parser {

    public JavaParser() {}
    
    public static boolean isJavaIdentifierCompatible(char ch) {
        return isEnglishLetter(ch) | isDigit(ch) | ch == '_';
    }
    
    public static boolean isKeyword(String s) {
        if (s != null) {
            if (s.length() > 0) {
                int length = s.length();
                if (length == 2) {
                    if (s.equals("do")) return true;
                    if (s.equals("if")) return true;
                } else if (length == 3) {
                    if (s.equals("for")) return true;
                    if (s.equals("int")) return true;
                    if (s.equals("new")) return true;
                } else if (length == 4) {
                    if (s.equals("byte")) return true;
                    if (s.equals("case")) return true;
                    if (s.equals("char")) return true;
                    if (s.equals("else")) return true;
                    if (s.equals("enum")) return true;
                    if (s.equals("goto")) return true;
                    if (s.equals("long")) return true;
                    if (s.equals("this")) return true;
                    if (s.equals("true")) return true;
                    if (s.equals("void")) return true;
                } else if (length == 5) {
                    if (s.equals("break")) return true;
                    if (s.equals("catch")) return true;
                    if (s.equals("class")) return true;
                    if (s.equals("const")) return true;
                    if (s.equals("false")) return true;
                    if (s.equals("final")) return true;
                    if (s.equals("float")) return true;
                    if (s.equals("short")) return true;
                    if (s.equals("super")) return true;
                    if (s.equals("throw")) return true;
                    if (s.equals("while")) return true;
                } else if (length == 6) {
                    if (s.equals("assert")) return true;
                    if (s.equals("double")) return true;
                    if (s.equals("import")) return true;
                    if (s.equals("native")) return true;
                    if (s.equals("public")) return true;
                    if (s.equals("record")) return true;
                    if (s.equals("return")) return true;
                    if (s.equals("static")) return true;
                    if (s.equals("switch")) return true;
                    if (s.equals("throws")) return true;
                } else if (length == 7) {
                    if (s.equals("boolean")) return true;
                    if (s.equals("default")) return true;
                    if (s.equals("extends")) return true;
                    if (s.equals("finally")) return true;
                    if (s.equals("package")) return true;
                    if (s.equals("private")) return true;
                } else if (length == 8) {
                    if (s.equals("continue")) return true;
                    if (s.equals("strictfp")) return true;
                    if (s.equals("volatile")) return true;
                } else if (length == 9) {
                    if (s.equals("interface")) return true;
                    if (s.equals("protected")) return true;
                    if (s.equals("transient")) return true;
                } else if (length == 10) {
                    if (s.equals("implements")) return true;
                    if (s.equals("instanceof")) return true;
                } else if (length == 12) {
                    if (s.equals("synchronized")) return true;
                }
            }
        }
        return false;
    }

    public static boolean isJavaLangString(String s) {
        return s.equals("java.lang.String");
    }
    
    public boolean isMixed(String s) {
        for(int i = 0; i < s.length();i++) {
            if (!isJavaIdentifierCompatible(s.charAt(i))) {
                return false;
            }
        }
        return true;
    }
    
    public static boolean isNull(String s) { return s.equals('\0') || s.equals("null"); }
    
    public static boolean isOperatorChar(char ch) {
        if (ch == '=') return true;
        if (ch == '>') return true;
        if (ch == '<') return true;
        if (ch == '!') return true;
        if (ch == '-') return true;
        if (ch == '?') return true;
        if (ch == ':') return true;
        if (ch == '+') return true;
        if (ch == '-') return true;
        if (ch == '*') return true;
        if (ch == '/') return true;
        if (ch == '&') return true;
        if (ch == '|') return true;
        if (ch == '^') return true;
        if (ch == '%') return true;
        return false;
    }
    
    public static boolean is2CharOperator(char c1, char c2) {
        if (c1 == '-' && c2 == '>') return true;
        if (c1 == '-' && c2 == '>') return true;
        if (c1 == '-' && c2 == '>') return true;
        if (c1 == '-' && c2 == '>') return true;
        if (c1 == '+' && c2 == '=') return true;
        if (c1 == '>' && c2 == '=') return true;
        if (c1 == '<' && c2 == '=') return true;
        if (c1 == '&' && c2 == '&') return true;
        if (c1 == '|' && c2 == '|') return true;
        if (c1 == '+' && c2 == '+') return true;
        if (c1 == '-' && c2 == '-') return true;
        if (c1 == '<' && c2 == '<') return true;
        if (c1 == '>' && c2 == '>') return true;
        if (c1 == '+' && c2 == '=') return true;
        if (c1 == '-' && c2 == '=') return true;
        if (c1 == '*' && c2 == '=') return true;
        if (c1 == '/' && c2 == '=') return true;
        if (c1 == '&' && c2 == '=') return true;
        if (c1 == '!' && c2 == '=') return true;
        if (c1 == '^' && c2 == '=') return true;
        if (c1 == '%' && c2 == '=') return true;
        return false;
    }
    
    public static boolean is3CharOperator(char c1, char c2, char c3) {
        if (c1 == '>' && c2 == '>' && c3 == '>') return true;
        if (c1 == '<' && c2 == '<' && c3 == '=') return true;
        if (c1 == '>' && c2 == '>' && c3 == '=') return true;
        return false;
    }
    
    public static boolean is4CharOperator(char c1, char c2, char c3,char c4) {
        if (c1 == '>' && c2 == '>' && c3 =='>' && c4 =='=') return true;
        return false;
    }
        
    public static boolean isSeparator(String s) {
        if (s.equals("(")) return true;
        if (s.equals(")")) return true;
        if (s.equals("{")) return true;
        if (s.equals("}")) return true;
        if (s.equals("[")) return true;
        if (s.equals("]")) return true;
        if (s.equals(";")) return true;
        if (s.equals(",")) return true;
        if (s.equals(".")) return true;
        if (s.equals("...")) return true;
        if (s.equals("@")) return true;
        if (s.equals("::")) return true;
        return false;
    }

    public static boolean isSeparatorChar(char ch) {
        if (ch == '(') return true;
        if (ch == ')') return true;
        if (ch == '{') return true;
        if (ch == '}') return true;
        if (ch == '[') return true;
        if (ch == ']') return true;
        if (ch == ';') return true;
        if (ch == ',') return true;
        if (ch == '.') return true;
        if (ch == '@') return true;
        if (ch == ':') return true;
        return false;
    }
    
    public boolean isString(String s) {
        return s.equals("String") || s.equals("java.lang.String");
    }
    
    public List<TextToken> parse(String line) {
        return new ArrayList<>();
    }
    
}
