package ca.tecreations.net;

import ca.tecreations.*;
import ca.tecreations.components.event.ProgressListener;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.net.URL;
import java.net.URLConnection; 
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
/*
 *
 * @author Tim
 */
public class Internet {
    public static final String SN = Internet.class.getSimpleName();
    URL url = null;
    URLConnection conn = null;
    
    public Internet(String url) throws MalformedURLException, IOException {
        this.url = new URL(url);
        this.conn = this.url.openConnection();
    }
    
    public static void download_HTTP(String urlPart,String dstPath) {
        BufferedInputStream in = null;
        FileOutputStream out = null;
        byte dataBuffer[] = new byte[61440];
        int bytesRead;
        
        try {
            in = new BufferedInputStream(new URL("http://" + urlPart).openStream());
            out = new FileOutputStream(dstPath);
            while ((bytesRead = in.read(dataBuffer, 0,dataBuffer.length)) != -1) {
                out.write(dataBuffer, 0, bytesRead);
            }
        } catch (IOException e) {
            ExceptionHandler.handleIO("Platform.download_HTTP",e.getMessage(), e,false);
        }           
    }
    
    public static void download_HTTPS(String urlPart, String dstPath) {
        download_HTTPS(urlPart,dstPath,null); // no progressListener
    }
    
    public static void download_HTTPS(String urlPart, String dstPath, ProgressListener pl) {
        if (pl == null) System.out.print("Downloaded: 0%");
        else pl.addItem("Downloaded: 0%");
        
        long srcSize;
        long written = 0;
        int percent = 0;
        URL url = null;
        try {
            url = new URL("https://" + urlPart);
        } catch (MalformedURLException murle) {
            ExceptionHandler.handle("Platform.download_HTTPS", murle);
        }
        URLConnection connection = null;
        BufferedInputStream is = null;
        FileOutputStream fos = null;
        try {
            connection = url.openConnection();
            srcSize = connection.getContentLengthLong();
            is = new BufferedInputStream(connection.getInputStream());
            fos = new FileOutputStream(dstPath);
        } catch (IOException ioe) {
            ExceptionHandler.handleIO("Platform.download_HTTPS","conn: " + connection + " is: " + is + " fos: " + fos, ioe,false);
            return;
        }
        byte dataBuffer[] = new byte[61440];
        int bytesRead;
        
        try {
            while ((bytesRead = is.read(dataBuffer, 0,dataBuffer.length)) != -1) {
                fos.write(dataBuffer, 0, bytesRead);
                written += bytesRead;
                percent = (int)((double)written / (double)srcSize * (double)100);
                if (pl != null) pl.updateItem(percent);
                else {
                    System.out.print("\rDownloaded: " + percent + "%");
                    System.out.flush();
                }
            }
        } catch (IOException e) {
            ExceptionHandler.handleIO("Platform.download_HTTPS",e.getMessage(), e,false);
        }           
        System.out.println();
    }
    
    public URLConnection getConnection() { return conn; }
    
    public static String getHostname(String ip) {
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(ip);
            String host = addr.getHostName();
            return host;
        } catch (UnknownHostException uhe) {
            System.out.println("Internet.getHostname: Unknown host: " + uhe + " ip: " + ip);
        }
        return "-1";
      }
    
    public static String getHostIPAddress() {
        String ip = "127.0.0.1";
        try {
            ip = Internet.getLocalIP();
        } catch (UnknownHostException uhe) {
            System.out.println("Unable to resolve host, using localhost");
        }
        return ip;
    }
    
    public static String getHostIPAddresses(String tag) {
        InetAddress[] ips = null;
        try {
            ips = InetAddress.getAllByName(tag);
        } catch (UnknownHostException uhe) {
            System.out.println("Unable to resolve host, using localhost");
        }
        String result = "";
        for(int i = 0; i < ips.length - 1;i++) {
            result += ips[i] + ",";
        }
        if (ips.length > 0) {
            result += ips[ips.length - 1];
        }
        return result;
    }
    
    public static String getIPFor(String hostname) {
        InetAddress ip = null;
        try {
            ip = InetAddress.getByName(hostname);
        } catch (UnknownHostException uhe) {
            System.err.println(SN + ".getIPFor: host: " + hostname + " : Unable to resolve host.");
            return null;
        }
        String result = ip.toString();
        if (result.contains("/")) {
            return result.substring(result.indexOf("/") + 1);
        } else {
            return result;
        }
    }
    
    /** 
     * @param url
     * @param pl ProgressListener
     * @return The last modified in @see TimsTime format.
     */
    public static String getLastModified(String url, ProgressListener pl) {
        Internet inet = null;
        try {
            inet = new Internet(url);
        } catch (MalformedURLException murle) {
            System.err.println("Malformed URL: " + url + " :: Don't put on a pl, this is the developer's responsibility, not the users.");
        } catch (IOException ioe) {
            pl.setItem("IO Exception: attempting: getLastModified(" + url + "): " + ioe);
        }
        if (inet != null) {
            Long dateTime = inet.getConnection().getLastModified();
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(dateTime);
            Date date2 = calendar.getTime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String formattedDate = sdf.format(date2);
            ZonedDateTime modified = ZonedDateTime.ofInstant(Instant.ofEpochMilli(dateTime), ZoneId.of("GMT"));   

            DateTimeFormatter timeFormatter = 
                    DateTimeFormatter.ofPattern("HH:mm:ss:S");
            DateTimeFormatter zoneFormatter = 
                    DateTimeFormatter.ofPattern("Z");
        
            return "D" + formattedDate + "T" + modified.format(timeFormatter) + "Z" + modified.format(zoneFormatter);
        } 
        return "Unknown";
    }
    
    public static String getLanIp() { return getLanIP(); }
    
    public static String getLanIP() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String ipAddress = localHost.getHostAddress();
            return ipAddress;
        } catch (UnknownHostException e) {
            System.err.println("Error getting local IP address: " + e.getMessage());
        }    
        return "-1";
    }
    
    public static String getLocalIp() throws UnknownHostException {
        return getLocalIP();
    }
    
    public static String getLocalIP() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }
    
    public static String getPublicIp() {
        return getPublicIP();
    }
    
    public static String getPublicIP() {
        String urlString = "https://api.ipify.org";
        URL url = null;
        try {
            url = new URL(urlString);
        } catch (MalformedURLException murle) {
            System.err.println("Internet.getPublicIP: malformed: " + urlString);
        }
        if (url != null) {
            String ipAddress = "-1";
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
                ipAddress = br.readLine();
                br.close();
            } catch (IOException ioe) {
                System.out.println("Internet.getPublicIP: retrieving IP: " + ioe);
            }
            return ipAddress;
        }
        return null;
    }
    
    public static String getRemoteAddr() {
        String urlString = "https://api.ipify.org";
        boolean useTecreations = true;
        if (useTecreations) urlString = "https://tecreations.ca/ca/tecreations/api/get_remote_addr.php";
        URL url = null;
        try {
            url = new URL(urlString);
        } catch (MalformedURLException murle) {
            System.err.println("Internet.getPublicIP: malformed: " + urlString);
        }
        if (url != null) {
            String ipAddress = "-1";
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
                ipAddress = br.readLine();
                br.close();
            } catch (IOException ioe) {
                System.out.println("Internet.getPublicIP: retrieving IP: " + ioe);
            }
            return ipAddress;
        }
        return null;
    }
    
    public static String getWanIp() {
        return getPublicIP();
    }
    
    public static String getWanIP() {
        return getPublicIP();
    }
    
    public static boolean isIP(String label) {
        int dots = 0;
        char ch;
        for (int i = 0; i < label.length(); i++) {
            ch = label.charAt(i);
            if (ch == '.') {
                dots++;
            } else if (!(ch >= '0' && ch <= '9')) {
                return false;
            }
        }
        if (dots < 3) {
            return false;
        }
        StringBuffer buf;
        int index = 0;
        for (int i = 0; i < 4; i++) {
            buf = new StringBuffer();
            while (index < label.length() && label.charAt(index) != '.') {
                buf.append(label.charAt(index++));
            }
            index++;
            Integer val = Integer.valueOf(buf.toString());
            if (!(val >= 0 && val <= 255)) {
                return false;
            }
        }
        return true;
    }
    
    public static void linuxMint_getLanIP() {
        List<SystemToken> routes = TecData.st.runForOutput("/usr/sbin/ip route",false);
        //for(int i = 0; i < routes.size();i++ ) {
        //    routes.get(i).print();
        //}
        
        String cmd = "/usr/bin/bash " + ProjectPath.getProjectPath() + File.getSubPath("ca.tecreations.net") + "get_nix_ip.sh";
        List<SystemToken> output = TecData.st.runForOutput(cmd, false);
        String raw;
        for(int i = 0; i < output.size();i++) {
            raw = output.get(i).getRaw();
//            System.out.println("output[" + i + "]: " + raw);
            List<String> exploded = StringTool.explode(raw,' ');
            
//            System.out.println("exploded(-999): " + exploded);
            
            if (exploded.get(0).equals("default")) {
                System.out.println(exploded.get(8));
            }

            
            
        }
    }

    public static void main(String[] args) {
        boolean print = false;
        if (print) {
            try {
                System.out.println("Public IP : " + getPublicIP());
                System.out.println("Local IP  : " + getLocalIP());
                System.out.println("LAN IP    : " + getLanIP());
                System.out.println("host (wan): " + getHostname(getPublicIP()));
            } catch (UnknownHostException uhe) {
                System.out.println(uhe);
            }
        }
        linuxMint_getLanIP();
    }
    
    public static boolean urlExists(String _url) throws MalformedURLException, IOException {
        URL url = new URL(_url);
        HttpURLConnection huc = (HttpURLConnection) url.openConnection();
        huc.setRequestMethod("HEAD");
        return (huc.getResponseCode() == HttpURLConnection.HTTP_OK);
    }    
}
