package ca.tecreations.components;

import ca.tecreations.Platform;
import ca.tecreations.components.event.*;

import javax.swing.*;
/**
 *
 * @author tim
 */
public class JobProgressDialogTest extends JFrame implements ProgressListener {
    JobProgressDialog dialog;
    ProgressDialogTestThread thread = new ProgressDialogTestThread();
    
    public JobProgressDialogTest() {
        dialog = new JobProgressDialog(this);
        dialog.setVisible(true);
        thread.addListener(this);
        thread.start();
        int i = 0;
        while (thread.isRunning()) {
            dialog.setTitle("JPDTest: Testing... : " + i);
            dialog.setJob("Iterating... : " + i);
            dialog.setJobPercent(i);
            dialog.setItem("Iterating... : " + i);
            dialog.setItemPercent(i);
            i++;
            Platform.sleep(50);
        }
        Platform.sleep(500);
        dialog.setVisible(false);
        System.exit(0);
    }
    
    public void addItem(String s) {}
    
    public static void main(String[] args) {
        new JobProgressDialogTest();
    }
    
    public void setItem(String s) {
        dialog.setItem(s);
    }
    
    public void setJob(String s) {
        dialog.setJob(s);
    }
    
    public void update(String msg, int job, int item) {
        dialog.setTitle(msg);
        update(job,item);
    }
    
    public void update(int job, int item) {
        dialog.setJobPercent(job);
        dialog.setItemPercent(item);
    }

    public void updateItem(int item) {
        dialog.setItemPercent(item);
    }

    public void updateJob(int job) {
        dialog.setJobPercent(job);
    }
}
